/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.kernel.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vtp.framework.kernel.api.Application;
import org.eclipse.vtp.framework.kernel.api.ApplicationManager;
import org.eclipse.vtp.framework.kernel.core.DefaultApplication;
import org.eclipse.vtp.framework.kernel.core.KernelRegistry;
import org.eclipse.vtp.framework.kernel.core.ResourceGroup;

public class DefaultApplicationManager
implements ApplicationManager {
    private static final String DEFAULT_BRAND = "Default";
    private final KernelRegistry registry;
    private final Map applicationsByBrand = Collections.synchronizedMap(new HashMap());

    public DefaultApplicationManager(KernelRegistry registry) {
        this.registry = registry;
    }

    public Application getApplication(String brand, String contextPath) {
        Application application = null;
        application = (Application)this.applicationsByBrand.get(brand);
        if (application == null) {
            ResourceGroup applicationGroup = (ResourceGroup)this.registry.getResourceItem("openVXML/application/");
            ResourceGroup brandGroup = (ResourceGroup)applicationGroup.getResourceItem("Brands/" + brand + "/");
            if (brandGroup == null) {
                if (DEFAULT_BRAND.equals(brand)) {
                    return null;
                }
                return this.getApplication(DEFAULT_BRAND, contextPath);
            }
            ResourceGroup personasGroup = (ResourceGroup)this.registry.getResourceItem("openVXML/personas/");
            try {
                application = new DefaultApplication(this.registry, brand, contextPath, applicationGroup, personasGroup);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            this.applicationsByBrand.put(brand, application);
        }
        return application;
    }
}

