/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.kernel.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.vtp.framework.api.Accessibility;
import org.eclipse.vtp.framework.api.AttachedDataPost;
import org.eclipse.vtp.framework.api.AttachedDataRequest;
import org.eclipse.vtp.framework.api.BArray;
import org.eclipse.vtp.framework.api.BComplexObject;
import org.eclipse.vtp.framework.api.BDecimal;
import org.eclipse.vtp.framework.api.BNumber;
import org.eclipse.vtp.framework.api.BObject;
import org.eclipse.vtp.framework.api.BObjectType;
import org.eclipse.vtp.framework.api.BString;
import org.eclipse.vtp.framework.api.Conversation;
import org.eclipse.vtp.framework.api.ExecutionFailure;
import org.eclipse.vtp.framework.api.ExecutionResult;
import org.eclipse.vtp.framework.api.Field;
import org.eclipse.vtp.framework.api.Interaction;
import org.eclipse.vtp.framework.api.Menu;
import org.eclipse.vtp.framework.api.Message;
import org.eclipse.vtp.framework.api.Post;
import org.eclipse.vtp.framework.api.Prompt;
import org.eclipse.vtp.framework.api.Request;
import org.eclipse.vtp.framework.infoserv.api.InformationService;
import org.eclipse.vtp.framework.infoserv.api.Reporter;
import org.eclipse.vtp.framework.kernel.api.Application;
import org.eclipse.vtp.framework.kernel.api.CallContext;
import org.eclipse.vtp.framework.kernel.api.CallManager;
import org.eclipse.vtp.framework.kernel.api.CallMediator;
import org.eclipse.vtp.framework.kernel.api.ConversationLifeCycleListener;
import org.eclipse.vtp.framework.kernel.api.Destination;
import org.eclipse.vtp.framework.kernel.api.DialogProducer;
import org.eclipse.vtp.framework.kernel.api.HookEndDestination;
import org.eclipse.vtp.framework.kernel.api.HookExecutionResult;
import org.eclipse.vtp.framework.kernel.api.Module;
import org.eclipse.vtp.framework.kernel.api.ModuleDestination;
import org.eclipse.vtp.framework.kernel.core.DefaultModule;
import org.eclipse.vtp.framework.kernel.core.Resource;
import org.eclipse.vtp.framework.kernel.core.ResourceGroup;
import org.eclipse.vtp.framework.kernel.spi.BusinessObjectDefinition;
import org.eclipse.vtp.framework.kernel.spi.BusinessObjectField;
import org.eclipse.vtp.framework.kernel.spi.FieldType;
import org.eclipse.vtp.framework.kernel.spi.GenericVoicePlatform;
import org.eclipse.vtp.framework.kernel.spi.GrammarSolver;
import org.eclipse.vtp.framework.kernel.spi.Kernel;
import org.eclipse.vtp.framework.kernel.spi.KernelDialog;
import org.eclipse.vtp.framework.kernel.spi.KernelPost;
import org.eclipse.vtp.framework.kernel.spi.KernelRequest;
import org.eclipse.vtp.framework.kernel.spi.KernelSnapshot;
import org.eclipse.vtp.framework.kernel.spi.MediaRenderer;
import org.eclipse.vtp.framework.kernel.spi.PlatformException;
import org.eclipse.vtp.framework.kernel.spi.PromptSolver;
import org.eclipse.vtp.framework.kernel.spi.VoicePlatform;
import org.eclipse.vtp.framework.widgets.WidgetDocument;
import org.eclipse.vtp.framework.widgets.vxml.Dialog;
import org.eclipse.vtp.framework.widgets.vxml.VXMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DefaultCallMediator
implements CallMediator,
Runnable {
    private CallContext callContext;
    private Application application;
    private LinkedList waitingActivities;
    private KernelRequest pendingRequest;
    private Conversation conversation;
    private Stack currentModules;
    private RuntimeException pendingException;
    private List lifeCycleListeners;
    private boolean running = true;
    private boolean cleanedup = false;
    private MediaRenderer mediaRenderer;
    private Locale defaultLanguage;
    private Locale currentLanguage = null;
    private List availableLanguages;
    private Map businessObjectDefs = new HashMap();
    private InformationService informationService;
    private Reporter reporter;
    private VoicePlatform platform;
    Map variables = new HashMap();

    public DefaultCallMediator(CallContext callContext, Application application) {
        this.callContext = callContext;
        this.application = application;
        this.defaultLanguage = application.getDefaultLanguage();
        this.availableLanguages = application.getAvailableLanguages();
        this.currentLanguage = this.defaultLanguage;
        this.informationService = (InformationService)callContext.getValue("KERNEL_INFORMATION_SERVICE");
        this.reporter = this.informationService.createReporter();
        try {
            ResourceGroup coreBundle = application.getApplicationBundle();
            ResourceGroup businessObjectsGroup = (ResourceGroup)coreBundle.getResourceItem("Business Objects/");
            if (businessObjectsGroup != null) {
                List bods = businessObjectsGroup.getResources();
                int i = 0;
                while (i < bods.size()) {
                    Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(((Resource)bods.get(i)).getInputStream());
                    Element rootElement = document.getDocumentElement();
                    String name = rootElement.getAttribute("name");
                    BusinessObjectDefinition bod = new BusinessObjectDefinition(name);
                    NodeList nl = rootElement.getElementsByTagName("field");
                    int f = 0;
                    while (f < nl.getLength()) {
                        Element fieldElement = (Element)nl.item(f);
                        String fieldName = fieldElement.getAttribute("name");
                        String fieldInitialValue = fieldElement.getAttribute("initialValue");
                        NodeList dtnl = fieldElement.getElementsByTagName("data-type");
                        if (dtnl.getLength() > 0) {
                            FieldType fieldDataType = FieldType.load((Element)dtnl.item(0));
                            BusinessObjectField bof = new BusinessObjectField(fieldName, fieldDataType.getTypeName(), fieldDataType.isArray(), fieldInitialValue);
                            bod.addField(bof);
                        }
                        ++f;
                    }
                    this.businessObjectDefs.put(bod.getType(), bod);
                    ++i;
                }
            }
            BusinessObjectDefinition platformDef = new BusinessObjectDefinition("Platform");
            FieldType platformFieldType = FieldType.STRING;
            platformDef.addField(new BusinessObjectField("ANI", platformFieldType.getTypeName(), platformFieldType.isArray(), ""));
            platformDef.addField(new BusinessObjectField("DNIS", platformFieldType.getTypeName(), platformFieldType.isArray(), ""));
            platformDef.addField(new BusinessObjectField("Brand", platformFieldType.getTypeName(), platformFieldType.isArray(), ""));
            this.businessObjectDefs.put(platformDef.getType(), platformDef);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mediaRenderer = null;
        this.waitingActivities = new LinkedList();
        this.pendingRequest = null;
        this.conversation = new ConversationImpl();
        this.currentModules = new Stack();
        this.pendingException = null;
        this.lifeCycleListeners = new ArrayList();
        this.platform = new GenericVoicePlatform();
        Thread t = new Thread(this);
        t.setContextClassLoader(application.getClassLoader());
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            LinkedList linkedList;
            Destination destination = this.platform.getInitializer();
            while (destination != null) {
                if (destination instanceof ModuleDestination) {
                    destination = this.processModuleDestination((ModuleDestination)destination);
                    continue;
                }
                linkedList = this.waitingActivities;
                synchronized (linkedList) {
                    this.waitingActivities.add(destination);
                    this.waitingActivities.notifyAll();
                }
                destination = null;
            }
            destination = this.application.getEntryPoint();
            while (destination != null) {
                if (destination instanceof ModuleDestination) {
                    destination = this.processModuleDestination((ModuleDestination)destination);
                    continue;
                }
                linkedList = this.waitingActivities;
                synchronized (linkedList) {
                    this.waitingActivities.add(destination);
                    this.waitingActivities.notifyAll();
                }
                destination = null;
            }
            this.running = false;
            new Thread(new CleanupTimer(15000L)).start();
        }
        catch (Throwable t) {
            t.printStackTrace();
            new Thread(new CleanupTimer(1L)).start();
        }
    }

    protected Destination processModuleDestination(ModuleDestination destination) {
        while (destination != null) {
            Module currentModule = destination.getModule();
            Properties properties = new Properties();
            properties.setProperty("MODULE_NAME", currentModule.getName());
            this.reporter.report("ModuleEntry", 2, properties);
            this.currentModules.push(currentModule);
            Interaction interaction = currentModule.getInstance();
            Destination result = null;
            try {
                ExecutionResult er = interaction.execute(this.conversation);
                if (er instanceof ExecutionFailure) {
                    ((ExecutionFailure)er).getCause().printStackTrace();
                }
                result = er instanceof HookExecutionResult ? ((HookExecutionResult)er).getResultDestination() : currentModule.getEndPointDestination(er.getResultName());
            }
            catch (CallManager.TimeoutException timeoutException) {
                result = currentModule.getTimeoutDestination();
            }
            this.currentModules.pop();
            this.reporter.report("ModuleExit", 2, properties);
            if (result == null) {
                return null;
            }
            if (result instanceof ModuleDestination) {
                destination = (ModuleDestination)result;
                continue;
            }
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WidgetDocument getNextDocument(int waitTimeInSeconds) {
        WidgetDocument ret = null;
        LinkedList linkedList = this.waitingActivities;
        synchronized (linkedList) {
            int waitCount = 0;
            int maxWaitCount = waitTimeInSeconds * 4;
            while (waitCount < maxWaitCount && this.waitingActivities.size() < 1) {
                try {
                    this.waitingActivities.wait(250L);
                }
                catch (InterruptedException interruptedException) {}
                ++waitCount;
            }
            if (this.waitingActivities.size() > 0) {
                Object next = this.waitingActivities.get(0);
                if (next instanceof KernelDialog) {
                    if (next instanceof KernelRequest) {
                        this.pendingRequest = (KernelRequest)next;
                    } else {
                        this.waitingActivities.removeFirst();
                    }
                } else {
                    this.waitingActivities.removeFirst();
                }
                if (next instanceof DialogProducer) {
                    ret = this.buildDocument((String)this.callContext.getValue("KERNEL_CALL_ID"), ((DialogProducer)next).produceDialog((String)this.callContext.getValue("KERNEL_CALL_ID")));
                } else {
                    this.platform.buildDocument(next);
                }
            }
        }
        if (this.waitingActivities.size() == 0 && !this.running) {
            this.reporter.report("CallEnd", 2);
            this.cleanedup = true;
            Iterator iterator = this.lifeCycleListeners.iterator();
            while (iterator.hasNext()) {
                ((ConversationLifeCycleListener)iterator.next()).conversationEnded((String)this.callContext.getValue("KERNEL_CALL_ID"));
            }
        }
        return ret;
    }

    private WidgetDocument buildDocument(String conversationId, Dialog dialog) {
        VXMLDocument ret = null;
        VXMLDocument document = new VXMLDocument();
        document.addDialog(dialog);
        ret = document;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postResponse(Map responseData) {
        if (this.pendingRequest == null) {
            throw new RuntimeException("Recieved Response when no pending request is active!");
        }
        LinkedList linkedList = this.waitingActivities;
        synchronized (linkedList) {
            Object module = this.currentModules.peek();
            Properties properties = new Properties();
            properties.setProperty("MODULE_NAME", ((Module)module).getName());
            properties.setProperty("REQUEST_NAME", this.pendingRequest.getName());
            if (!this.pendingRequest.isValid(responseData)) {
                this.reporter.report("DataNoMatch", 0, properties);
            } else {
                Set set = responseData.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    String[] value = (String[])responseData.get(key);
                    StringBuffer valueBuf = new StringBuffer();
                    int i = 0;
                    while (i < value.length) {
                        valueBuf.append(String.valueOf(value[i]) + ",");
                        ++i;
                    }
                    valueBuf.deleteCharAt(valueBuf.length() - 1);
                    properties.setProperty(key, valueBuf.toString());
                }
                this.reporter.report("DataCollected", 2, properties);
                this.pendingRequest.complete(responseData);
                LinkedList linkedList2 = this.waitingActivities;
                synchronized (linkedList2) {
                    this.waitingActivities.removeFirst();
                    this.pendingRequest = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postNoInput() {
        if (this.pendingRequest == null) {
            throw new RuntimeException("Recieved Response when no pending request is active!");
        }
        Object module = this.currentModules.peek();
        Properties properties = new Properties();
        properties.setProperty("MODULE_NAME", ((Module)module).getName());
        properties.setProperty("REQUEST_NAME", this.pendingRequest.getName());
        this.reporter.report("DataNoInput", 0, properties);
        if (!this.pendingRequest.noInput()) {
            LinkedList linkedList = this.waitingActivities;
            synchronized (linkedList) {
                this.pendingRequest = null;
                this.waitingActivities.removeFirst();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postNoMatch() {
        if (this.pendingRequest == null) {
            throw new RuntimeException("Recieved Response when no pending request is active!");
        }
        Object module = this.currentModules.peek();
        Properties properties = new Properties();
        properties.setProperty("MODULE_NAME", ((Module)module).getName());
        properties.setProperty("REQUEST_NAME", this.pendingRequest.getName());
        this.reporter.report("DataNoMatch", 0, properties);
        if (!this.pendingRequest.noMatch()) {
            LinkedList linkedList = this.waitingActivities;
            synchronized (linkedList) {
                this.pendingRequest = null;
                this.waitingActivities.removeFirst();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postException(RuntimeException exception) {
        Module currentModule = null;
        if (this.currentModules.size() > 0) {
            currentModule = (Module)this.currentModules.peek();
        }
        if ("connection.disconnect.hangup".equals(exception.getMessage())) {
            Properties properties = new Properties();
            properties.setProperty("MODULE_NAME", currentModule.getName());
            this.reporter.report("CallAbandoned", 1, properties);
        }
        LinkedList linkedList = this.waitingActivities;
        synchronized (linkedList) {
            this.pendingException = exception;
            if (this.pendingRequest != null) {
                this.pendingRequest.throwException(exception);
            }
        }
    }

    public void registerLifeCycleListener(ConversationLifeCycleListener listener) {
        this.lifeCycleListeners.add(listener);
    }

    public CallContext getCallContext() {
        return this.callContext;
    }

    protected class ConversationImpl
    implements Conversation,
    Kernel {
        private ConversationImpl() {
        }

        public String getConfigurationProperty(String name) {
            return DefaultCallMediator.this.application.getConfigurationProperty(name);
        }

        public String[] getConfigurationPropertyNames() {
            return DefaultCallMediator.this.application.getConfigurationPropertyNames();
        }

        public String getBrand() {
            return DefaultCallMediator.this.application.getBrand();
        }

        public PromptSolver getPromptSolver() {
            return DefaultCallMediator.this.application.getPromptSolver();
        }

        public GrammarSolver getGrammarSolver() {
            return DefaultCallMediator.this.application.getGrammarSolver();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postInformation(KernelPost post) {
            if (DefaultCallMediator.this.pendingException != null) {
                throw DefaultCallMediator.this.pendingException;
            }
            LinkedList linkedList = DefaultCallMediator.this.waitingActivities;
            synchronized (linkedList) {
                DefaultCallMediator.this.waitingActivities.add(post);
                DefaultCallMediator.this.waitingActivities.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean requestInformation(KernelRequest request) {
            if (DefaultCallMediator.this.pendingException != null) {
                throw DefaultCallMediator.this.pendingException;
            }
            LinkedList linkedList = DefaultCallMediator.this.waitingActivities;
            synchronized (linkedList) {
                DefaultCallMediator.this.waitingActivities.add(request);
                DefaultCallMediator.this.waitingActivities.notifyAll();
            }
            return request.waitToComplete(180);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ExecutionResult executeHook(String hookName) {
            Destination destination;
            if (DefaultCallMediator.this.pendingException != null) {
                throw DefaultCallMediator.this.pendingException;
            }
            HookExecutionResult ret = null;
            Module currentModule = (Module)DefaultCallMediator.this.currentModules.peek();
            ModuleDestination hookDestination = currentModule.getHookDestination(hookName);
            if (hookDestination != null && hookDestination.getAccessability(DefaultCallMediator.this.conversation) == Accessibility.NORMAL && (destination = DefaultCallMediator.this.processModuleDestination(hookDestination)) != null) {
                ret = destination instanceof HookEndDestination ? null : new HookExecutionResult(destination);
            }
            while (DefaultCallMediator.this.waitingActivities.size() != 0) {
                try {
                    Object obj;
                    Object object = obj = new Object();
                    synchronized (object) {
                        obj.wait(100L);
                    }
                }
                catch (Exception exception) {}
            }
            return ret;
        }

        public Object getValue(String name) {
            if (DefaultCallMediator.this.pendingException != null) {
                throw DefaultCallMediator.this.pendingException;
            }
            return DefaultCallMediator.this.callContext.getValue(name);
        }

        public void putValue(String name, Object value) {
            if (DefaultCallMediator.this.pendingException != null) {
                throw DefaultCallMediator.this.pendingException;
            }
            DefaultCallMediator.this.callContext.setValue(name, value);
        }

        public Post createPost(String messageNamespace) {
            KernelPost post = DefaultCallMediator.this.platform.createPost(messageNamespace);
            this.initializeKernelPost(post);
            return post;
        }

        private void initializeKernelPost(KernelPost post) {
            post.setLanguage(this.getCurrentLanguage());
            post.setKernel(new KernelSnapshot(this));
            Module m = (Module)DefaultCallMediator.this.currentModules.peek();
            post.setCreator(m);
        }

        public Message createMessage() {
            Message message = DefaultCallMediator.this.platform.createMessage();
            if (!(message instanceof KernelPost)) {
                throw new PlatformException("Could not create messsage.");
            }
            this.initializeKernelPost((KernelPost)message);
            return message;
        }

        public Message createMessage(String dialogName) {
            Message ret = this.createMessage();
            ret.setDialogName(dialogName);
            return ret;
        }

        public Request createRequest(String requestNamespace) {
            KernelRequest request = DefaultCallMediator.this.platform.createRequest(requestNamespace);
            this.initializeKernelRequest(request);
            return request;
        }

        private void initializeKernelRequest(KernelRequest request) {
            request.setLanguage(this.getCurrentLanguage());
            request.setKernel(new KernelSnapshot(this));
            Module m = (Module)DefaultCallMediator.this.currentModules.peek();
            request.setCreator(m);
        }

        public Field createField() {
            Field field = DefaultCallMediator.this.platform.createField();
            if (!(field instanceof KernelRequest)) {
                throw new PlatformException("Could not create field.");
            }
            this.initializeKernelRequest((KernelRequest)field);
            return field;
        }

        public Field createField(String dialogName) {
            Field ret = this.createField();
            ret.setDialogName(dialogName);
            return ret;
        }

        public Menu createMenu() {
            Menu menu = DefaultCallMediator.this.platform.createMenu();
            if (!(menu instanceof KernelRequest)) {
                throw new PlatformException("Could not create menu.");
            }
            this.initializeKernelRequest((KernelRequest)menu);
            return menu;
        }

        public Menu createMenu(String dialogName) {
            Menu ret = this.createMenu();
            ret.setDialogName(dialogName);
            if (DefaultCallMediator.this.currentModules.peek() instanceof DefaultModule) {
                Document definition = ((DefaultModule)DefaultCallMediator.this.currentModules.peek()).getDefinition();
                Element root = definition.getDocumentElement();
                NodeList nl = root.getElementsByTagName("dialog");
                int i = 0;
                while (i < nl.getLength()) {
                    Element dialogElement = (Element)nl.item(i);
                    if ("menu".equals(dialogElement.getAttribute("type")) && dialogName.equals(dialogElement.getAttribute("name"))) {
                        NodeList optionList = dialogElement.getElementsByTagName("option");
                        int o = 0;
                        while (o < optionList.getLength()) {
                            Element optionElement = (Element)optionList.item(o);
                            ret.addChoice(optionElement.getAttribute("name"), Prompt.named((String)("option:" + optionElement.getAttribute("name"))), Integer.parseInt(optionElement.getAttribute("dtmf")));
                            ++o;
                        }
                    }
                    ++i;
                }
            }
            return ret;
        }

        public AttachedDataPost createAttachedDataPost() {
            AttachedDataPost attachedDataPost = DefaultCallMediator.this.platform.createAttachedDataPost();
            if (!(attachedDataPost instanceof KernelPost)) {
                throw new PlatformException("Could not create attached data post.");
            }
            this.initializeKernelPost((KernelPost)attachedDataPost);
            return attachedDataPost;
        }

        public AttachedDataRequest createAttachedDataRequest() {
            AttachedDataRequest attachedDataRequest = DefaultCallMediator.this.platform.createAttachedDataRequest();
            if (!(attachedDataRequest instanceof KernelRequest)) {
                throw new PlatformException("Could not create attached data request.");
            }
            this.initializeKernelRequest((KernelRequest)attachedDataRequest);
            return attachedDataRequest;
        }

        public Accessibility getAccessability(ExecutionResult destination) {
            Destination d = ((Module)DefaultCallMediator.this.currentModules.peek()).getEndPointDestination(destination.getResultName());
            if (d == null) {
                return Accessibility.ABSENT;
            }
            return d.getAccessability(this);
        }

        public Map getSettings() {
            return ((Module)DefaultCallMediator.this.currentModules.peek()).getSettings();
        }

        public MediaRenderer getMediaRenderer() {
            return DefaultCallMediator.this.mediaRenderer;
        }

        public List getAvailableLanguages() {
            return DefaultCallMediator.this.availableLanguages;
        }

        public Locale getDefaultLanguage() {
            return DefaultCallMediator.this.defaultLanguage;
        }

        public Locale getCurrentLanguage() {
            return DefaultCallMediator.this.currentLanguage;
        }

        public void setCurrentLanguage(Locale language) {
            DefaultCallMediator.this.currentLanguage = language;
        }

        public void logEvent(String eventName, String data) {
            Object module = DefaultCallMediator.this.currentModules.peek();
            Properties properties = new Properties();
            properties.setProperty("MODULE_NAME", ((Module)module).getName());
            properties.setProperty("CUSTOM_DATA", data);
            DefaultCallMediator.this.reporter.report(eventName, 2, properties);
        }

        public void logEvent(String eventName, Map data) {
            Object module = DefaultCallMediator.this.currentModules.peek();
            Properties properties = new Properties();
            properties.setProperty("MODULE_NAME", ((Module)module).getName());
            Set keyset = data.keySet();
            Iterator it = keyset.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                properties.setProperty(key, data.get(key).toString());
            }
            DefaultCallMediator.this.reporter.report(eventName, 2, properties);
        }

        public boolean namedPromptExists(String name) {
            return true;
        }

        public boolean audioFileExists(String name) {
            return true;
        }

        public BObject createObject(String name, String type, boolean array) {
            if (array) {
                return new BArray(new BObjectType(type, array, false), name);
            }
            if (type.equals("String")) {
                return new BString(name);
            }
            if (type.equals("Number")) {
                return new BNumber(name);
            }
            if (type.equals("Decimal")) {
                return new BDecimal(name);
            }
            if (type.equals("Boolean")) {
                return null;
            }
            if (type.equals("DateTime")) {
                return null;
            }
            BusinessObjectDefinition bod = (BusinessObjectDefinition)DefaultCallMediator.this.businessObjectDefs.get(type);
            if (bod != null) {
                BComplexObject ret = new BComplexObject(new BObjectType(bod.getType(), false, false), name);
                List fields = bod.getFields();
                int i = 0;
                while (i < fields.size()) {
                    BusinessObjectField bof = (BusinessObjectField)fields.get(i);
                    ret.addField(this.createObject(bof.getName(), bof.getType(), bof.isArray()));
                    ++i;
                }
                return ret;
            }
            return null;
        }

        public void registerVariable(BObject object) {
            DefaultCallMediator.this.variables.put(object.getName(), object);
        }

        public void registerVariable(String name, BObject object) {
            DefaultCallMediator.this.variables.put(name, object);
        }

        public BObject getVariable(String name) {
            return (BObject)DefaultCallMediator.this.variables.get(name);
        }

        public Map getVariables() {
            return DefaultCallMediator.this.variables;
        }

        public String getContextPath() {
            return (String)DefaultCallMediator.this.callContext.get("KERNEL_CONTEXT_PATH");
        }
    }

    private class CleanupTimer
    implements Runnable {
        private long toWait;

        public CleanupTimer(long toWait) {
            this.toWait = toWait;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            CleanupTimer cleanupTimer = this;
            synchronized (cleanupTimer) {
                try {
                    this.wait(this.toWait);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (!DefaultCallMediator.this.cleanedup) {
                Iterator iterator = DefaultCallMediator.this.lifeCycleListeners.iterator();
                while (iterator.hasNext()) {
                    ((ConversationLifeCycleListener)iterator.next()).conversationEnded((String)DefaultCallMediator.this.callContext.getValue("KERNEL_CALL_ID"));
                }
            }
        }
    }
}

