/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.kernel.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.vtp.framework.api.Interaction;
import org.eclipse.vtp.framework.kernel.api.Destination;
import org.eclipse.vtp.framework.kernel.api.Module;
import org.eclipse.vtp.framework.kernel.api.ModuleDestination;
import org.eclipse.vtp.framework.kernel.core.ResourceGroup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DefaultModule
implements Module {
    private ArrayList preconditions;
    private Map endPoints;
    private Map hooks;
    private Map settings;
    private String name;
    private String moduleGroupName;
    private String vendorName;
    private String moduleGroupVersion;
    private Class interactionClass;
    private Destination timeoutDestination;
    private ClassLoader moduleClassLoader;
    private String id;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DefaultModule(ClassLoader applicationClassLoader, ResourceGroup moduleBundle, String vendorName, String moduleGroupName, String moduleGroupVersion, String name, String id) throws Exception {
        this.id = id;
        this.moduleClassLoader = applicationClassLoader;
        this.name = name;
        this.moduleGroupVersion = moduleGroupVersion;
        this.moduleGroupName = moduleGroupName;
        this.vendorName = vendorName;
        this.preconditions = new ArrayList();
        this.endPoints = new HashMap();
        this.hooks = new HashMap();
        this.settings = new HashMap();
        String path = "META-INF/openVXML/" + name.replace(' ', '_') + "_" + moduleGroupVersion + ".xml";
        InputStream in = null;
        Document definition = null;
        try {
            in = this.moduleClassLoader.getResourceAsStream(path);
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            definition = builder.parse(in);
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            try {
                in.close();
                throw throwable;
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        {
            Object var13_17 = null;
        }
        try {}
        catch (Throwable throwable) {}
        in.close();
        Element documentRoot = definition.getDocumentElement();
        name = documentRoot.getAttribute("name");
        try {
            this.interactionClass = this.moduleClassLoader.loadClass(documentRoot.getAttribute("class-name"));
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not load module interaction class: ", cnfe);
        }
        NodeList nodeList = documentRoot.getElementsByTagName("preconditions");
        if (nodeList.getLength() <= 0) return;
        Element preconditionsElement = (Element)nodeList.item(0);
        nodeList = preconditionsElement.getElementsByTagName("preconditions");
        int i = 0;
        while (i < nodeList.getLength()) {
            Element preconditionElement = (Element)nodeList.item(i);
            try {
                Class<?> preconditionClass = this.moduleClassLoader.loadClass(preconditionElement.getAttribute("class-name"));
                this.preconditions.add(preconditionClass.newInstance());
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Could not load module precondition class: ", cnfe);
            }
            catch (InstantiationException ie) {
                throw new RuntimeException("Could not instantiate module precondition class: ", ie);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException("Could not instantiate module precondition class: ", iae);
            }
            ++i;
        }
        return;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document getDefinition() {
        InputStream in = null;
        try {
            block12: {
                in = this.moduleClassLoader.getResourceAsStream("META-INF/openVXML/" + this.name.replace(' ', '_') + "_" + this.moduleGroupVersion + ".xml");
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document document = builder.parse(in);
                Object var4_9 = null;
                try {
                    in.close();
                    return document;
                }
                catch (Throwable throwable) {}
                return document;
                catch (IOException e) {
                    e.printStackTrace();
                    break block12;
                }
                catch (FactoryConfigurationError e) {
                    e.printStackTrace();
                    break block12;
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                    break block12;
                }
                catch (SAXException e) {
                    e.printStackTrace();
                }
            }
            Object var4_11 = null;
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            try {}
            catch (Throwable throwable2) {}
            in.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (Throwable throwable) {
            return null;
        }
        in.close();
        return null;
    }

    public void addSetting(String name, Object value) {
        this.settings.put(name, value);
    }

    public List getPreconditions() {
        return Collections.unmodifiableList(this.preconditions);
    }

    public Interaction getInstance() {
        Interaction interaction = null;
        try {
            interaction = (Interaction)this.interactionClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return interaction;
    }

    public ModuleDestination getHookDestination(String hookName) {
        return (ModuleDestination)this.hooks.get(hookName);
    }

    public void registerHookDestination(String hookName, ModuleDestination destination) {
        this.hooks.put(hookName, destination);
    }

    public void registerEndPointDestination(String endPointName, Destination destination) {
        this.endPoints.put(endPointName, destination);
    }

    public Destination getEndPointDestination(String endPointName) {
        Destination ret = null;
        Object obj = this.endPoints.get(endPointName);
        if (obj != null) {
            ret = (Destination)obj;
        } else if (endPointName.lastIndexOf(46) != -1) {
            ret = this.getEndPointDestination(endPointName.substring(0, endPointName.lastIndexOf(46)));
        }
        return ret;
    }

    public void setTimeoutDestination(Destination timeoutDestination) {
        this.timeoutDestination = timeoutDestination;
    }

    public Destination getTimeoutDestination() {
        return this.timeoutDestination;
    }

    public Map getSettings() {
        return Collections.unmodifiableMap(this.settings);
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return String.valueOf(this.vendorName) + "." + this.moduleGroupName + "." + this.name + "." + this.moduleGroupVersion;
    }
}

