/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.kernel.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.vtp.framework.kernel.api.CallManager;
import org.eclipse.vtp.framework.kernel.core.DefaultCallManager;
import org.eclipse.vtp.framework.kernel.core.KernelRegistry;
import org.eclipse.vtp.framework.widgets.WidgetDocument;

public class HTTPConnector
extends HttpServlet {
    private static final String KERNEL_CALL_ID = "KERNEL_CALL_ID";
    private static final String DEFAULT_BRAND = "Default";
    private static final String SLASH = "/";
    private static final String MIME_TYPE_TEXT_XML = "text/xml";
    private static final long serialVersionUID = 1L;
    private CallManager callManager = null;
    static /* synthetic */ Class class$0;

    public void init(ServletConfig config) throws ServletException {
        KernelRegistry registry;
        super.init(config);
        ServletContext servletContext = config.getServletContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.vtp.framework.kernel.core.KernelRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((registry = (KernelRegistry)servletContext.getAttribute(clazz.getName())) == null) {
            throw new ServletException("No kernel registry configured");
        }
        this.callManager = new DefaultCallManager(registry);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String brand;
        HashMap<String, String[]> parameterMap;
        WidgetDocument document;
        block15: {
            document = null;
            parameterMap = new HashMap<String, String[]>();
            Enumeration e = request.getParameterNames();
            while (true) {
                if (!e.hasMoreElements()) {
                    brand = request.getPathInfo();
                    if (brand != null) {
                        break;
                    }
                    break block15;
                }
                String key = (String)e.nextElement();
                parameterMap.put(key, request.getParameterValues(key));
            }
            while (brand.startsWith(SLASH)) {
                brand = brand.substring(1);
            }
            while (brand.endsWith(SLASH)) {
                brand = brand.substring(0, brand.length() - 1);
            }
        }
        if (brand == null || brand.length() == 0) {
            brand = DEFAULT_BRAND;
        }
        parameterMap.put("BRAND", new String[]{brand});
        parameterMap.put("KERNEL_CONTEXT_PATH", new String[]{request.getContextPath()});
        String callId = request.getParameter(KERNEL_CALL_ID);
        try {
            document = callId == null || callId.length() == 0 ? this.callManager.initializeCall(parameterMap) : this.callManager.continueCall(callId, parameterMap);
        }
        catch (Throwable t) {
            this.getServletContext().log("Failed to process call: " + t.getMessage(), t);
            response.sendError(500, t.getMessage());
            return;
        }
        if (document == null) {
            this.getServletContext().log("No VXML output generated");
            response.sendError(500);
            return;
        }
        response.setContentType(MIME_TYPE_TEXT_XML);
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            PrintStream ps = new PrintStream((OutputStream)out);
            document.writeDocument(ps);
            ps.flush();
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (out == null) return;
        out.close();
    }
}

