/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.kernel.modules;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.framework.api.BObject;
import org.eclipse.vtp.framework.api.Conversation;
import org.eclipse.vtp.framework.api.ExecutionFailure;
import org.eclipse.vtp.framework.api.ExecutionResult;
import org.eclipse.vtp.framework.api.Interaction;
import org.eclipse.vtp.framework.kernel.api.Destination;
import org.eclipse.vtp.framework.kernel.api.Module;
import org.eclipse.vtp.framework.kernel.api.ModuleDestination;
import org.w3c.dom.Element;

public class DecisionModule
implements Module {
    private String id;
    private int lType = 0;
    private String lValue = "";
    private int compType = 0;
    private int rType = 0;
    private String rValue = "";
    Map hooks = new HashMap();
    Map endPoints = new HashMap();

    public DecisionModule(String id) {
        this.id = id;
    }

    public void addSetting(String name, Object value) {
    }

    public List getPreconditions() {
        return new ArrayList();
    }

    public void readSettings(Element element) {
        this.lType = Integer.parseInt(element.getAttribute("lType"));
        this.lValue = element.getAttribute("lValue");
        this.compType = Integer.parseInt(element.getAttribute("cType"));
        this.rType = Integer.parseInt(element.getAttribute("rType"));
        this.rValue = element.getAttribute("rValue");
    }

    public Interaction getInstance() {
        return new FieldInteraction();
    }

    public ModuleDestination getHookDestination(String hookName) {
        return (ModuleDestination)this.hooks.get(hookName);
    }

    public void registerHookDestination(String hookName, ModuleDestination destination) {
        this.hooks.put(hookName, destination);
    }

    public void registerEndPointDestination(String endPointName, Destination destination) {
        this.endPoints.put(endPointName, destination);
    }

    public Destination getEndPointDestination(String endPointName) {
        return (Destination)this.endPoints.get(endPointName);
    }

    public void setTimeoutDestination(Destination timeoutDestination) {
    }

    public Destination getTimeoutDestination() {
        return null;
    }

    public Map getSettings() {
        return new HashMap();
    }

    public String getName() {
        return "Field";
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return "builtin.decision.1_0_0_0";
    }

    public class FieldInteraction
    implements Interaction {
        public ExecutionResult execute(Conversation conversation) {
            int i;
            BObject var;
            String[] parts;
            ExecutionResult retTrue = ExecutionResult.success((String)"True");
            ExecutionResult retFalse = ExecutionResult.success((String)"False");
            ExecutionFailure retError = ExecutionResult.failure((String)"error.javascript");
            Object lValueObject = null;
            Object rValueObject = null;
            if (DecisionModule.this.lType == 0) {
                parts = DecisionModule.this.lValue.split("\\.");
                var = conversation.getVariable(parts[0]);
                if (var == null) {
                    return retError;
                }
                i = 1;
                while (i < parts.length) {
                    if ((var = var.getField(parts[i])) == null) {
                        return retError;
                    }
                    ++i;
                }
                if (!var.getType().hasValue()) {
                    return retError;
                }
                lValueObject = var.getValue();
            } else {
                lValueObject = DecisionModule.this.lValue;
            }
            if (DecisionModule.this.rType == 0) {
                parts = DecisionModule.this.rValue.split("\\.");
                var = conversation.getVariable(parts[0]);
                if (var == null) {
                    return retError;
                }
                i = 1;
                while (i < parts.length) {
                    if ((var = var.getField(parts[i])) == null) {
                        return retError;
                    }
                    ++i;
                }
                if (!var.getType().hasValue()) {
                    return retError;
                }
                rValueObject = var.getValue();
            } else {
                rValueObject = DecisionModule.this.rValue;
            }
            boolean ret = false;
            if (this.bothNumbers(lValueObject, rValueObject)) {
                BigDecimal bd1 = new BigDecimal(lValueObject.toString());
                BigDecimal bd2 = new BigDecimal(rValueObject.toString());
                switch (DecisionModule.this.compType) {
                    case 0: {
                        ret = bd1.compareTo(bd2) == 0;
                        break;
                    }
                    case 1: {
                        ret = bd1.compareTo(bd2) < 0;
                        break;
                    }
                    case 2: {
                        ret = bd1.compareTo(bd2) <= 0;
                        break;
                    }
                    case 3: {
                        ret = bd1.compareTo(bd2) > 0;
                        break;
                    }
                    case 4: {
                        ret = bd1.compareTo(bd2) >= 0;
                        break;
                    }
                    case 5: {
                        ret = bd1.compareTo(bd2) != 0;
                    }
                }
            } else {
                String st1 = lValueObject.toString();
                String st2 = rValueObject.toString();
                switch (DecisionModule.this.compType) {
                    case 0: {
                        ret = st1.compareTo(st2) == 0;
                        break;
                    }
                    case 1: {
                        ret = st1.compareTo(st2) < 0;
                        break;
                    }
                    case 2: {
                        ret = st1.compareTo(st2) <= 0;
                        break;
                    }
                    case 3: {
                        ret = st1.compareTo(st2) > 0;
                        break;
                    }
                    case 4: {
                        ret = st1.compareTo(st2) >= 0;
                        break;
                    }
                    case 5: {
                        boolean bl = ret = st1.compareTo(st2) != 0;
                    }
                }
            }
            if (ret) {
                return retTrue;
            }
            return retFalse;
        }

        private boolean bothNumbers(Object obj1, Object obj2) {
            try {
                new BigDecimal(obj1.toString());
                new BigDecimal(obj2.toString());
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            return true;
        }
    }
}

