/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.kernel.modules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.vtp.framework.api.BArray;
import org.eclipse.vtp.framework.api.BObject;
import org.eclipse.vtp.framework.api.Conversation;
import org.eclipse.vtp.framework.api.ExecutionResult;
import org.eclipse.vtp.framework.api.Interaction;
import org.eclipse.vtp.framework.api.Menu;
import org.eclipse.vtp.framework.api.Prompt;
import org.eclipse.vtp.framework.kernel.api.Destination;
import org.eclipse.vtp.framework.kernel.api.Module;
import org.eclipse.vtp.framework.kernel.api.ModuleDestination;
import org.w3c.dom.Element;

public class ForEachModule
implements Module {
    private String id;
    String varName;
    int varMulti;
    String varType;
    boolean allowUserNav = false;
    boolean supportBack = false;
    boolean supportMainMenu = false;
    boolean supportOptOut = false;
    Map hooks = new HashMap();
    Map endPoints = new HashMap();

    public ForEachModule(String id) {
        this.id = id;
    }

    public void readSettings(Element element) {
        this.varName = element.getAttribute("var-name");
        this.varMulti = Integer.parseInt(element.getAttribute("var-multi"));
        this.varType = element.getAttribute("var-type");
        this.allowUserNav = Boolean.valueOf(element.getAttribute("user-nav"));
        this.supportBack = Boolean.valueOf(element.getAttribute("support-back"));
        this.supportMainMenu = Boolean.valueOf(element.getAttribute("support-main-menu"));
        this.supportOptOut = Boolean.valueOf(element.getAttribute("support-opt-out"));
    }

    public void addSetting(String name, Object value) {
    }

    public List getPreconditions() {
        return new ArrayList();
    }

    public Interaction getInstance() {
        return new ForEachInteraction();
    }

    public ModuleDestination getHookDestination(String hookName) {
        return (ModuleDestination)this.hooks.get(hookName);
    }

    public void registerHookDestination(String hookName, ModuleDestination destination) {
        this.hooks.put(hookName, destination);
    }

    public void registerEndPointDestination(String endPointName, Destination destination) {
        this.endPoints.put(endPointName, destination);
    }

    public Destination getEndPointDestination(String endPointName) {
        return (Destination)this.endPoints.get(endPointName);
    }

    public void setTimeoutDestination(Destination timeoutDestination) {
    }

    public Destination getTimeoutDestination() {
        return null;
    }

    public Map getSettings() {
        return new HashMap();
    }

    public String getName() {
        return "ForEach";
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return null;
    }

    public class ForEachInteraction
    implements Interaction {
        public ExecutionResult execute(Conversation conversation) {
            ArrayList<BObject> items;
            ExecutionResult noMoreItems = ExecutionResult.success((String)"No More Items");
            ExecutionResult mainMenu = ExecutionResult.success((String)"Main Menu");
            ExecutionResult optOut = ExecutionResult.success((String)"Opt Out");
            ExecutionResult noItems = ExecutionResult.success((String)"No Items");
            String[] parts = ForEachModule.this.varName.split("\\.");
            BObject var = conversation.getVariable(parts[0]);
            int i = 1;
            while (i < parts.length) {
                var = var.getField(parts[i]);
                ++i;
            }
            if (var instanceof BArray) {
                items = ((BArray)var).getItems();
            } else {
                items = new ArrayList<BObject>();
                items.add(var);
            }
            if (items.size() < 1) {
                return noItems;
            }
            int i2 = 0;
            while (i2 < items.size()) {
                BObject cur = (BObject)items.get(i2);
                conversation.registerVariable("CurrentItem", cur);
                conversation.executeHook("Next Item");
                String tv = "CurrentItem.name";
                BObject obj = null;
                StringTokenizer st = new StringTokenizer(tv, ".");
                while (st.hasMoreElements()) {
                    if ((obj = obj == null ? conversation.getVariable(st.nextToken()) : obj.getField(st.nextToken())) == null) break;
                }
                if (ForEachModule.this.allowUserNav) {
                    Menu m = conversation.createMenu();
                    m.setNoInputPrompt(Prompt.named((String)"NoInput"));
                    m.setNoMatchPrompt(Prompt.named((String)"NoMatch"));
                    m.setPrompt(Prompt.named((String)"Lead In"));
                    if (ForEachModule.this.supportBack & i2 > 0) {
                        m.addChoice("1", Prompt.named((String)"Back Option"), 1);
                    }
                    m.addChoice("2", Prompt.named((String)"Repeat"), 2);
                    if (i2 < items.size() - 1) {
                        m.addChoice("3", Prompt.named((String)"Next Option"), 3);
                    }
                    if (ForEachModule.this.supportMainMenu) {
                        m.addChoice("9", Prompt.named((String)"Main Menu"), 9);
                    }
                    if (ForEachModule.this.supportOptOut) {
                        m.addChoice("0", Prompt.named((String)"Opt Out"), 0);
                    }
                    if (m.processRequest()) {
                        int selection = m.getSelection().getDTMF();
                        if (selection == 1) {
                            i2 -= 2;
                        } else if (selection == 2) {
                            --i2;
                        } else if (selection != 3) {
                            if (selection == 9) {
                                return mainMenu;
                            }
                            if (selection == 0) {
                                return optOut;
                            }
                        }
                    }
                }
                ++i2;
            }
            return noMoreItems;
        }
    }
}

