/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.kernel.spi;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.vtp.framework.api.Prompt;
import org.eclipse.vtp.framework.kernel.spi.GrammarRenderer;
import org.eclipse.vtp.framework.kernel.spi.GrammarSolver;
import org.eclipse.vtp.framework.kernel.spi.Kernel;
import org.eclipse.vtp.framework.kernel.spi.MediaRenderer;
import org.eclipse.vtp.framework.kernel.spi.PromptRenderer;
import org.eclipse.vtp.framework.kernel.spi.PromptSolver;
import org.eclipse.vtp.framework.media.binding.BindingDialog;
import org.eclipse.vtp.framework.media.binding.BindingFieldDialog;
import org.eclipse.vtp.framework.media.binding.BindingMessageDialog;
import org.eclipse.vtp.framework.media.util.BindingIndex;
import org.eclipse.vtp.framework.media.util.DialogAggregate;
import org.eclipse.vtp.framework.widgets.vxml.grammar.Grammar;

public class DefaultMediaRenderer
implements MediaRenderer {
    private final Kernel kernel;
    private final PromptSolver promptSolver;
    private final GrammarSolver grammarSolver;
    private final String brand;
    private final String module;
    private final String instance;
    private String language;
    private String dialog;
    private PromptRenderer promptRenderer;
    private GrammarRenderer grammarRenderer;
    private Map dialogs = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.vtp.framework.kernel.spi.DefaultMediaRenderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DefaultMediaRenderer(Kernel kernel, PromptSolver promptSolver, GrammarSolver grammarSolver, String brand, String module, String instance, String dialog, String currentLanguage) {
        if (!$assertionsDisabled && kernel == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && promptSolver == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && grammarSolver == null) {
            throw new AssertionError();
        }
        this.kernel = kernel;
        this.promptSolver = promptSolver;
        this.grammarSolver = grammarSolver;
        this.brand = brand;
        this.module = module;
        this.instance = instance;
        this.setCurrentLanguage(currentLanguage);
        BindingIndex index = promptSolver.getIndex(brand);
        Iterator i = index.indexDialogs(module, instance).iterator();
        while (i.hasNext()) {
            BindingDialog dialogObj = (BindingDialog)i.next();
            this.dialogs.put(dialogObj.getName(), new DialogAggregate(index, module, instance, dialogObj.getName(), dialogObj instanceof BindingMessageDialog ? 1 : (dialogObj instanceof BindingFieldDialog ? 2 : 3)));
        }
        this.setCurrentDialog(dialog);
    }

    public DialogAggregate getDialog(String name) {
        return (DialogAggregate)this.dialogs.get(name);
    }

    public void setCurrentLanguage(String currentLanguage) {
        this.language = currentLanguage;
        this.promptRenderer = new PromptRenderer(this.kernel, this.promptSolver, this.brand, this.module, this.instance, this.dialog, this.language);
        this.grammarRenderer = new GrammarRenderer(this.kernel, this.grammarSolver, this.brand, this.module, this.instance, this.dialog, this.language, this.getDialog(this.dialog) == null ? 0 : this.getDialog(this.dialog).getInputMode());
    }

    public void setCurrentDialog(String dialog) {
        this.dialog = dialog;
        this.promptRenderer = new PromptRenderer(this.kernel, this.promptSolver, this.brand, this.module, this.instance, dialog, this.language);
        DialogAggregate dialogObj = this.getDialog(dialog);
        this.grammarRenderer = new GrammarRenderer(this.kernel, this.grammarSolver, this.brand, this.module, this.instance, dialog, this.language, dialogObj == null || dialogObj.getType() == 1 ? 0 : dialogObj.getInputMode());
    }

    public org.eclipse.vtp.framework.widgets.vxml.Prompt renderPrompt(Prompt prompt) {
        return this.promptRenderer.renderPrompt(prompt);
    }

    public org.eclipse.vtp.framework.widgets.vxml.Prompt renderPrompt(Prompt prompt, boolean bargeIn) {
        return this.promptRenderer.renderPrompt(prompt, bargeIn);
    }

    public Grammar renderGrammar(org.eclipse.vtp.framework.api.Grammar grammar) {
        return this.grammarRenderer.renderGrammar(grammar);
    }
}

