/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.kernel.spi;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.StringTokenizer;
import org.eclipse.vtp.framework.api.BDecimal;
import org.eclipse.vtp.framework.api.BNumber;
import org.eclipse.vtp.framework.api.BObject;
import org.eclipse.vtp.framework.api.BString;
import org.eclipse.vtp.framework.api.Prompt;
import org.eclipse.vtp.framework.kernel.spi.Kernel;
import org.eclipse.vtp.framework.kernel.spi.PromptSolver;
import org.eclipse.vtp.framework.media.util.PromptSolutionOutput;
import org.eclipse.vtp.framework.widgets.vxml.AudioOutput;
import org.eclipse.vtp.framework.widgets.vxml.CompoundOutput;
import org.eclipse.vtp.framework.widgets.vxml.Output;
import org.eclipse.vtp.framework.widgets.vxml.TextOutput;

public class PromptRenderer
implements PromptSolutionOutput {
    private final Kernel kernel;
    private final PromptSolver solver;
    private final String brand;
    private final String module;
    private final String instance;
    private final String dialog;
    private final String currentLanguage;
    private Locale curlang;
    private CompoundOutput result;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.vtp.framework.kernel.spi.PromptRenderer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public PromptRenderer(Kernel kernel, PromptSolver solver, String brand, String module, String instance, String dialog, String currentLanguage) {
        if (!$assertionsDisabled && kernel == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && solver == null) {
            throw new AssertionError();
        }
        this.kernel = kernel;
        this.solver = solver;
        this.brand = brand;
        this.module = module;
        this.instance = instance;
        this.dialog = dialog;
        this.currentLanguage = currentLanguage;
    }

    public final org.eclipse.vtp.framework.widgets.vxml.Prompt renderPrompt(Prompt prompt) {
        if (!$assertionsDisabled && prompt == null) {
            throw new AssertionError();
        }
        return this.renderPrompt(prompt, true);
    }

    public final org.eclipse.vtp.framework.widgets.vxml.Prompt renderPrompt(Prompt prompt, boolean bargeIn) {
        if (!$assertionsDisabled && prompt == null) {
            throw new AssertionError();
        }
        this.curlang = "English".equals(this.currentLanguage) ? new Locale("en", "US") : ("Spanish".equals(this.currentLanguage) ? new Locale("es", "MX") : new Locale("en", "US"));
        this.result = new CompoundOutput();
        this.solver.solve(this.curlang, this.brand, this.module, this.instance, this.dialog, prompt, this);
        org.eclipse.vtp.framework.widgets.vxml.Prompt ret = new org.eclipse.vtp.framework.widgets.vxml.Prompt((Output)this.result, bargeIn);
        this.result = null;
        ret.setLanguage(this.curlang.toString().replace('_', '-'));
        return ret;
    }

    public void writeCharacters(String characters) {
        StringBuffer buffer = new StringBuffer(32);
        int i = 0;
        while (i < characters.length()) {
            buffer.append(characters.charAt(i)).append(' ');
            ++i;
        }
        this.writeText(buffer.toString());
    }

    public void writeFile(String path) {
        AudioOutput rootOutput = new AudioOutput(path);
        StringBuffer hackPath = new StringBuffer();
        StringTokenizer st = new StringTokenizer(path, "/");
        hackPath.append('/');
        hackPath.append(st.nextToken());
        hackPath.append('/');
        hackPath.append(st.nextToken());
        hackPath.append('/');
        hackPath.append(st.nextToken());
        hackPath.append('/');
        hackPath.append(st.nextToken());
        hackPath.append('/');
        String brand = st.nextToken();
        if (!brand.equals("Default")) {
            hackPath.append("Default");
            while (st.hasMoreTokens()) {
                hackPath.append('/');
                hackPath.append(st.nextToken());
            }
            rootOutput.addOutput((Output)new AudioOutput(hackPath.toString()));
        }
        this.result.addOutput((Output)rootOutput);
    }

    public void writeText(String text) {
        this.result.addOutput((Output)new TextOutput(" " + text + " "));
    }

    public void writeVariable(String variable, int type) {
        Prompt p;
        BObject obj = null;
        StringTokenizer st = new StringTokenizer(variable, ".");
        while (st.hasMoreElements()) {
            if (obj == null) {
                String tk = st.nextToken();
                obj = this.kernel.getVariable(tk);
            } else {
                obj = obj.getField(st.nextToken());
            }
            if (obj == null) break;
        }
        if (obj == null) {
            this.writeText("ERROR: no variable found named " + variable);
        } else if (obj instanceof BDecimal) {
            p = null;
            switch (type) {
                case 0: {
                    p = Prompt.forCharacters((String)obj.getValue().toString());
                    break;
                }
                case 1: {
                    p = Prompt.forDigits((String)obj.getValue().toString());
                    break;
                }
                case 2: {
                    p = Prompt.forMoney((BigDecimal)((BigDecimal)obj.getValue()));
                    break;
                }
                case 3: {
                    p = Prompt.forNumber((int)((BigDecimal)obj.getValue()).intValue());
                    break;
                }
                default: {
                    String value = obj.getValue().toString();
                    int dotAt = value.indexOf(46);
                    p = Prompt.forNumber((int)Integer.parseInt(value.substring(0, dotAt < 0 ? value.length() : dotAt)));
                    if (dotAt < 0) break;
                    p = p.followedBy(Prompt.forText((String)".")).followedBy(Prompt.forDigits((String)value.substring(dotAt + 1)));
                }
            }
            this.solver.solve(this.curlang, this.brand, this.module, this.instance, this.dialog, p, this);
        } else if (obj instanceof BNumber) {
            p = null;
            switch (type) {
                case 0: {
                    p = Prompt.forCharacters((String)obj.getValue().toString());
                    break;
                }
                case 1: {
                    p = Prompt.forDigits((String)obj.getValue().toString());
                    break;
                }
                case 2: {
                    p = Prompt.forMoney((BigDecimal)new BigDecimal(obj.getValue().toString()));
                    break;
                }
                case 4: {
                    p = Prompt.forText((String)obj.getValue().toString());
                    break;
                }
                default: {
                    p = Prompt.forNumber((int)((Number)obj.getValue()).intValue());
                }
            }
            this.solver.solve(this.curlang, this.brand, this.module, this.instance, this.dialog, p, this);
        } else if (obj instanceof BString) {
            p = null;
            switch (type) {
                case 0: {
                    p = Prompt.forCharacters((String)obj.getValue().toString());
                    break;
                }
                case 1: {
                    p = Prompt.forDigits((String)obj.getValue().toString());
                    break;
                }
                case 2: {
                    p = Prompt.forMoney((BigDecimal)new BigDecimal(obj.getValue().toString()));
                    break;
                }
                case 3: {
                    p = Prompt.forNumber((int)Integer.parseInt(obj.getValue().toString()));
                    break;
                }
                default: {
                    p = Prompt.forText((String)obj.getValue().toString());
                }
            }
            this.solver.solve(this.curlang, this.brand, this.module, this.instance, this.dialog, p, this);
        } else {
            this.writeText("ERROR: cannot write variable named " + variable);
        }
    }

    public void reset() {
        this.result = new CompoundOutput();
    }

    public CompoundOutput getResult() {
        return this.result;
    }
}

