/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.util;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLUtilities {
    public static String encodeAttribute(String toEncode) {
        StringBuffer buffer = new StringBuffer();
        char[] cs = toEncode.toCharArray();
        int i = 0;
        while (i < cs.length) {
            switch (cs[i]) {
                case '\'': {
                    buffer.append("&apos;");
                    break;
                }
                case '\"': {
                    buffer.append("&quot;");
                    break;
                }
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                default: {
                    buffer.append(cs[i]);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String encodeText(String toEncode) {
        StringBuffer buffer = new StringBuffer();
        char[] cs = toEncode.toCharArray();
        int i = 0;
        while (i < cs.length) {
            switch (cs[i]) {
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                default: {
                    buffer.append(cs[i]);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static NodeList getNamedNodeList(Element parent, String containerTagName) throws Exception {
        NodeList nl = parent.getElementsByTagName(containerTagName);
        if (nl.getLength() < 1) {
            throw new Exception("Missing named list: " + containerTagName);
        }
        if (nl.item(0).getNodeType() != 1) {
            throw new Exception("Named tag is not an element: " + containerTagName);
        }
        return nl.item(0).getChildNodes();
    }

    public static Element[] getElementsOfNodeList(NodeList nodeList) {
        Element[] ret = null;
        Vector<Node> v = new Vector<Node>();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node item = nodeList.item(n);
            if (item.getNodeType() == 1) {
                v.addElement(item);
            }
            ++n;
        }
        ret = new Element[v.size()];
        n = 0;
        while (n < ret.length) {
            ret[n] = (Element)v.elementAt(n);
            ++n;
        }
        return ret;
    }

    public static String getWrappedTextData(Element parent, String childTagName) throws Exception {
        NodeList nl = parent.getElementsByTagName(childTagName);
        if (nl.getLength() < 1) {
            return null;
        }
        Element childElement = (Element)nl.item(0);
        return XMLUtilities.getElementTextData(childElement);
    }

    public static String getElementTextData(Element element) throws Exception {
        if (!element.hasChildNodes()) {
            throw new Exception("Element has no children.");
        }
        Node n = element.getFirstChild();
        if (n.getNodeType() != 3 && n.getNodeType() != 4) {
            throw new Exception("Element child node is not textual.");
        }
        CharacterData value = (CharacterData)n;
        return value.getData();
    }

    public static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        return documentBuilderFactory.newDocumentBuilder();
    }

    public static Document loadDocument(File documentFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder = XMLUtilities.getDocumentBuilder();
        return documentBuilder.parse(documentFile);
    }
}

