/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.ui.internal.cactus;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.eclipse.jst.server.ui.internal.JavaServerUIPlugin;
import org.eclipse.jst.server.ui.internal.cactus.CactusAddLibrariesProposal;

public class CactusQuickFixProcessor
implements IQuickFixProcessor {
    public boolean hasCorrections(ICompilationUnit unit, int problemId) {
        return 268435846 == problemId;
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        if (this.isCactusProblem(context, locations)) {
            return new IJavaCompletionProposal[]{new CactusAddLibrariesProposal(context)};
        }
        return new IJavaCompletionProposal[0];
    }

    private boolean isCactusProblem(IInvocationContext context, IProblemLocation[] locations) {
        ICompilationUnit unit = context.getCompilationUnit();
        int i = 0;
        while (i < locations.length) {
            IProblemLocation location = locations[i];
            try {
                String s = this.getStringUntilWhiteSpaceOrEnd(location.getOffset(), unit);
                if ("ServletTestCase".equals(s) || s.indexOf("org.apache.cactus") >= 0) {
                    return true;
                }
            }
            catch (JavaModelException e) {
                JavaServerUIPlugin.log(e);
            }
            ++i;
        }
        return false;
    }

    private String getStringUntilWhiteSpaceOrEnd(int offset, ICompilationUnit unit) throws JavaModelException {
        StringBuffer builder = new StringBuffer();
        IBuffer buffer = unit.getBuffer();
        int length = buffer.getLength();
        int index = offset;
        while (index < length) {
            char c = buffer.getChar(index);
            if (Character.isWhitespace(c)) {
                return builder.toString();
            }
            builder.append(c);
            ++index;
        }
        return builder.toString();
    }
}

