/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.navigator.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectPropertyTester;

public class J2EEProjectDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    private static ImageDescriptor EAR;
    private static ImageDescriptor APPCLIENT;
    private static ImageDescriptor DYNAMICWEB;
    private static ImageDescriptor EJB;
    private static ImageDescriptor CONNECTOR;
    private static final String PROJECT_FACET = "projectFacet";
    private static final String EAR_FACET = "jst.ear";
    private static final String APPCLIENT_FACET = "jst.appclient";
    private static final String WEB_FACET = "jst.web";
    private static final String EJB_FACET = "jst.ejb";
    private static final String UTILITY_FACET = "jst.utility";
    private static final String CONNECTOR_FACET = "jst.connector";
    private static final String STATIC_WEB_FACET = "wst.web";
    private static final FacetedProjectPropertyTester facetPropertyTester;

    static {
        facetPropertyTester = new FacetedProjectPropertyTester();
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IJavaProject) {
            element = ((IJavaProject)element).getProject();
        }
        if (element instanceof IProject) {
            IProject cfr_ignored_0 = (IProject)element;
            ImageDescriptor overlay = null;
            if (this.hasFacet(element, EAR_FACET)) {
                overlay = J2EEProjectDecorator.getEAR();
            } else if (this.hasFacet(element, APPCLIENT_FACET)) {
                overlay = J2EEProjectDecorator.getAPPCLIENT();
            } else if (this.hasFacet(element, WEB_FACET)) {
                overlay = J2EEProjectDecorator.getDYNAMICWEB();
            } else if (this.hasFacet(element, EJB_FACET)) {
                overlay = J2EEProjectDecorator.getEJB();
            } else if (this.hasFacet(element, CONNECTOR_FACET)) {
                overlay = J2EEProjectDecorator.getCONNECTOR();
            } else if (this.hasFacet(element, STATIC_WEB_FACET)) {
                overlay = J2EEProjectDecorator.getDYNAMICWEB();
            } else if (this.hasFacet(element, UTILITY_FACET)) {
                overlay = null;
            }
            if (overlay != null) {
                decoration.addOverlay(overlay);
            }
        }
    }

    private boolean hasFacet(Object element, String facet) {
        return facetPropertyTester.test(element, PROJECT_FACET, new Object[0], (Object)facet);
    }

    private static ImageDescriptor getImageDescriptor(String imageFileName) {
        if (imageFileName != null) {
            return J2EEUIPlugin.getDefault().getImageDescriptor(imageFileName);
        }
        return null;
    }

    private static ImageDescriptor getEAR() {
        if (EAR == null) {
            EAR = J2EEProjectDecorator.getImageDescriptor("enterprise_app_ovr");
        }
        return EAR;
    }

    private static ImageDescriptor getAPPCLIENT() {
        if (APPCLIENT == null) {
            APPCLIENT = J2EEProjectDecorator.getImageDescriptor("client_app_ovr");
        }
        return APPCLIENT;
    }

    private static ImageDescriptor getDYNAMICWEB() {
        if (DYNAMICWEB == null) {
            DYNAMICWEB = J2EEProjectDecorator.getImageDescriptor("web_module_ovr");
        }
        return DYNAMICWEB;
    }

    private static ImageDescriptor getEJB() {
        if (EJB == null) {
            EJB = J2EEProjectDecorator.getImageDescriptor("ejb_module_ovr");
        }
        return EJB;
    }

    private static ImageDescriptor getCONNECTOR() {
        if (CONNECTOR == null) {
            CONNECTOR = J2EEProjectDecorator.getImageDescriptor("connector_ovr");
        }
        return CONNECTOR;
    }
}

