/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.common;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.ws.internal.consumption.common.IServerDefaulter;
import org.eclipse.jst.ws.internal.consumption.common.ServerInfo;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class ServerSelectionUtils {
    public static IRuntime getRuntimeTarget(String projectName) {
        IProject project;
        if (projectName != null && projectName.length() > 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && project.exists()) {
            return ServerCore.getProjectProperties((IProject)project).getRuntimeTarget();
        }
        return null;
    }

    public static IServer getFirstExistingServerFromFactoryId(String factoryId) {
        IServer[] servers = ServerCore.getServers();
        if (servers == null || servers.length != 0) {
            return null;
        }
        int i = 0;
        while (i < servers.length) {
            IServer server = servers[i];
            if (server.getServerType().getId().equals(factoryId)) {
                return server;
            }
            ++i;
        }
        return null;
    }

    public static IServer[] getCompatibleExistingServers(IRuntime runtime) {
        if (runtime == null) {
            return null;
        }
        IServer[] servers = ServerCore.getServers();
        if (servers == null || servers.length == 0) {
            return null;
        }
        ArrayList<IServer> compatibleServersList = new ArrayList<IServer>();
        String runtimeId = runtime.getRuntimeType().getId();
        int i = 0;
        while (i < servers.length) {
            IServer server = servers[i];
            String serverRuntimeId = server.getRuntime().getRuntimeType().getId();
            if (serverRuntimeId.equals(runtimeId)) {
                compatibleServersList.add(server);
            }
            ++i;
        }
        if (compatibleServersList.size() < 1) {
            return null;
        }
        Object[] compatibleServersArray = compatibleServersList.toArray();
        IServer[] compatibleServers = new IServer[compatibleServersArray.length];
        int j = 0;
        while (j < compatibleServersArray.length) {
            compatibleServers[j] = (IServer)compatibleServersArray[j];
            ++j;
        }
        return compatibleServers;
    }

    public static ServerInfo getExtenderRecommendation(IProject project) {
        try {
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption", "serverDefaulter");
            int i = 0;
            while (i < elements.length) {
                IServerDefaulter serverDefaulter;
                ServerInfo serverInfo;
                Object serverDefaulterObject = elements[i].createExecutableExtension("class");
                if (serverDefaulterObject instanceof IServerDefaulter && (serverInfo = (serverDefaulter = (IServerDefaulter)serverDefaulterObject).recommendDefaultServer(project)) != null) {
                    return serverInfo;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }
}

