/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.object;

import java.util.Calendar;
import org.eclipse.swt.widgets.Display;

public class Timer
extends Thread {
    private static Timer instance = null;
    private final long ONE_SECOND = 1000L;
    private long refreshTime;
    private Display display;
    private Runnable runnable;

    private Timer(Display display, Runnable runnable) {
        this.display = display;
        this.runnable = runnable;
    }

    public static synchronized Timer newInstance(Display display, Runnable runnable) {
        if (instance == null) {
            instance = new Timer(display, runnable);
        }
        return instance;
    }

    public static synchronized boolean isRunning() {
        return instance != null;
    }

    public synchronized void startTimer() {
        this.refreshTime = this.getCurrentTime() + 1000L;
        if (!this.isAlive()) {
            this.start();
        }
    }

    private long getCurrentTime() {
        return Calendar.getInstance().getTime().getTime();
    }

    public void run() {
        long currTime = this.getCurrentTime();
        while (currTime < this.refreshTime) {
            try {
                Timer.sleep(this.refreshTime - currTime);
            }
            catch (InterruptedException interruptedException) {}
            currTime = this.getCurrentTime();
        }
        instance = null;
        this.display.syncExec(this.runnable);
    }
}

