/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.test.wssample;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.facet.JavaProjectMigrationDataModelProvider;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.consumption.command.common.AddModuleToServerCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.AssociateModuleWithEARCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateFacetedProjectCommand;
import org.eclipse.jst.ws.internal.consumption.common.RequiredFacetVersion;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.command.StartServerCommand;
import org.eclipse.jst.ws.internal.consumption.ui.common.ValidationUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.ws.internal.wsrt.TestInfo;

public class AddModuleDependenciesCommand
extends AbstractDataModelOperation {
    private TestInfo testInfo;
    private IProject sampleIProject;
    private IProject clientIProject;
    private IProject sampleEARIProject;
    private String sampleEARProject;
    public static final String DEFAULT_SAMPLE_EAR_PROJECT_EXT = "EAR";

    public AddModuleDependenciesCommand(TestInfo testInfo) {
        this.testInfo = testInfo;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus status;
        ValidationUtils vu;
        boolean serverNeedsEAR;
        IEnvironment env = this.getEnvironment();
        this.sampleIProject = ProjectUtilities.getProject((String)this.testInfo.getGenerationProject());
        boolean createdSampleProject = false;
        if (!this.sampleIProject.exists()) {
            CreateFacetedProjectCommand command = new CreateFacetedProjectCommand();
            command.setProjectName(this.testInfo.getGenerationProject());
            command.setTemplateId("template.jst.web");
            command.setRequiredFacetVersions(new RequiredFacetVersion[0]);
            command.setServerFactoryId(this.testInfo.getClientServerTypeID());
            command.setServerInstanceId(this.testInfo.getClientExistingServer().getId());
            IStatus status2 = command.execute(monitor, adaptable);
            if (status2.getSeverity() == 4) {
                env.getStatusHandler().reportError(status2);
                return status2;
            }
            createdSampleProject = true;
        }
        if (serverNeedsEAR = (vu = new ValidationUtils()).serverNeedsEAR(this.testInfo.getClientServerTypeID())) {
            this.sampleEARProject = this.testInfo.getClientEARProject() == null || this.testInfo.getClientEARProject().length() == 0 ? String.valueOf(this.testInfo.getGenerationProject()) + DEFAULT_SAMPLE_EAR_PROJECT_EXT : this.testInfo.getClientEARProject();
            this.sampleEARIProject = ProjectUtilities.getProject((String)this.sampleEARProject);
            if (this.sampleEARIProject == null || !this.sampleEARIProject.exists()) {
                CreateFacetedProjectCommand command = new CreateFacetedProjectCommand();
                command.setProjectName(this.sampleEARProject);
                command.setTemplateId("template.jst.ear");
                command.setRequiredFacetVersions(new RequiredFacetVersion[0]);
                command.setServerFactoryId(this.testInfo.getClientServerTypeID());
                command.setServerInstanceId(this.testInfo.getClientExistingServer().getId());
                status = command.execute(monitor, adaptable);
                if (status.getSeverity() == 4) {
                    env.getStatusHandler().reportError(status);
                    return status;
                }
            }
        }
        if (serverNeedsEAR) {
            AssociateModuleWithEARCommand associateCommand = new AssociateModuleWithEARCommand();
            associateCommand.setProject(this.testInfo.getGenerationProject());
            associateCommand.setEARProject(this.sampleEARProject);
            associateCommand.setEar(this.sampleEARProject);
            associateCommand.setEnvironment(env);
            status = associateCommand.execute(monitor, null);
            if (status.getSeverity() == 4) {
                env.getStatusHandler().reportError(status);
            }
        }
        if (serverNeedsEAR) {
            AddModuleToServerCommand modToServer = new AddModuleToServerCommand();
            modToServer.setModule(this.sampleEARProject);
            modToServer.setProject(this.sampleEARProject);
            modToServer.setServerInstanceId(this.testInfo.getClientExistingServer().getId());
            modToServer.setEnvironment(env);
            status = modToServer.execute(monitor, null);
            if (status.getSeverity() == 4) {
                env.getStatusHandler().reportError(status);
            }
        } else {
            AddModuleToServerCommand addToServer = new AddModuleToServerCommand();
            addToServer.setModule(this.testInfo.getGenerationProject());
            addToServer.setProject(this.testInfo.getGenerationProject());
            addToServer.setServerInstanceId(this.testInfo.getClientExistingServer().getId());
            addToServer.setEnvironment(env);
            status = addToServer.execute(monitor, null);
            if (status.getSeverity() == 4) {
                env.getStatusHandler().reportError(status);
            }
        }
        if (createdSampleProject) {
            StartServerCommand startServer = new StartServerCommand(true);
            startServer.setServerInstanceId(this.testInfo.getClientExistingServer().getId());
            startServer.setEnvironment(env);
            status = startServer.execute(monitor, null);
            if (status.getSeverity() == 4) {
                env.getStatusHandler().reportError(status);
            }
        }
        this.clientIProject = ProjectUtilities.getProject((String)this.testInfo.getClientProject());
        if (this.clientIProject != null && !J2EEUtils.isWebComponent((IProject)this.clientIProject)) {
            IStatus errorStatus;
            String errorMessage;
            if (J2EEUtils.isJavaComponent((IProject)this.clientIProject)) {
                this.addJavaProjectAsUtilityJar(this.clientIProject, this.sampleEARIProject, monitor);
                this.addJavaProjectAsUtilityJar(this.clientIProject, this.sampleIProject, monitor);
            }
            try {
                String uri = String.valueOf(this.clientIProject.getName()) + ".jar";
                this.addJAROrModuleDependency(this.sampleIProject, uri);
            }
            catch (CoreException coreException) {
                errorMessage = NLS.bind((String)ConsumptionUIMessages.MSG_ERROR_MODULE_DEPENDENCY, (Object[])new String[]{this.sampleIProject.getName(), this.clientIProject.getName()});
                errorStatus = StatusUtils.errorStatus((String)errorMessage);
                env.getStatusHandler().reportError(errorStatus);
            }
            catch (IOException iOException) {
                errorMessage = NLS.bind((String)ConsumptionUIMessages.MSG_ERROR_MODULE_DEPENDENCY, (Object[])new String[]{this.sampleIProject.getName(), this.clientIProject.getName()});
                errorStatus = StatusUtils.errorStatus((String)errorMessage);
                env.getStatusHandler().reportError(errorStatus);
            }
            try {
                this.addBuildPath(this.sampleIProject, this.clientIProject);
            }
            catch (JavaModelException javaModelException) {}
        }
        return Status.OK_STATUS;
    }

    private void addJAROrModuleDependency(IProject project, String uri) throws IOException, CoreException {
        if (J2EEUtils.isWebComponent((IProject)project)) {
            ArchiveManifest manifest = J2EEProjectUtilities.readManifest((IProject)project);
            manifest.mergeClassPath(new String[]{uri});
            J2EEProjectUtilities.writeManifest((IProject)project, (ArchiveManifest)manifest);
        }
    }

    private void addJavaProjectAsUtilityJar(IProject javaProject, IProject earProject, IProgressMonitor monitor) {
        try {
            IDataModel migrationdm = DataModelFactory.createDataModel((IDataModelProvider)new JavaProjectMigrationDataModelProvider());
            migrationdm.setProperty("IJavaProjectMigrationDataModelProperties.PROJECT_NAME", (Object)javaProject.getName());
            migrationdm.getDefaultOperation().execute(monitor, null);
            IDataModel refdm = DataModelFactory.createDataModel((IDataModelProvider)new CreateReferenceComponentsDataModelProvider());
            List targetCompList = (List)refdm.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
            IVirtualComponent targetcomponent = ComponentCore.createComponent((IProject)javaProject);
            IVirtualComponent sourcecomponent = ComponentUtilities.getComponent((String)earProject.getName());
            targetCompList.add(targetcomponent);
            refdm.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)sourcecomponent);
            refdm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)targetCompList);
            refdm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)"/WEB-INF/lib");
            refdm.getDefaultOperation().execute(monitor, null);
        }
        catch (Exception exception) {}
    }

    private void addBuildPath(IProject referencingProject, IProject referencedProject) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)referencingProject);
        if (javaProject != null) {
            IClasspathEntry[] oldCp = javaProject.getRawClasspath();
            IClasspathEntry[] newCp = new IClasspathEntry[oldCp.length + 1];
            int i = 0;
            while (i < oldCp.length) {
                newCp[i] = oldCp[i];
                ++i;
            }
            newCp[newCp.length - 1] = JavaCore.newProjectEntry((IPath)referencedProject.getFullPath());
            javaProject.setRawClasspath(newCp, (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

