/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.AbstractDebugActionDelegate;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTreeViewer;
import org.eclipse.debug.internal.ui.viewers.ILabelResult;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;

public class CopyToClipboardActionDelegate
extends AbstractDebugActionDelegate {
    private ContentViewer fViewer;
    private static final String TAB = "\t";
    private static final String EMPTY_STRING = "";
    private static final String SEPARATOR = "line.separator";
    static /* synthetic */ Class class$0;

    protected boolean initialize(IAction action, ISelection selection) {
        if (!this.isInitialized()) {
            IDebugView adapter;
            IViewPart iViewPart = this.getView();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.ui.IDebugView");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IDebugView)iViewPart.getAdapter((Class)clazz)) != null) {
                if (adapter.getViewer() instanceof ContentViewer) {
                    this.setViewer((ContentViewer)adapter.getViewer());
                }
                adapter.setAction(this.getActionId(), action);
            }
            return super.initialize(action, selection);
        }
        return false;
    }

    protected String getActionId() {
        return IDebugView.COPY_ACTION;
    }

    protected void append(ILabelResult item, StringBuffer buffer, int indent) {
        int i = 0;
        while (i < indent) {
            buffer.append(TAB);
            ++i;
        }
        String[] labels = item.getLabels();
        int count = labels.length;
        if (count > 0) {
            int i2 = 0;
            while (i2 < count) {
                String text = labels[i2];
                if (text != null && !text.trim().equals(EMPTY_STRING)) {
                    buffer.append(String.valueOf(text) + TAB);
                }
                ++i2;
            }
            buffer.append(System.getProperty(SEPARATOR));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(final IAction action) {
        if (!(this.fViewer instanceof AsynchronousTreeViewer)) return;
        final AsynchronousTreeViewer atv = (AsynchronousTreeViewer)this.fViewer;
        List selectedItems = this.getPrunedSelection();
        TreeItem[] items = selectedItems.toArray(new TreeItem[selectedItems.size()]);
        final Object[] elements = new Object[selectedItems.size()];
        int i = 0;
        while (i < elements.length) {
            elements[i] = items[i].getData();
            ++i;
        }
        if (elements.length <= 0) return;
        final StringBuffer buffer = new StringBuffer();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(DebugUIPlugin.removeAccelerators(action.getText()), elements.length * 2);
                int i = 0;
                while (i < elements.length) {
                    Object element = elements[i];
                    if (element != null) {
                        SubProgressMonitor sub = new SubProgressMonitor(monitor, 1);
                        List results = atv.buildLabels((IProgressMonitor)sub, element, CopyToClipboardActionDelegate.EMPTY_STRING);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        CopyToClipboardActionDelegate.this.performCopy(results, buffer);
                        monitor.worked(1);
                    } else {
                        monitor.worked(2);
                    }
                    ++i;
                }
                monitor.done();
            }
        };
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.fViewer.getControl().getShell());
        dialog.setCancelable(true);
        try {
            dialog.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            DebugUIPlugin.log(e);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        TextTransfer plainTextTransfer = TextTransfer.getInstance();
        Clipboard clipboard = new Clipboard(this.fViewer.getControl().getDisplay());
        try {
            this.doCopy(clipboard, plainTextTransfer, buffer);
            Object var11_15 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            clipboard.dispose();
            throw throwable;
        }
        clipboard.dispose();
    }

    protected void performCopy(List results, StringBuffer buffer) {
        Iterator iter = results.iterator();
        if (results.size() > 0) {
            int topLevel = ((ILabelResult)results.get(0)).getDepth();
            while (iter.hasNext()) {
                ILabelResult result = (ILabelResult)iter.next();
                this.append(result, buffer, result.getDepth() - topLevel);
            }
        }
    }

    protected void doCopy(Clipboard clipboard, TextTransfer plainTextTransfer, StringBuffer buffer) {
        block3: {
            try {
                clipboard.setContents((Object[])new String[]{buffer.toString()}, new Transfer[]{plainTextTransfer});
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.fViewer.getControl().getShell(), (String)ActionMessages.CopyToClipboardActionDelegate_Problem_Copying_to_Clipboard_1, (String)ActionMessages.CopyToClipboardActionDelegate_There_was_a_problem_when_accessing_the_system_clipboard__Retry__2)) break block3;
                this.doCopy(clipboard, plainTextTransfer, buffer);
            }
        }
    }

    protected List getPrunedSelection() {
        Control control = this.fViewer.getControl();
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        if (control instanceof Tree) {
            Tree tree = (Tree)control;
            TreeItem[] selection = tree.getSelection();
            int i = 0;
            while (i < selection.length) {
                TreeItem item = selection[i];
                if (this.isEnabledFor(item.getData()) && this.walkHierarchy(item, items)) {
                    items.add(item);
                }
                ++i;
            }
        }
        return items;
    }

    protected boolean walkHierarchy(TreeItem item, List elements) {
        TreeItem parent = item.getParentItem();
        if (parent == null) {
            return true;
        }
        if (elements.contains(parent)) {
            return false;
        }
        return this.walkHierarchy(parent, elements);
    }

    protected boolean shouldAppendChildren(TreeItem item) {
        return item.getExpanded();
    }

    protected ContentViewer getViewer() {
        return this.fViewer;
    }

    protected void setViewer(ContentViewer viewer) {
        this.fViewer = viewer;
    }

    protected void doAction(Object element) {
    }
}

