/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public class CompileErrorProjectPromptStatusHandler
implements IStatusHandler {
    public Object handleStatus(IStatus status, Object source) throws CoreException {
        ILaunchConfiguration config = null;
        ArrayList projects = new ArrayList();
        if (source instanceof List) {
            List args = (List)source;
            Iterator iterator = args.iterator();
            while (iterator.hasNext()) {
                Object arg = iterator.next();
                if (arg instanceof ILaunchConfiguration) {
                    config = (ILaunchConfiguration)arg;
                    if (!DebugUITools.isPrivate(config)) continue;
                    return Boolean.TRUE;
                }
                if (!(arg instanceof IProject)) continue;
                projects.add(arg);
            }
        }
        Shell shell = DebugUIPlugin.getShell();
        StringBuffer projectMessage = new StringBuffer();
        int i = 0;
        while (i < projects.size()) {
            if (i > 0) {
                projectMessage.append(", ");
            }
            projectMessage.append(((IProject)projects.get(i)).getName());
            ++i;
        }
        String plural = "";
        if (projects.size() > 1) {
            plural = "s";
        }
        String title = MessageFormat.format((String)LaunchConfigurationsMessages.CompileErrorPromptStatusHandler_0, (Object[])new String[]{plural});
        String message = MessageFormat.format((String)LaunchConfigurationsMessages.CompileErrorPromptStatusHandler_2, (Object[])new String[]{plural, projectMessage.toString()});
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        String pref = store.getString(IInternalDebugUIConstants.PREF_CONTINUE_WITH_COMPILE_ERROR);
        if (pref != null && pref.equals("always")) {
            return Boolean.TRUE;
        }
        MessageDialogWithToggle dialog = new MessageDialogWithToggle(shell, title, null, message, 3, new String[]{LaunchConfigurationsMessages.CompileErrorProjectPromptStatusHandler_0, IDialogConstants.CANCEL_LABEL}, 0, LaunchConfigurationsMessages.CompileErrorProjectPromptStatusHandler_1, false);
        if (dialog.open() == 256) {
            if (dialog.getToggleState()) {
                store.setValue(IInternalDebugUIConstants.PREF_CONTINUE_WITH_COMPILE_ERROR, "always");
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

