/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.AddRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.AsynchronousModel;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTreeViewer;
import org.eclipse.debug.internal.ui.viewers.AsynchronousViewer;
import org.eclipse.debug.internal.ui.viewers.ContainerRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.ModelNode;
import org.eclipse.debug.internal.ui.viewers.RemoveRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousContentAdapter;
import org.eclipse.jface.viewers.TreePath;

public class AsynchronousTreeModel
extends AsynchronousModel {
    public AsynchronousTreeModel(AsynchronousViewer viewer) {
        super(viewer);
    }

    public synchronized void add(TreePath treePath) {
        if (treePath.getSegmentCount() > 1) {
            int i;
            int parentIndex = treePath.getSegmentCount() - 2;
            Object parent = treePath.getSegment(parentIndex);
            ModelNode[] nodes = this.getNodes(parent);
            if (nodes != null) {
                i = 0;
                while (i < nodes.length) {
                    ModelNode node = nodes[i];
                    if (treePath.startsWith(node.getTreePath(), null)) {
                        AddRequestMonitor addRequest = new AddRequestMonitor(node, treePath, this);
                        this.requestScheduled(addRequest);
                        addRequest.done();
                        return;
                    }
                    ++i;
                }
            }
            i = parentIndex - 1;
            while (i >= 0) {
                parent = treePath.getSegment(i);
                nodes = this.getNodes(parent);
                if (nodes != null) {
                    int j = 0;
                    while (j < nodes.length) {
                        final ModelNode node = nodes[j];
                        if (treePath.startsWith(node.getTreePath(), null)) {
                            Runnable runnable = new Runnable(){

                                public void run() {
                                    AsynchronousTreeModel.this.getViewer().nodeChanged(node);
                                }
                            };
                            this.getViewer().getControl().getDisplay().asyncExec(runnable);
                            return;
                        }
                        ++j;
                    }
                }
                --i;
            }
        }
    }

    public synchronized void remove(TreePath treePath) {
        if (treePath.getSegmentCount() > 1) {
            Object element = treePath.getLastSegment();
            ModelNode[] nodes = this.getNodes(element);
            if (nodes != null) {
                int i = 0;
                while (i < nodes.length) {
                    ModelNode node = nodes[i];
                    if (node.correspondsTo(treePath)) {
                        RemoveRequestMonitor request = new RemoveRequestMonitor(node, treePath, this);
                        this.requestScheduled(request);
                        request.done();
                        return;
                    }
                    ++i;
                }
            }
            int index = treePath.getSegmentCount() - 2;
            while (index > 0) {
                element = treePath.getSegment(index);
                nodes = this.getNodes(element);
                if (nodes != null) {
                    int i = 0;
                    while (i < nodes.length) {
                        ModelNode node = nodes[i];
                        if (treePath.startsWith(node.getTreePath(), null)) {
                            this.updateChildren(node);
                            return;
                        }
                        ++i;
                    }
                }
                --index;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(final ModelNode node) {
        final ModelNode parentNode = node.getParentNode();
        if (parentNode == null) {
            return;
        }
        int index = -1;
        AsynchronousTreeModel asynchronousTreeModel = this;
        synchronized (asynchronousTreeModel) {
            index = parentNode.getChildIndex(node);
            parentNode.removeChild(node);
            this.unmapNode(node);
            node.dispose();
            if (DEBUG_MODEL) {
                DebugUIPlugin.debug("REMOVE: " + node);
                DebugUIPlugin.debug(this.toString());
            }
        }
        final int unmapFrom = index;
        final AsynchronousTreeViewer viewer = this.getTreeViewer();
        this.preservingSelection(new Runnable(){

            public void run() {
                viewer.unmapNode(node);
                if (unmapFrom > -1) {
                    ModelNode[] childrenNodes = parentNode.getChildrenNodes();
                    int i = unmapFrom;
                    while (i < childrenNodes.length) {
                        viewer.unmapNode(childrenNodes[i]);
                        ++i;
                    }
                }
                viewer.nodeChildRemoved(parentNode, unmapFrom);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(final ModelNode parent, Object element) {
        Object[] children = this.filter(parent.getElement(), new Object[]{element});
        if (children.length == 0) {
            return;
        }
        AsynchronousTreeModel asynchronousTreeModel = this;
        synchronized (asynchronousTreeModel) {
            ModelNode[] childrenNodes = parent.getChildrenNodes();
            if (childrenNodes != null) {
                int i = 0;
                while (i < childrenNodes.length) {
                    if (element.equals(childrenNodes[i].getElement())) {
                        return;
                    }
                    ++i;
                }
            }
            ModelNode node = new ModelNode(parent, element);
            parent.addChild(node);
            this.mapElement(element, node);
            if (DEBUG_MODEL) {
                DebugUIPlugin.debug("ADD: (parent) " + parent + " (child) " + element);
                DebugUIPlugin.debug(this.toString());
            }
        }
        this.preservingSelection(new Runnable(){

            public void run() {
                AsynchronousTreeModel.this.getTreeViewer().nodeChildrenAdded(parent);
            }
        });
    }

    public synchronized TreePath[] getTreePaths(Object element) {
        ModelNode[] nodes = this.getNodes(element);
        if (nodes == null) {
            return null;
        }
        TreePath[] paths = new TreePath[nodes.length];
        int i = 0;
        while (i < nodes.length) {
            paths[i] = nodes[i].getTreePath();
            ++i;
        }
        return paths;
    }

    protected AsynchronousTreeViewer getTreeViewer() {
        return (AsynchronousTreeViewer)this.getViewer();
    }

    protected void updateHasChildren(ModelNode node) {
        Object element = node.getElement();
        IAsynchronousContentAdapter adapter = this.getContentAdapter(element);
        if (adapter == null) {
            adapter = this.fEmptyContentAdapter;
        }
        if (adapter != null) {
            ContainerRequestMonitor update = new ContainerRequestMonitor(node, this);
            this.requestScheduled(update);
            adapter.isContainer(element, this.getPresentationContext(), update);
        }
    }

    protected synchronized void unmapNode(ModelNode node) {
        ModelNode[] childrenNodes = node.getChildrenNodes();
        if (childrenNodes != null) {
            int i = 0;
            while (i < childrenNodes.length) {
                this.unmapNode(childrenNodes[i]);
                ++i;
            }
        }
        super.unmapNode(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIsContainer(final ModelNode node, boolean containsChildren) {
        ModelNode[] unmapChildren = null;
        AsynchronousTreeModel asynchronousTreeModel = this;
        synchronized (asynchronousTreeModel) {
            ModelNode[] prevChildren = node.getChildrenNodes();
            node.setIsContainer(containsChildren);
            if (!containsChildren && prevChildren != null) {
                unmapChildren = prevChildren;
                int i = 0;
                while (i < prevChildren.length) {
                    ModelNode child = prevChildren[i];
                    this.unmapNode(child);
                    child.dispose();
                    ++i;
                }
                node.setChildren(null);
            }
            if (DEBUG_MODEL) {
                DebugUIPlugin.debug("SET CONTAINER: " + node);
                DebugUIPlugin.debug(this.toString());
            }
        }
        final ModelNode[] finalUnmap = unmapChildren;
        this.preservingSelection(new Runnable(){

            public void run() {
                if (finalUnmap != null) {
                    int i = 0;
                    while (i < finalUnmap.length) {
                        AsynchronousTreeModel.this.getViewer().unmapNode(finalUnmap[i]);
                        ++i;
                    }
                }
                AsynchronousTreeModel.this.getTreeViewer().nodeContainerChanged(node);
                AsynchronousTreeModel.this.getViewer().nodeChildrenChanged(node);
            }
        });
    }
}

