/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import com.ibm.icu.text.MessageFormat;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.LazyModelPresentation;
import org.eclipse.debug.internal.ui.VariablesViewModelPresentation;
import org.eclipse.debug.internal.ui.actions.CollapseAllAction;
import org.eclipse.debug.internal.ui.actions.ConfigureColumnsAction;
import org.eclipse.debug.internal.ui.actions.FindElementAction;
import org.eclipse.debug.internal.ui.actions.variables.AssignValueAction;
import org.eclipse.debug.internal.ui.actions.variables.ChangeVariableValueAction;
import org.eclipse.debug.internal.ui.actions.variables.ShowTypesAction;
import org.eclipse.debug.internal.ui.actions.variables.ToggleDetailPaneAction;
import org.eclipse.debug.internal.ui.contexts.DebugContextManager;
import org.eclipse.debug.internal.ui.contexts.provisional.IDebugContextListener;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTreeViewer;
import org.eclipse.debug.internal.ui.viewers.PresentationContext;
import org.eclipse.debug.internal.ui.views.AbstractViewerState;
import org.eclipse.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.debug.internal.ui.views.variables.AvailableLogicalStructuresAction;
import org.eclipse.debug.internal.ui.views.variables.IndexedVariablePartition;
import org.eclipse.debug.internal.ui.views.variables.StatusLineContributionItem;
import org.eclipse.debug.internal.ui.views.variables.ToggleLogicalStructureAction;
import org.eclipse.debug.internal.ui.views.variables.ToggleShowColumnsAction;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewMessages;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewer;
import org.eclipse.debug.internal.ui.views.variables.ViewerState;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.actions.TextViewerAction;
import org.eclipse.ui.operations.OperationHistoryActionHandler;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;

public class VariablesView
extends AbstractDebugView
implements IDebugContextListener,
IPropertyChangeListener,
IValueDetailListener,
IDebugExceptionHandler,
IPerspectiveListener {
    private VariablesViewModelPresentation fModelPresentation;
    private SashForm fSashForm;
    private SourceViewer fDetailViewer;
    private IDocument fDetailDocument;
    private String fDebugModelIdentifier;
    private SourceViewerConfiguration fSourceViewerConfiguration;
    private IStructuredSelection fValueSelection = null;
    private IValue fLastValueDetail = null;
    private Iterator fSelectionIterator = null;
    private ISelectionChangedListener fTreeSelectionChangedListener;
    private ISelectionChangedListener fDetailSelectionChangedListener;
    private IDocumentListener fDetailDocumentListener;
    private VariablesViewSelectionProvider fSelectionProvider = new VariablesViewSelectionProvider();
    private List fSelectionActions = new ArrayList(3);
    private HashMap fSelectionStates = new MRUMap(20);
    private AbstractViewerState fLastState = null;
    private Viewer fFocusViewer = null;
    private static final int[] DEFAULT_SASH_WEIGHTS = new int[]{13, 6};
    private int[] fLastSashWeights;
    private boolean fToggledDetailOnce;
    private String fCurrentDetailPaneOrientation = "Variables.detail.orientation.hidden";
    private ToggleDetailPaneAction[] fToggleDetailPaneActions;
    private ConfigureColumnsAction fConfigureColumnsAction;
    protected String PREF_STATE_MEMENTO = "pref_state_memento.";
    protected static final String DETAIL_SELECT_ALL_ACTION = String.valueOf(SELECT_ALL_ACTION) + ".Detail";
    protected static final String VARIABLES_SELECT_ALL_ACTION = String.valueOf(SELECT_ALL_ACTION) + ".Variables";
    protected static final String DETAIL_COPY_ACTION = String.valueOf(ActionFactory.COPY.getId()) + ".Detail";
    public static final String LOGICAL_STRUCTURE_TYPE_PREFIX = "VAR_LS_";
    protected static final String SASH_VIEW_PART = String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".SASH_VIEW_PART";
    protected static final String SASH_DETAILS_PART = String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".SASH_DETAILS_PART";
    protected static final String FIND_ELEMENT = "FindElement";
    private StatusLineContributionItem fStatusLineItem;
    private ICursorListener fCursorListener;
    private final String fPositionLabelPattern = VariablesViewMessages.VariablesView_56;
    private final PositionLabelValue fLineLabel = new PositionLabelValue();
    private final PositionLabelValue fColumnLabel = new PositionLabelValue();
    private final Object[] fPositionLabelPatternArguments = new Object[]{this.fLineLabel, this.fColumnLabel};
    private boolean fShowLogical;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void dispose() {
        this.getViewSite().getActionBars().getStatusLineManager().remove((IContributionItem)this.fStatusLineItem);
        DebugContextManager.getDefault().removeDebugContextListener(this, this.getSite().getWorkbenchWindow());
        this.getSite().getWorkbenchWindow().removePerspectiveListener((IPerspectiveListener)this);
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        Viewer viewer = this.getViewer();
        if (viewer != null) {
            this.getDetailDocument().removeDocumentListener(this.getDetailDocumentListener());
            if (viewer instanceof AsynchronousTreeViewer) {
                AsynchronousTreeViewer asyncTreeViewer = (AsynchronousTreeViewer)viewer;
                asyncTreeViewer.dispose();
            }
        }
        this.fSelectionStates.clear();
        super.dispose();
    }

    protected void setViewerInput(Object context) {
        this.getDetailViewer().setEditable(context != null);
        Object current = this.getViewer().getInput();
        if (current == null && context == null) {
            return;
        }
        if (current != null && current.equals(context)) {
            return;
        }
        if (current != null) {
            AbstractViewerState state = this.getViewerState();
            this.cacheViewerState(current, state);
            this.fLastState = (AbstractViewerState)state.clone();
        }
        if (context instanceof IDebugElement) {
            this.setDebugModel(((IDebugElement)context).getModelIdentifier());
        }
        this.showViewer();
        this.getViewer().setInput(context);
        this.restoreState();
    }

    protected void cacheViewerState(Object input, AbstractViewerState state) {
        this.fSelectionStates.put(this.generateKey(input), state);
    }

    protected Object generateKey(Object input) {
        return new Integer(input.hashCode());
    }

    protected AbstractViewerState getCachedViewerState(Object input) {
        return (AbstractViewerState)this.fSelectionStates.get(this.generateKey(input));
    }

    protected void restoreState() {
        Object context;
        VariablesViewer viewer = (VariablesViewer)this.getViewer();
        if (viewer != null && (context = viewer.getInput()) != null) {
            AbstractViewerState state = this.getCachedViewerState(context);
            if (state == null && this.fLastState != null) {
                state = this.fLastState;
            }
            if (state != null) {
                state.restoreState(viewer);
            }
        }
    }

    protected void configureDetailsViewer() {
        LazyModelPresentation mp = (LazyModelPresentation)this.fModelPresentation.getPresentation(this.getDebugModel());
        SourceViewerConfiguration svc = null;
        if (mp != null) {
            try {
                svc = mp.newDetailsViewerConfiguration();
            }
            catch (CoreException e) {
                DebugUIPlugin.errorDialog(this.getSite().getShell(), VariablesViewMessages.VariablesView_Error_1, VariablesViewMessages.VariablesView_Unable_to_configure_variable_details_area__2, e);
            }
        }
        ISourceViewer detailViewer = this.getDetailViewer();
        if (svc == null) {
            svc = new SourceViewerConfiguration();
            detailViewer.setEditable(false);
        }
        if (detailViewer instanceof ISourceViewerExtension2) {
            ISourceViewerExtension2 sourceViewer = (ISourceViewerExtension2)detailViewer;
            sourceViewer.unconfigure();
        }
        detailViewer.configure(svc);
        this.updateAction("ContentAssist");
        this.setDetailViewerConfiguration(svc);
        this.createUndoRedoActions();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getProperty();
        if (propertyName.equals("org.eclipse.debug.ui.changedDebugElement") || propertyName.equals(IInternalDebugUIConstants.PREF_CHANGED_VALUE_BACKGROUND)) {
            this.getViewer().refresh();
        } else if (propertyName.equals("org.eclipse.debug.ui.DetailPaneFont")) {
            this.getDetailViewer().getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.DetailPaneFont"));
        } else if (propertyName.equals(IInternalDebugUIConstants.PREF_MAX_DETAIL_LENGTH)) {
            this.populateDetailPane();
        }
    }

    public Viewer createViewer(Composite parent) {
        VariablesViewer variablesViewer = (VariablesViewer)this.createTreeViewer(parent);
        variablesViewer.setContext(new PresentationContext((IWorkbenchPart)this));
        variablesViewer.getPresentationContext().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                IAction action;
                if ("PROPERTY_COLUMNS".equals(event.getProperty()) && (action = VariablesView.this.getAction("ShowTypeNames")) != null) {
                    action.setEnabled(event.getNewValue() == null);
                }
            }
        });
        this.createDetailsViewer();
        this.fSashForm.setMaximizedControl(variablesViewer.getControl());
        this.createOrientationActions(variablesViewer);
        IPreferenceStore prefStore = DebugUIPlugin.getDefault().getPreferenceStore();
        String orientation = prefStore.getString(this.getDetailPanePreferenceKey());
        int i = 0;
        while (i < this.fToggleDetailPaneActions.length) {
            this.fToggleDetailPaneActions[i].setChecked(this.fToggleDetailPaneActions[i].getOrientation().equals(orientation));
            ++i;
        }
        this.setDetailPaneOrientation(orientation);
        IMemento memento = this.getMemento();
        if (memento != null) {
            variablesViewer.initState(memento);
        }
        return variablesViewer;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(IViewSite site, IMemento memento) throws PartInitException {
        IMemento mem;
        super.init(site, memento);
        this.PREF_STATE_MEMENTO = String.valueOf(this.PREF_STATE_MEMENTO) + site.getId();
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        String string = store.getString(this.PREF_STATE_MEMENTO);
        if (string.length() > 0) {
            ByteArrayInputStream bin = new ByteArrayInputStream(string.getBytes());
            InputStreamReader reader = new InputStreamReader(bin);
            try {
                try {
                    XMLMemento stateMemento = XMLMemento.createReadRoot((Reader)reader);
                    this.setMemento((IMemento)stateMemento);
                }
                catch (WorkbenchException workbenchException) {}
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    reader.close();
                    bin.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var8_10 = null;
            }
            try {}
            catch (IOException iOException) {}
            reader.close();
            bin.close();
        }
        if ((mem = this.getMemento()) != null) {
            Integer sw = mem.getInteger(SASH_VIEW_PART);
            if (sw != null) {
                this.setLastSashWeights(new int[]{sw, mem.getInteger(SASH_DETAILS_PART)});
            } else {
                this.setLastSashWeights(DEFAULT_SASH_WEIGHTS);
            }
        }
        site.getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void partDeactivated(IWorkbenchPart part) {
        String id = part.getSite().getId();
        if (id.equals(this.getSite().getId())) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(bout);
            try {
                try {
                    XMLMemento memento = XMLMemento.createWriteRoot((String)"VariablesViewMemento");
                    this.saveViewerState((IMemento)memento);
                    memento.save((Writer)writer);
                    IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
                    String xmlString = bout.toString();
                    store.putValue(this.PREF_STATE_MEMENTO, xmlString);
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    writer.close();
                    bout.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var8_10 = null;
            }
            try {}
            catch (IOException iOException) {}
            writer.close();
            bout.close();
        }
        super.partDeactivated(part);
    }

    public void saveViewerState(IMemento memento) {
        if (this.fSashForm != null && !this.fSashForm.isDisposed()) {
            int[] weights = this.fSashForm.getWeights();
            memento.putInteger(SASH_VIEW_PART, weights[0]);
            memento.putInteger(SASH_DETAILS_PART, weights[1]);
        }
        this.getVariablesViewer().saveState(memento);
    }

    protected String getDetailPanePreferenceKey() {
        return "Variables.detail.orientation";
    }

    protected Viewer createTreeViewer(Composite parent) {
        this.fModelPresentation = new VariablesViewModelPresentation();
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        this.fSashForm = new SashForm(parent, 0);
        final VariablesViewer variablesViewer = this.createVariablesViewer((Composite)this.fSashForm);
        variablesViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                VariablesView.this.getVariablesViewSelectionProvider().setUnderlyingSelectionProvider((ISelectionProvider)variablesViewer);
                VariablesView.this.setAction(SELECT_ALL_ACTION, VariablesView.this.getAction(VARIABLES_SELECT_ALL_ACTION));
                VariablesView.this.setAction(COPY_ACTION, VariablesView.this.getAction(IDebugView.COPY_ACTION));
                VariablesView.this.getViewSite().getActionBars().updateActionBars();
                VariablesView.this.setFocusViewer(VariablesView.this.getViewer());
            }
        });
        variablesViewer.addPostSelectionChangedListener(this.getTreeSelectionChangedListener());
        this.getVariablesViewSelectionProvider().setUnderlyingSelectionProvider((ISelectionProvider)variablesViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.getVariablesViewSelectionProvider());
        DebugContextManager.getDefault().addDebugContextListener(this, this.getSite().getWorkbenchWindow());
        return variablesViewer;
    }

    protected VariablesViewer createVariablesViewer(Composite parent) {
        return new VariablesViewer(parent, 268501762, this);
    }

    protected void createDetailsViewer() {
        SourceViewer detailsViewer;
        this.fDetailViewer = detailsViewer = new SourceViewer((Composite)this.fSashForm, null, 768);
        detailsViewer.setDocument(this.getDetailDocument());
        detailsViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.DetailPaneFont"));
        this.getDetailDocument().addDocumentListener(this.getDetailDocumentListener());
        detailsViewer.setEditable(false);
        Control control = detailsViewer.getControl();
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        detailsViewer.getSelectionProvider().addSelectionChangedListener(this.getDetailSelectionChangedListener());
        detailsViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                VariablesView.this.getVariablesViewSelectionProvider().setUnderlyingSelectionProvider(VariablesView.this.getDetailViewer().getSelectionProvider());
                VariablesView.this.setAction(SELECT_ALL_ACTION, VariablesView.this.getAction(DETAIL_SELECT_ALL_ACTION));
                VariablesView.this.setAction(COPY_ACTION, VariablesView.this.getAction(DETAIL_COPY_ACTION));
                VariablesView.this.getViewSite().getActionBars().updateActionBars();
                VariablesView.this.setFocusViewer((Viewer)VariablesView.this.getDetailViewer());
            }
        });
        this.createDetailContextMenu((Control)detailsViewer.getTextWidget());
        detailsViewer.getTextWidget().addMouseListener((MouseListener)this.getCursorListener());
        detailsViewer.getTextWidget().addKeyListener((KeyListener)this.getCursorListener());
    }

    protected String getHelpContextId() {
        return IDebugHelpContextIds.VARIABLE_VIEW;
    }

    public void setDetailPaneOrientation(String orientation) {
        if (orientation.equals(this.fCurrentDetailPaneOrientation)) {
            return;
        }
        if (orientation.equals("Variables.detail.orientation.hidden")) {
            this.hideDetailPane();
        } else {
            int vertOrHoriz = orientation.equals("Variables.detail.orientation.underneath") ? 512 : 256;
            this.fSashForm.setOrientation(vertOrHoriz);
            if ("Variables.detail.orientation.hidden".equals(this.fCurrentDetailPaneOrientation)) {
                this.showDetailPane();
            }
        }
        this.fCurrentDetailPaneOrientation = orientation;
        DebugUIPlugin.getDefault().getPreferenceStore().setValue(this.getDetailPanePreferenceKey(), orientation);
    }

    private void hideDetailPane() {
        if (this.fToggledDetailOnce) {
            this.setLastSashWeights(this.fSashForm.getWeights());
        }
        this.fSashForm.setMaximizedControl(this.getViewer().getControl());
    }

    private void showDetailPane() {
        this.fSashForm.setMaximizedControl(null);
        this.fSashForm.setWeights(this.getLastSashWeights());
        this.populateDetailPane();
        this.revealTreeSelection();
        this.fToggledDetailOnce = true;
    }

    protected void revealTreeSelection() {
        Object selected;
        ISelection selection;
        StructuredViewer viewer = (StructuredViewer)this.getViewer();
        if (viewer != null && (selection = viewer.getSelection()) instanceof IStructuredSelection && (selected = ((IStructuredSelection)selection).getFirstElement()) != null) {
            viewer.reveal(selected);
        }
    }

    public void toggleDetailPaneWordWrap(boolean on) {
        this.fDetailViewer.getTextWidget().setWordWrap(on);
    }

    protected int[] getLastSashWeights() {
        if (this.fLastSashWeights == null) {
            this.fLastSashWeights = DEFAULT_SASH_WEIGHTS;
        }
        return this.fLastSashWeights;
    }

    protected void setLastSashWeights(int[] weights) {
        this.fLastSashWeights = weights;
    }

    protected void createDetailContextMenu(Control menuControl) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                VariablesView.this.fillDetailContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(menuControl);
        menuControl.setMenu(menu);
        this.getSite().registerContextMenu("org.eclipse.debug.ui.VariableView.detail", menuMgr, this.getDetailViewer().getSelectionProvider());
        this.addContextMenuManager((IMenuManager)menuMgr);
    }

    protected void createActions() {
        Object action = new ShowTypesAction(this);
        this.setAction("ShowTypeNames", (IAction)action);
        action = new ToggleLogicalStructureAction(this);
        this.setAction("ToggleContentProviders", (IAction)action);
        action = new CollapseAllAction((AsynchronousTreeViewer)this.getViewer());
        this.setAction("CollapseAll", (IAction)action);
        action = new ChangeVariableValueAction(this);
        action.setEnabled(false);
        this.setAction("ChangeVariableValue", (IAction)action);
        TextViewerAction textAction = new TextViewerAction((ITextViewer)this.getDetailViewer(), 13);
        textAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        textAction.configureAction(VariablesViewMessages.VariablesView_Co_ntent_Assist_3, "", "");
        textAction.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_CONTENT_ASSIST"));
        textAction.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_CONTENT_ASSIST"));
        textAction.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_CONTENT_ASSIST"));
        this.setAction("ContentAssist", (IAction)textAction);
        this.getSite().getKeyBindingService().registerAction((IAction)textAction);
        textAction = new TextViewerAction((ITextViewer)this.getDetailViewer(), 7);
        textAction.configureAction(VariablesViewMessages.VariablesView_Select__All_5, "", "");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        this.setAction(DETAIL_SELECT_ALL_ACTION, (IAction)textAction);
        textAction = new TextViewerAction((ITextViewer)this.getDetailViewer(), 4);
        textAction.configureAction(VariablesViewMessages.VariablesView__Copy_8, "", "");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.setAction(DETAIL_COPY_ACTION, (IAction)textAction);
        textAction = new TextViewerAction((ITextViewer)this.getDetailViewer(), 3);
        textAction.configureAction(VariablesViewMessages.VariablesView_Cu_t_11, "", "");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.setAction(ActionFactory.CUT.getId(), (IAction)textAction);
        textAction = new TextViewerAction((ITextViewer)this.getDetailViewer(), 5);
        textAction.configureAction(VariablesViewMessages.VariablesView__Paste_14, "", "");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.setAction(ActionFactory.PASTE.getId(), (IAction)textAction);
        action = new FindElementAction(this, this.getVariablesViewer());
        this.setAction(FIND_ELEMENT, (IAction)action);
        ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.debug.internal.ui.views.variables.VariablesViewMessages");
        action = new FindReplaceAction(bundle, "find_replace_action_", (IWorkbenchPart)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        this.setAction("FindReplaceText", (IAction)action);
        this.setAction(FIND_ACTION, (IAction)new DelegatingFindAction());
        this.fSelectionActions.add(ActionFactory.COPY.getId());
        this.fSelectionActions.add(ActionFactory.CUT.getId());
        this.fSelectionActions.add(ActionFactory.PASTE.getId());
        this.fSelectionActions.add("FindReplaceText");
        this.updateAction("FindReplaceText");
        action = new AssignValueAction(this, (ISourceViewer)this.fDetailViewer);
        this.setAction("AssignValue", (IAction)action);
        this.fStatusLineItem = new StatusLineContributionItem("ModeContributionItem");
        IActionBars actionBars = this.getViewSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        manager.add((IContributionItem)this.fStatusLineItem);
    }

    protected void createUndoRedoActions() {
        this.disposeUndoRedoAction(ITextEditorActionConstants.UNDO);
        this.disposeUndoRedoAction(ITextEditorActionConstants.REDO);
        IUndoContext undoContext = this.getUndoContext();
        if (undoContext != null) {
            UndoActionHandler undoAction = new UndoActionHandler(this.getSite(), undoContext);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)undoAction, IAbstractTextEditorHelpContextIds.UNDO_ACTION);
            undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
            this.setAction(ITextEditorActionConstants.UNDO, (IAction)undoAction);
            RedoActionHandler redoAction = new RedoActionHandler(this.getSite(), undoContext);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)redoAction, IAbstractTextEditorHelpContextIds.REDO_ACTION);
            redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
            this.setAction(ITextEditorActionConstants.REDO, (IAction)redoAction);
        }
    }

    private void disposeUndoRedoAction(String actionId) {
        OperationHistoryActionHandler action = (OperationHistoryActionHandler)this.getAction(actionId);
        if (action != null) {
            action.dispose();
            this.setAction(actionId, null);
        }
    }

    private IUndoContext getUndoContext() {
        IUndoManager undoManager = this.fDetailViewer.getUndoManager();
        if (undoManager instanceof IUndoManagerExtension) {
            return ((IUndoManagerExtension)undoManager).getUndoContext();
        }
        return null;
    }

    private void createOrientationActions(VariablesViewer viewer) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        this.fToggleDetailPaneActions = new ToggleDetailPaneAction[3];
        this.fToggleDetailPaneActions[0] = new ToggleDetailPaneAction(this, "Variables.detail.orientation.underneath", null);
        this.fToggleDetailPaneActions[1] = new ToggleDetailPaneAction(this, "Variables.detail.orientation.right", null);
        this.fToggleDetailPaneActions[2] = new ToggleDetailPaneAction(this, "Variables.detail.orientation.hidden", this.getToggleActionLabel());
        viewMenu.add((IContributionItem)new Separator());
        final MenuManager layoutSubMenu = new MenuManager(VariablesViewMessages.VariablesView_40);
        layoutSubMenu.setRemoveAllWhenShown(true);
        layoutSubMenu.add((IAction)this.fToggleDetailPaneActions[0]);
        layoutSubMenu.add((IAction)this.fToggleDetailPaneActions[1]);
        layoutSubMenu.add((IAction)this.fToggleDetailPaneActions[2]);
        viewMenu.add((IContributionItem)layoutSubMenu);
        viewMenu.add((IContributionItem)new Separator());
        this.fConfigureColumnsAction = new ConfigureColumnsAction(viewer);
        this.setAction("ToggleColmns", (IAction)new ToggleShowColumnsAction(viewer));
        layoutSubMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                layoutSubMenu.add((IAction)VariablesView.this.fToggleDetailPaneActions[0]);
                layoutSubMenu.add((IAction)VariablesView.this.fToggleDetailPaneActions[1]);
                layoutSubMenu.add((IAction)VariablesView.this.fToggleDetailPaneActions[2]);
                IAction action = VariablesView.this.getAction("ToggleColmns");
                ((IUpdate)action).update();
                if (action.isEnabled()) {
                    layoutSubMenu.add(action);
                }
                VariablesView.this.fConfigureColumnsAction.update();
                if (VariablesView.this.fConfigureColumnsAction.isEnabled()) {
                    layoutSubMenu.add((IAction)VariablesView.this.fConfigureColumnsAction);
                }
            }
        });
    }

    protected String getToggleActionLabel() {
        return VariablesViewMessages.VariablesView_41;
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator(this.getClass().getName()));
        tbm.add((IContributionItem)new Separator("renderGroup"));
        tbm.add(this.getAction("ShowTypeNames"));
        tbm.add(this.getAction("ToggleContentProviders"));
        tbm.add(this.getAction("CollapseAll"));
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("emptyVariableGroup"));
        menu.add((IContributionItem)new Separator("variableGroup"));
        menu.add(this.getAction(FIND_ELEMENT));
        menu.add(this.getAction("ChangeVariableValue"));
        AvailableLogicalStructuresAction action = new AvailableLogicalStructuresAction(this);
        if (action.isEnabled()) {
            menu.add((IAction)action);
        }
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("emptyNavigationGroup"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected void fillDetailContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("variableGroup"));
        menu.add(this.getAction("AssignValue"));
        menu.add(this.getAction("ContentAssist"));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction(ActionFactory.CUT.getId()));
        menu.add(this.getAction(String.valueOf(ActionFactory.COPY.getId()) + ".Detail"));
        menu.add(this.getAction(ActionFactory.PASTE.getId()));
        menu.add(this.getAction(DETAIL_SELECT_ALL_ACTION));
        menu.add((IContributionItem)new Separator("FIND"));
        menu.add(this.getAction("FindReplaceText"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected ISelectionChangedListener getTreeSelectionChangedListener() {
        if (this.fTreeSelectionChangedListener == null) {
            this.fTreeSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSelectionProvider().equals(VariablesView.this.getViewer())) {
                        VariablesView.this.clearStatusLine();
                        VariablesView.this.getVariablesViewSelectionProvider().fireSelectionChanged(event);
                        if (VariablesView.this.fSashForm.getMaximizedControl() == VariablesView.this.getViewer().getControl()) {
                            return;
                        }
                        Job job = new Job(this, "Detail Pane Populate Job", event){
                            final /* synthetic */ 6 this$1;
                            private final /* synthetic */ SelectionChangedEvent val$event;
                            {
                                this.this$1 = var1_1;
                                this.val$event = selectionChangedEvent;
                            }

                            protected IStatus run(IProgressMonitor monitor) {
                                IStructuredSelection selection = (IStructuredSelection)this.val$event.getSelection();
                                6.access$0(this.this$1).populateDetailPaneFromSelection(selection);
                                return Status.OK_STATUS;
                            }
                        };
                        job.setSystem(true);
                        job.schedule();
                        VariablesView.this.treeSelectionChanged(event);
                    }
                }

                static /* synthetic */ VariablesView access$0(6 var0) {
                    return var0.VariablesView.this;
                }
            };
        }
        return this.fTreeSelectionChangedListener;
    }

    protected void treeSelectionChanged(SelectionChangedEvent event) {
    }

    public void populateDetailPane() {
        Viewer viewer;
        if (this.isDetailPaneVisible() && (viewer = this.getViewer()) != null) {
            final IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
            Job job = new Job("Populate Detail Pane"){

                protected IStatus run(IProgressMonitor monitor) {
                    VariablesView.this.populateDetailPaneFromSelection(selection);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    protected void populateDetailPaneFromSelection(final IStructuredSelection selection) {
        WorkbenchJob wJob = new WorkbenchJob("Populate Details Pane"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                VariablesView.this.getDetailDocument().set("");
                return Status.OK_STATUS;
            }
        };
        wJob.setSystem(true);
        wJob.schedule();
        try {
            if (!selection.isEmpty()) {
                IValue val = null;
                Object obj = selection.getFirstElement();
                if (obj instanceof IndexedVariablePartition) {
                    return;
                }
                if (obj instanceof IVariable) {
                    val = ((IVariable)obj).getValue();
                } else if (obj instanceof IExpression) {
                    val = ((IExpression)obj).getValue();
                }
                if (val == null) {
                    return;
                }
                if (this.fValueSelection != null && this.fValueSelection.equals(selection)) {
                    return;
                }
                final IValue finalVal = val;
                wJob = new WorkbenchJob("Populate Details Pane"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        VariablesView.this.getDetailDocument().set("");
                        VariablesView.this.setDebugModel(finalVal.getModelIdentifier());
                        VariablesView.this.fValueSelection = selection;
                        VariablesView.this.fSelectionIterator = selection.iterator();
                        VariablesView.this.fSelectionIterator.next();
                        VariablesView.this.fLastValueDetail = finalVal;
                        VariablesView.this.getModelPresentation().computeDetail(finalVal, VariablesView.this);
                        return Status.OK_STATUS;
                    }
                };
                wJob.setSystem(true);
                wJob.schedule();
            }
        }
        catch (DebugException debugException) {
            wJob = new WorkbenchJob("Populate Details Pane"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    VariablesView.this.getDetailDocument().set(VariablesViewMessages.VariablesView__error_occurred_retrieving_value__18);
                    return Status.OK_STATUS;
                }
            };
            wJob.setSystem(true);
            wJob.schedule();
        }
    }

    public void detailComputed(final IValue value, final String result) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (VariablesView.this.isAvailable()) {
                    if (value == VariablesView.this.fLastValueDetail) {
                        String insert = result;
                        int length = VariablesView.this.getDetailDocument().getLength();
                        if (length > 0) {
                            insert = "\n" + result;
                        }
                        try {
                            int max = DebugUIPlugin.getDefault().getPreferenceStore().getInt(IInternalDebugUIConstants.PREF_MAX_DETAIL_LENGTH);
                            if (max > 0 && insert.length() > max) {
                                insert = String.valueOf(insert.substring(0, max)) + "...";
                            }
                            VariablesView.this.getDetailDocument().replace(length, 0, insert);
                        }
                        catch (BadLocationException e) {
                            DebugUIPlugin.log(e);
                        }
                        VariablesView.this.fLastValueDetail = null;
                    }
                    if (VariablesView.this.fSelectionIterator != null && VariablesView.this.fSelectionIterator.hasNext()) {
                        Object obj = VariablesView.this.fSelectionIterator.next();
                        IValue val = null;
                        try {
                            if (obj instanceof IVariable) {
                                val = ((IVariable)obj).getValue();
                            } else if (obj instanceof IExpression) {
                                val = ((IExpression)obj).getValue();
                            }
                            VariablesView.this.fLastValueDetail = val;
                            VariablesView.this.getModelPresentation().computeDetail(val, VariablesView.this);
                        }
                        catch (DebugException e) {
                            DebugUIPlugin.log(e);
                            VariablesView.this.getDetailDocument().set(VariablesViewMessages.VariablesView__error_occurred_retrieving_value__18);
                        }
                    } else {
                        VariablesView.this.fValueSelection = null;
                        VariablesView.this.fSelectionIterator = null;
                    }
                }
            }
        };
        this.asyncExec(runnable);
    }

    protected ISelectionChangedListener getDetailSelectionChangedListener() {
        if (this.fDetailSelectionChangedListener == null) {
            this.fDetailSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSelectionProvider().equals(VariablesView.this.getVariablesViewSelectionProvider().getUnderlyingSelectionProvider())) {
                        VariablesView.this.getVariablesViewSelectionProvider().fireSelectionChanged(event);
                        VariablesView.this.updateSelectionDependentActions();
                    }
                }
            };
        }
        return this.fDetailSelectionChangedListener;
    }

    protected IDocumentListener getDetailDocumentListener() {
        if (this.fDetailDocumentListener == null) {
            this.fDetailDocumentListener = new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    VariablesView.this.updateAction(ActionFactory.FIND.getId());
                }
            };
        }
        return this.fDetailDocumentListener;
    }

    protected IDocument getDetailDocument() {
        if (this.fDetailDocument == null) {
            this.fDetailDocument = new Document();
        }
        return this.fDetailDocument;
    }

    protected IDebugModelPresentation getModelPresentation() {
        if (this.fModelPresentation == null) {
            this.fModelPresentation = new VariablesViewModelPresentation();
        }
        return this.fModelPresentation;
    }

    protected ISourceViewer getDetailViewer() {
        return this.fDetailViewer;
    }

    protected SashForm getSashForm() {
        return this.fSashForm;
    }

    public Object getAdapter(Class required) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.IFindReplaceTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            return this.getDetailViewer().getFindReplaceTarget();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jface.text.ITextViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(required)) {
            return this.getDetailViewer();
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.debug.ui.IDebugModelPresentation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.equals(required)) {
            return this.getModelPresentation();
        }
        return super.getAdapter(required);
    }

    protected void updateSelectionDependentActions() {
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction((String)iterator.next());
        }
    }

    protected void updateAction(String actionId) {
        IAction action = this.getAction(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected boolean isDetailPaneVisible() {
        return !this.fToggleDetailPaneActions[2].isChecked();
    }

    protected void setDebugModel(String id) {
        if (id != this.fDebugModelIdentifier) {
            this.fDebugModelIdentifier = id;
            this.configureDetailsViewer();
        } else {
            this.updateAction("ContentAssist");
        }
    }

    protected String getDebugModel() {
        return this.fDebugModelIdentifier;
    }

    private void setDetailViewerConfiguration(SourceViewerConfiguration config) {
        this.fSourceViewerConfiguration = config;
    }

    protected SourceViewerConfiguration getDetailViewerConfiguration() {
        return this.fSourceViewerConfiguration;
    }

    protected Control getDefaultControl() {
        return this.fSashForm;
    }

    public void handleException(DebugException e) {
        this.showMessage(e.getMessage());
    }

    protected VariablesViewSelectionProvider getVariablesViewSelectionProvider() {
        return this.fSelectionProvider;
    }

    public void contextActivated(ISelection selection, IWorkbenchPart part) {
        if (!this.isAvailable() || !this.isVisible()) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            this.setViewerInput(((IStructuredSelection)selection).getFirstElement());
        }
        this.showViewer();
        this.updateAction("ContentAssist");
        this.updateAction(FIND_ELEMENT);
        this.updateAction(FIND_ACTION);
    }

    public void contextChanged(ISelection selection, IWorkbenchPart part) {
    }

    public void doubleClick(DoubleClickEvent event) {
        IAction action = this.getAction("Double_Click_ActionId");
        if (action != null && action.isEnabled()) {
            action.run();
        }
    }

    public void setFocus() {
        if (this.getFocusViewer() == null) {
            super.setFocus();
        } else {
            this.getFocusViewer().getControl().setFocus();
        }
    }

    protected void setFocusViewer(Viewer viewer) {
        this.fFocusViewer = viewer;
    }

    protected Viewer getFocusViewer() {
        return this.fFocusViewer;
    }

    public IDebugModelPresentation getPresentation(String id) {
        if (this.getViewer() instanceof StructuredViewer) {
            IDebugModelPresentation lp = this.getModelPresentation();
            if (lp instanceof DelegatingModelPresentation) {
                return ((DelegatingModelPresentation)lp).getPresentation(id);
            }
            if (lp instanceof LazyModelPresentation && ((LazyModelPresentation)lp).getDebugModelIdentifier().equals(id)) {
                return lp;
            }
        }
        return null;
    }

    public Composite getDetailViewerParent() {
        return this.fSashForm;
    }

    public boolean isMainViewerAvailable() {
        return this.isAvailable();
    }

    public void setShowLogicalStructure(boolean flag) {
        this.fShowLogical = flag;
    }

    public boolean isShowLogicalStructure() {
        return this.fShowLogical;
    }

    protected int getArrayPartitionSize() {
        return 100;
    }

    protected void becomesHidden() {
        this.setViewerInput(null);
        super.becomesHidden();
    }

    protected void becomesVisible() {
        super.becomesVisible();
        ISelection selection = DebugContextManager.getDefault().getActiveContext(this.getSite().getWorkbenchWindow());
        this.contextActivated(selection, null);
    }

    protected AbstractViewerState getViewerState() {
        return new ViewerState(this.getVariablesViewer());
    }

    protected VariablesViewer getVariablesViewer() {
        return (VariablesViewer)this.getViewer();
    }

    private ICursorListener getCursorListener() {
        if (this.fCursorListener == null) {
            this.fCursorListener = new ICursorListener(){

                public void keyPressed(KeyEvent e) {
                    VariablesView.this.fStatusLineItem.setText(VariablesView.this.getCursorPosition());
                }

                public void keyReleased(KeyEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    VariablesView.this.fStatusLineItem.setText(VariablesView.this.getCursorPosition());
                }
            };
        }
        return this.fCursorListener;
    }

    protected String getCursorPosition() {
        if (this.getDetailViewer() == null) {
            return "";
        }
        StyledText styledText = this.getDetailViewer().getTextWidget();
        int caret = styledText.getCaretOffset();
        IDocument document = this.getDetailViewer().getDocument();
        if (document == null) {
            return "";
        }
        try {
            int line = document.getLineOfOffset(caret);
            int lineOffset = document.getLineOffset(line);
            int tabWidth = styledText.getTabs();
            int column = 0;
            int i = lineOffset;
            while (i < caret) {
                column = '\t' == document.getChar(i) ? (column += tabWidth - (tabWidth == 0 ? 0 : column % tabWidth)) : ++column;
                ++i;
            }
            this.fLineLabel.fValue = line + 1;
            this.fColumnLabel.fValue = column + 1;
            return MessageFormat.format((String)this.fPositionLabelPattern, (Object[])this.fPositionLabelPatternArguments);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    protected void clearStatusLine() {
        IStatusLineManager manager = this.getViewSite().getActionBars().getStatusLineManager();
        manager.setErrorMessage(null);
        manager.setMessage(null);
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        if (changeId.equals("reset")) {
            this.setLastSashWeights(DEFAULT_SASH_WEIGHTS);
            this.fSashForm.setWeights(DEFAULT_SASH_WEIGHTS);
        }
    }

    class DelegatingFindAction
    extends Action
    implements IUpdate {
        DelegatingFindAction() {
        }

        private IAction getFindAction() {
            if (VariablesView.this.getDetailViewer().getTextWidget().isFocusControl()) {
                return VariablesView.this.getAction("FindReplaceText");
            }
            return VariablesView.this.getAction(VariablesView.FIND_ELEMENT);
        }

        public void run() {
            this.getFindAction().run();
        }

        public void update() {
            this.setEnabled(this.getFindAction().isEnabled());
        }
    }

    static interface ICursorListener
    extends MouseListener,
    KeyListener {
    }

    private static final class MRUMap
    extends LinkedHashMap {
        private static final long serialVersionUID = 1L;
        private final int fMaxSize;

        public MRUMap(int maxSize) {
            Assert.isLegal((maxSize > 0 ? 1 : 0) != 0);
            this.fMaxSize = maxSize;
        }

        public Object put(Object key, Object value) {
            Object object = this.remove(key);
            super.put(key, value);
            return object;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.fMaxSize;
        }
    }

    private static class PositionLabelValue {
        public int fValue;

        private PositionLabelValue() {
        }

        public String toString() {
            return String.valueOf(this.fValue);
        }
    }

    class VariablesViewSelectionProvider
    implements ISelectionProvider {
        private ListenerList fListeners = new ListenerList();
        private ISelectionProvider fUnderlyingSelectionProvider;

        VariablesViewSelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.add((Object)listener);
        }

        public ISelection getSelection() {
            return this.getUnderlyingSelectionProvider().getSelection();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.remove((Object)listener);
        }

        public void setSelection(ISelection selection) {
            this.getUnderlyingSelectionProvider().setSelection(selection);
        }

        protected ISelectionProvider getUnderlyingSelectionProvider() {
            return this.fUnderlyingSelectionProvider;
        }

        protected void setUnderlyingSelectionProvider(ISelectionProvider underlyingSelectionProvider) {
            this.fUnderlyingSelectionProvider = underlyingSelectionProvider;
        }

        protected void fireSelectionChanged(SelectionChangedEvent event) {
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
                listener.selectionChanged(event);
                ++i;
            }
        }
    }
}

