/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.internal.ui.explorer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;

public class ServerExplorerViewer
extends CommonViewer {
    public ServerExplorerViewer(String id, Composite parent) {
        this(id, parent, 0);
    }

    public ServerExplorerViewer(String id, Composite parent, int style) {
        super(id, parent, style);
    }

    private void traverseChildrenForType(List objectsList, TreeItem[] items, Class type) {
        int i = 0;
        int n = items.length;
        while (i < n) {
            TreeItem item = items[i];
            if (item.getData() != null && type.isAssignableFrom(item.getData().getClass())) {
                objectsList.add(item.getData());
            }
            this.traverseChildrenForType(objectsList, item.getItems(), type);
            ++i;
        }
    }

    public void selectInExplorer(ISelection selection) {
        this.setSelectionToWidget(selection, true);
        super.updateSelection(selection);
    }

    public void updateExplorerSelection(ISelection selection) {
        super.updateSelection(selection);
    }

    public Object[] getServerExplorerObjectsByType(ConnectionInfo info, Class type) {
        Database database = info.getSharedDatabase();
        return this.getServerExplorerObjectsByType(database, type);
    }

    public Object[] getServerExplorerObjectsByType(Object parent, Class type) {
        ArrayList objectsList = new ArrayList();
        if (parent != null) {
            TreeItem[] items = this.getServerExplorerChildren(parent);
            this.traverseChildrenForType(objectsList, items, type);
        }
        return objectsList.toArray(new Object[objectsList.size()]);
    }

    public TreeItem[] getServerExplorerChildren(Object object) {
        Widget w = this.findItem(object);
        return w == null ? new TreeItem[]{} : (TreeItem[])this.getChildren(w);
    }

    public Object getParent(Object object) {
        Widget w = this.findItem(object);
        return w == null || !(w instanceof TreeItem) || (w = this.getParentItem((Item)((TreeItem)w))) == null ? null : w.getData();
    }
}

