/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup;

import java.sql.Connection;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.containment.ContainmentService;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.models.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.DataType;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;
import org.eclipse.wst.rdb.server.internal.ui.query.execute.QueryOutputHelper;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;

public class SampleContentsAction
implements IViewActionDelegate {
    private IStructuredSelection selection;
    private final String SQ = "'";
    private final String SQ2 = "`";
    private final String DQ = "\"";
    private String quote = "";

    public void init(IViewPart viewPart) {
        this.quote = "\"";
    }

    public void run(IAction action) {
        Connection connection = null;
        if (!this.selection.isEmpty()) {
            Iterator iter = this.selection.iterator();
            String selectString = "";
            Object selectedObj = iter.next();
            if (selectedObj instanceof Table) {
                if (connection == null) {
                    connection = ((ICatalogObject)selectedObj).getConnection();
                }
                Schema schema = ((Table)selectedObj).getSchema();
                Database database = schema.getDatabase();
                DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
                this.quote = databaseDefinition.getIdentifierQuoteString();
                selectString = String.valueOf(selectString) + "SELECT * FROM " + this.getFullyQualifiedName((Table)selectedObj);
            } else if (selectedObj instanceof Column) {
                PredefinedDataTypeDefinition datatypeDefinition;
                if (connection == null) {
                    connection = ((ICatalogObject)selectedObj).getConnection();
                }
                Column column = (Column)selectedObj;
                String columnName = column.getName();
                Database database = column.getTable().getSchema().getDatabase();
                DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
                DataType datatype = column.getDataType();
                if (datatype instanceof DistinctUserDefinedType) {
                    datatype = ((DistinctUserDefinedType)datatype).getPredefinedRepresentation();
                }
                if ((datatypeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(datatype.getName())).isOrderingSupported() && datatypeDefinition.isGroupingSupported()) {
                    selectString = String.valueOf(selectString) + "SELECT DISTINCT " + this.wrapName(columnName) + " , COUNT(*) AS OCCURRENCE";
                    selectString = String.valueOf(selectString) + " FROM " + this.getFullyQualifiedName(column.getTable());
                    selectString = String.valueOf(selectString) + " GROUP BY " + this.wrapName(columnName);
                    selectString = String.valueOf(selectString) + " ORDER BY " + this.wrapName(columnName);
                } else {
                    selectString = String.valueOf(selectString) + "SELECT " + this.wrapName(columnName);
                    selectString = String.valueOf(selectString) + " FROM " + this.getFullyQualifiedName(column.getTable());
                }
            }
            QueryOutputHelper queryHelper = new QueryOutputHelper(selectString, connection);
            queryHelper.setObjectName(ResourceLoader.INSTANCE.queryString("_UI_SAMPLE_CONTENTS_OUTPUTVIEW_TITLE"));
            queryHelper.runQuery();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
        if (action.isEnabled() && selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof EObject) {
            EObject o = (EObject)((IStructuredSelection)selection).getFirstElement();
            ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
            String groupID = containmentService.getGroupId(o);
            action.setEnabled(groupID != null && groupID.startsWith("core."));
        }
    }

    public void init(IAction action) {
        this.quote = "\"";
    }

    public void dispose() {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    private String wrapName(String name) {
        if (this.quote.equals("'") || this.quote.equals("`")) {
            return String.valueOf(this.quote) + SampleContentsAction.doubleStringDelim(name, this.quote) + this.quote;
        }
        return "\"" + SampleContentsAction.doubleStringDelim(name, "\"") + "\"";
    }

    public static String doubleStringDelim(String s, String delim) {
        if (delim == null || delim.length() == 0) {
            return s;
        }
        int i = s.indexOf(delim);
        if (i != -1) {
            StringBuffer sb = new StringBuffer(s);
            while (i != -1) {
                sb = sb.insert(i, delim);
                int j = i + 2 * delim.length();
                i = sb.toString().indexOf(delim, j);
            }
            return sb.toString();
        }
        return s;
    }

    private String getFullyQualifiedName(Table table) {
        return String.valueOf(this.wrapName(table.getSchema().getName())) + "." + this.wrapName(table.getName());
    }
}

