/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.api;

import org.eclipse.vtp.framework.api.BObject;
import org.eclipse.vtp.framework.api.BObjectException;
import org.eclipse.vtp.framework.api.BObjectType;

public class BDecimal
extends BObject {
    double value;

    protected BDecimal(BObjectType type, String name) {
        super(type, name);
    }

    public BDecimal(String name) {
        this(new BObjectType("Decimal", false, true), name);
    }

    public Object getValue() {
        return new Double(this.value);
    }

    public void setValue(Object obj) {
        if (obj instanceof Double) {
            this.value = (Double)obj;
        } else {
            String svalue = obj.toString();
            try {
                double dv;
                this.value = dv = Double.valueOf(svalue).doubleValue();
            }
            catch (Exception ex) {
                throw new BObjectException("Could not convert " + obj.getClass() + " to a number", ex);
            }
        }
    }

    public boolean compare(Object obj, int comparison) {
        double cvalue;
        if (obj instanceof Double) {
            cvalue = (Double)obj;
        } else {
            String svalue = obj.toString();
            try {
                cvalue = Double.valueOf(svalue);
            }
            catch (Exception exception) {
                return false;
            }
        }
        switch (comparison) {
            case 0: {
                return this.value == cvalue;
            }
            case 1: {
                return this.value != cvalue;
            }
            case 2: {
                return this.value < cvalue;
            }
            case 3: {
                return this.value <= cvalue;
            }
            case 4: {
                return this.value > cvalue;
            }
            case 5: {
                return this.value >= cvalue;
            }
        }
        return false;
    }

    public void addField(BObject field) {
        throw new BObjectException("Unsupported operation");
    }
}

