/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.api;

import org.eclipse.vtp.framework.api.BObject;
import org.eclipse.vtp.framework.api.BObjectException;
import org.eclipse.vtp.framework.api.BObjectType;

public class BNumber
extends BObject {
    int value;

    protected BNumber(BObjectType type, String name) {
        super(type, name);
    }

    public BNumber(String name) {
        this(new BObjectType("Number", false, true), name);
    }

    public Object getValue() {
        return new Integer(this.value);
    }

    public void setValue(Object obj) {
        if (obj instanceof Integer) {
            this.value = (Integer)obj;
        } else {
            String svalue = obj.toString();
            try {
                this.value = Integer.parseInt(svalue);
            }
            catch (Exception ex) {
                throw new BObjectException("Could not convert " + obj.getClass() + " to a number", ex);
            }
        }
    }

    public boolean compare(Object obj, int comparison) {
        int cvalue;
        if (obj instanceof Integer) {
            cvalue = (Integer)obj;
        } else {
            String svalue = obj.toString();
            try {
                cvalue = Integer.parseInt(svalue);
            }
            catch (Exception exception) {
                return false;
            }
        }
        switch (comparison) {
            case 0: {
                return this.value == cvalue;
            }
            case 1: {
                return this.value != cvalue;
            }
            case 2: {
                return this.value < cvalue;
            }
            case 3: {
                return this.value <= cvalue;
            }
            case 4: {
                return this.value > cvalue;
            }
            case 5: {
                return this.value >= cvalue;
            }
        }
        return false;
    }

    public void addField(BObject field) {
        throw new BObjectException("Unsupported operation");
    }
}

