/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.format;

import java.io.IOException;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.ui.internal.Logger;

public class StructuredFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList fDocuments = new LinkedList();
    private IStructuredFormatProcessor fFormatProcessor;
    private final LinkedList fPartitions = new LinkedList();
    private IRegion fRegion;

    public StructuredFormattingStrategy(IStructuredFormatProcessor formatProcessor) {
        this.fFormatProcessor = formatProcessor;
    }

    public void format() {
        super.format();
        IDocument document = (IDocument)this.fDocuments.removeFirst();
        TypedPosition partition = (TypedPosition)this.fPartitions.removeFirst();
        if (document != null && partition != null && this.fRegion != null && this.fFormatProcessor != null) {
            try {
                this.fFormatProcessor.formatDocument(document, this.fRegion.getOffset(), this.fRegion.getLength());
            }
            catch (IOException e) {
                Logger.log(1, e.getMessage());
            }
            catch (CoreException e) {
                Logger.log(1, e.getMessage());
            }
        }
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        this.fPartitions.addLast(context.getProperty((Object)"formatting.context.partition"));
        this.fDocuments.addLast(context.getProperty((Object)"formatting.context.medium"));
        this.fRegion = (IRegion)context.getProperty((Object)"formatting.context.region");
    }

    public void formatterStops() {
        super.formatterStops();
        this.fPartitions.clear();
        this.fDocuments.clear();
    }
}

