/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.editor.srgxml.ui.internal.wizards;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.vtp.editor.srgxml.ui.internal.Logger;
import org.eclipse.vtp.editor.srgxml.ui.internal.wizards.XMLWizardsMessages;

public class GrammarRulePage
extends WizardPage {
    private String rname = new String();
    private String fname = new String();
    private String wlist = new String();
    private Text ruleName;
    private Text fileName;
    private Text wordList;
    private Label ruleNameLbl;
    private Button fileNameButton;
    private Button fileRadioButton;
    private Button textRadioButton;
    String rootRule = null;
    static final int LINE2OFFSET = 15;

    public GrammarRulePage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public GrammarRulePage(String pageName, String title, ImageDescriptor titleImage, boolean pageStatus) {
        super(pageName);
        if (pageStatus) {
            this.setPageComplete(pageStatus);
        }
    }

    public String getFileName() {
        return this.fname;
    }

    public String getRuleName() {
        return this.rname;
    }

    public String getWordList() {
        return this.wlist;
    }

    public boolean performOk() {
        String namebuff = new String();
        this.rootRule = this.rname = this.ruleName.getText();
        this.fname = this.fileName.getText();
        this.wlist = this.wordList.getText();
        if (!this.ruleNameVerification(this.rname)) {
            this.setPageComplete(false);
            this.setErrorMessage(XMLWizardsMessages.SRGXMLPropertyPage_ruleNameError);
            return false;
        }
        this.setErrorMessage(null);
        if (this.wlist.length() == 0 && this.fname.length() == 0 || this.wlist == null && this.fname == null) {
            this.setPageComplete(true);
            return true;
        }
        this.setPageComplete(false);
        if (this.rname == null || this.rname.length() == 0) {
            return false;
        }
        namebuff = this.rname.trim();
        if (namebuff.length() == 0) {
            return false;
        }
        this.rname = namebuff;
        if (this.fileName.isEnabled()) {
            this.fname = this.fileName.getText();
            this.wlist = "";
            if (this.fname == null || this.fname.length() == 0) {
                return false;
            }
            namebuff = this.fname.trim();
            if (namebuff.length() == 0) {
                return false;
            }
            this.fname = namebuff;
            File theFile = new File(this.fname);
            String readbuff = new String();
            try {
                FileInputStream fin = new FileInputStream(theFile);
                InputStreamReader in = new InputStreamReader(fin);
                BufferedReader buffin = new BufferedReader(in);
                while ((readbuff = buffin.readLine()) != null) {
                    if (this.invalidChar(readbuff)) {
                        this.setErrorMessage(XMLWizardsMessages.SRGXMLPropertyPage_fileError);
                        return false;
                    }
                    this.setErrorMessage(null);
                }
            }
            catch (FileNotFoundException e) {
                Logger.logException("error opening SRGXML editor", e);
            }
            catch (IOException e) {
                Logger.logException(e);
                e.printStackTrace();
            }
        } else if (this.wordList.isEnabled()) {
            this.wlist = this.wordList.getText();
            this.fname = "";
            if (this.wlist == null || this.wlist.length() == 0) {
                return false;
            }
            if (this.invalidChar(this.wlist)) {
                this.setErrorMessage(XMLWizardsMessages.SRGXMLPropertyPage_wordListError);
                return false;
            }
            this.setErrorMessage(null);
        }
        this.setPageComplete(true);
        return true;
    }

    private boolean invalidChar(String word) {
        String invalidChars = ";{}()*?+";
        return this.in(word, invalidChars);
    }

    private boolean in(String st1, String st2) {
        int i = 0;
        while (i < st2.length()) {
            if (st1.indexOf(st2.charAt(i)) > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void browseDialog() {
        FileDialog dirDialog = new FileDialog(this.getShell(), 4096);
        String temp = dirDialog.open();
        if (temp != null && temp != "") {
            this.fileName.setText(temp);
            this.fileName.setFocus();
            this.setPageComplete(this.performOk());
        }
    }

    private void useWordList(boolean useWordList) {
        this.fileName.setEditable(!useWordList);
        this.fileName.setEnabled(!useWordList);
        this.wordList.setEditable(useWordList);
        this.wordList.setEnabled(useWordList);
        this.fileNameButton.setEnabled(!useWordList);
        this.wordList.setFocus();
        this.setPageComplete(this.performOk());
    }

    private void fileRadioDialog() {
        this.useWordList(false);
    }

    private void textRadioDialog() {
        this.useWordList(true);
    }

    public void setFields(Composite group) {
        this.fileNameButton = new Button(group, 12);
        this.fileRadioButton = new Button(group, 16);
        this.textRadioButton = new Button(group, 16);
        this.fileName = new Text(group, 2052);
        this.fileName.setToolTipText(XMLWizardsMessages.GrammarRulePage_filename_tooltip);
        this.ruleName = new Text(group, 2052);
        this.ruleNameLbl = new Label(group, 4);
        this.ruleNameLbl.setText(XMLWizardsMessages.SRGXMLPropertyPage_rulename);
        this.ruleNameLbl.setToolTipText(XMLWizardsMessages.GrammarRulePage_rulename_tooltip);
        this.ruleName.setToolTipText(XMLWizardsMessages.GrammarRulePage_rulename_tooltip);
        this.fileNameButton.setText(XMLWizardsMessages.SRGXMLPropertyPage_browse);
        this.fileNameButton.setToolTipText(XMLWizardsMessages.GrammarRulePage_browse_tooltip);
        this.fileRadioButton.setText(XMLWizardsMessages.SRGXMLPropertyPage_textfile);
        this.fileRadioButton.setToolTipText(XMLWizardsMessages.GrammarRulePage_rb_file_tooltip);
        this.textRadioButton.setText(XMLWizardsMessages.SRGXMLPropertyPage_wordlist);
        this.textRadioButton.setToolTipText(XMLWizardsMessages.GrammarRulePage_rb_wordlist_tooltip);
        this.wordList = new Text(group, 2562);
        this.wordList.setToolTipText(XMLWizardsMessages.GrammarRulePage_wordlist_tooltip);
        this.ruleName.setFocus();
        this.ruleName.setText(XMLWizardsMessages.SRGXMLPropertyPage_defaultRule);
        this.rname = this.ruleName.getText();
        this.wordList.setEditable(false);
        this.wordList.setEnabled(false);
        this.fileRadioButton.setSelection(true);
        this.ruleName.setFocus();
        this.fileNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrammarRulePage.this.browseDialog();
            }
        });
        this.fileRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrammarRulePage.this.fileRadioDialog();
            }
        });
        this.textRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrammarRulePage.this.textRadioDialog();
            }
        });
        this.ruleName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GrammarRulePage.this.setPageComplete(GrammarRulePage.this.performOk());
            }
        });
        this.fileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GrammarRulePage.this.setPageComplete(GrammarRulePage.this.performOk());
            }
        });
        this.wordList.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GrammarRulePage.this.setPageComplete(GrammarRulePage.this.performOk());
            }
        });
    }

    public void setFormLayout(Composite parent) {
        FormLayout layout = new FormLayout();
        layout.marginWidth = 3;
        layout.marginHeight = 3;
        parent.setLayout((Layout)layout);
        this.setFields(parent);
        FormData ruleNameLblFD = new FormData();
        ruleNameLblFD.top = new FormAttachment(0, 5);
        ruleNameLblFD.left = new FormAttachment(0, 5);
        this.ruleNameLbl.setLayoutData((Object)ruleNameLblFD);
        FormData ruleNameFD = new FormData();
        ruleNameFD.top = new FormAttachment(0, 5);
        ruleNameFD.left = new FormAttachment((Control)this.ruleNameLbl, 5);
        ruleNameFD.right = new FormAttachment(50, 0);
        this.ruleName.setLayoutData((Object)ruleNameFD);
        FormData fileRadioButtonFD = new FormData();
        fileRadioButtonFD.top = new FormAttachment((Control)this.ruleName, 15);
        fileRadioButtonFD.left = new FormAttachment(0, 5);
        this.fileRadioButton.setLayoutData((Object)fileRadioButtonFD);
        FormData fileNameFD = new FormData();
        fileNameFD.top = new FormAttachment((Control)this.fileRadioButton, 15);
        fileNameFD.left = new FormAttachment(0, 5);
        fileNameFD.right = new FormAttachment(40, 0);
        this.fileName.setLayoutData((Object)fileNameFD);
        FormData fileNameButtonFD = new FormData();
        fileNameButtonFD.top = new FormAttachment((Control)this.fileRadioButton, 15);
        fileNameButtonFD.left = new FormAttachment((Control)this.fileName, 10);
        this.fileNameButton.setLayoutData((Object)fileNameButtonFD);
        FormData textRadioButtonFD = new FormData();
        textRadioButtonFD.top = new FormAttachment((Control)this.fileName, 15);
        textRadioButtonFD.left = new FormAttachment(0, 5);
        this.textRadioButton.setLayoutData((Object)textRadioButtonFD);
        FormData wordListFD = new FormData();
        wordListFD.top = new FormAttachment((Control)this.textRadioButton, 15);
        wordListFD.left = new FormAttachment(0, 5);
        wordListFD.right = new FormAttachment(100, -5);
        wordListFD.bottom = new FormAttachment(100, -5);
        this.wordList.setLayoutData((Object)wordListFD);
    }

    public void createControl(Composite parent1) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent1, "org.eclipse.vtp.editor.srgxml.doc.word_list");
        Group grp = new Group(parent1, 0);
        grp.setText(XMLWizardsMessages.SRGXMLPropertyPage_tojsgftitle);
        this.setFormLayout((Composite)grp);
        this.setControl((Control)grp);
        this.setPageComplete(true);
    }

    public boolean ruleNameVerification(String rule) {
        if (rule.length() == 0) {
            return true;
        }
        StringBuffer letters = new StringBuffer(rule);
        if (!Character.isLetter(letters.charAt(0))) {
            return false;
        }
        if (rule.indexOf(":") != -1) {
            return false;
        }
        if (rule.indexOf(".") != -1) {
            return false;
        }
        if (rule.indexOf("-") != -1) {
            return false;
        }
        if (rule.compareTo("NULL") == 0) {
            return false;
        }
        if (rule.compareTo("VOID") == 0) {
            return false;
        }
        return rule.compareTo("GARBAGE") != 0;
    }
}

