/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.server.core.internal.JavaServerPlugin;
import org.eclipse.jst.server.core.internal.Messages;
import org.eclipse.jst.server.core.internal.RuntimeClasspathContainer;
import org.eclipse.jst.server.core.internal.RuntimeClasspathProviderWrapper;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class RuntimeClasspathContainerInitializer
extends ClasspathContainerInitializer {
    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        if (containerPath.segmentCount() > 0 && containerPath.segment(0).equals("org.eclipse.jst.server.core.container")) {
            RuntimeClasspathProviderWrapper delegate = null;
            IRuntime runtime = null;
            if (containerPath.segmentCount() > 2) {
                delegate = JavaServerPlugin.findRuntimeClasspathProvider(containerPath.segment(1));
                String runtimeId = containerPath.segment(2);
                if (runtimeId != null) {
                    runtime = ServerCore.findRuntime((String)runtimeId);
                }
            }
            RuntimeClasspathContainer container = new RuntimeClasspathContainer(containerPath, delegate, runtime);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }
    }

    public String getDescription(IPath containerPath, IJavaProject project) {
        return Messages.classpathContainerDescription;
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        if (containerPath.segmentCount() > 0 && containerPath.segment(0).equals("org.eclipse.jst.server.core.container")) {
            RuntimeClasspathProviderWrapper delegate = null;
            IRuntime runtime = null;
            if (containerPath.segmentCount() > 2) {
                delegate = JavaServerPlugin.findRuntimeClasspathProvider(containerPath.segment(1));
                String runtimeId = containerPath.segment(2);
                if (runtimeId != null) {
                    runtime = ServerCore.findRuntime((String)runtimeId);
                }
                delegate.requestClasspathContainerUpdate(runtime, containerSuggestion.getClasspathEntries());
            }
        }
    }

    public Object getComparisonID(IPath containerPath, IJavaProject project) {
        if (containerPath == null) {
            return null;
        }
        return containerPath.toPortableString();
    }
}

