/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.cheatsheets;

import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetView;

public final class OpenCheatSheetAction
extends Action {
    private String id;
    private String name;
    private URL url;

    public OpenCheatSheetAction(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.id = id;
    }

    public OpenCheatSheetAction(String id, String name, URL url) {
        if (id == null || name == null || url == null) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.name = name;
        this.url = url;
    }

    public void run() {
        IWorkbench workbench = CheatSheetPlugin.getPlugin().getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        CheatSheetView view = (CheatSheetView)page.findView("org.eclipse.ui.cheatsheets.views.CheatSheetView");
        if (view != null) {
            if (this.url == null) {
                view.setInput(this.id);
            } else {
                view.setInput(this.id, this.name, this.url);
            }
            page.bringToTop((IWorkbenchPart)view);
        } else {
            try {
                view = (CheatSheetView)page.showView("org.eclipse.ui.cheatsheets.views.CheatSheetView");
                page.activate((IWorkbenchPart)view);
                if (this.url == null) {
                    view.setInput(this.id);
                } else {
                    view.setInput(this.id, this.name, this.url);
                }
            }
            catch (PartInitException pie) {
                String message = Messages.LAUNCH_SHEET_ERROR;
                Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)pie);
                CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                ErrorDialog.openError((Shell)window.getShell(), (String)Messages.CHEAT_SHEET_ERROR_OPENING, null, (IStatus)pie.getStatus());
                return;
            }
        }
    }
}

