/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.callhierarchy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.jdt.internal.corext.callhierarchy.CalleeMethodWrapper;
import org.eclipse.jdt.internal.corext.callhierarchy.CallerMethodWrapper;
import org.eclipse.jdt.internal.corext.callhierarchy.Implementors;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodCall;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.jface.preference.IPreferenceStore;

public class CallHierarchy {
    private static final String PREF_USE_IMPLEMENTORS = "PREF_USE_IMPLEMENTORS";
    private static final String PREF_USE_FILTERS = "PREF_USE_FILTERS";
    private static final String PREF_FILTERS_LIST = "PREF_FILTERS_LIST";
    private static final String DEFAULT_IGNORE_FILTERS = "java.*,javax.*";
    private static CallHierarchy fgInstance;
    private IJavaSearchScope fSearchScope;
    private StringMatcher[] fFilters;

    public static CallHierarchy getDefault() {
        if (fgInstance == null) {
            fgInstance = new CallHierarchy();
        }
        return fgInstance;
    }

    public boolean isSearchUsingImplementorsEnabled() {
        IPreferenceStore settings = JavaPlugin.getDefault().getPreferenceStore();
        return settings.getBoolean(PREF_USE_IMPLEMENTORS);
    }

    public void setSearchUsingImplementorsEnabled(boolean enabled) {
        IPreferenceStore settings = JavaPlugin.getDefault().getPreferenceStore();
        settings.setValue(PREF_USE_IMPLEMENTORS, enabled);
    }

    public Collection getImplementingMethods(IMethod method) {
        IJavaElement[] result;
        if (this.isSearchUsingImplementorsEnabled() && (result = Implementors.getInstance().searchForImplementors(new IJavaElement[]{method}, (IProgressMonitor)new NullProgressMonitor())) != null && result.length > 0) {
            return Arrays.asList(result);
        }
        return new ArrayList(0);
    }

    public Collection getInterfaceMethods(IMethod method) {
        IJavaElement[] result;
        if (this.isSearchUsingImplementorsEnabled() && (result = Implementors.getInstance().searchForInterfaces(new IJavaElement[]{method}, (IProgressMonitor)new NullProgressMonitor())) != null && result.length > 0) {
            return Arrays.asList(result);
        }
        return new ArrayList(0);
    }

    public MethodWrapper getCallerRoot(IMethod method) {
        return new CallerMethodWrapper(null, new MethodCall((IMember)method));
    }

    public MethodWrapper getCalleeRoot(IMethod method) {
        return new CalleeMethodWrapper(null, new MethodCall((IMember)method));
    }

    public static CallLocation getCallLocation(Object element) {
        CallLocation callLocation = null;
        if (element instanceof MethodWrapper) {
            MethodWrapper methodWrapper = (MethodWrapper)((Object)element);
            MethodCall methodCall = methodWrapper.getMethodCall();
            if (methodCall != null) {
                callLocation = methodCall.getFirstCallLocation();
            }
        } else if (element instanceof CallLocation) {
            callLocation = (CallLocation)element;
        }
        return callLocation;
    }

    public IJavaSearchScope getSearchScope() {
        if (this.fSearchScope == null) {
            this.fSearchScope = SearchEngine.createWorkspaceScope();
        }
        return this.fSearchScope;
    }

    public void setSearchScope(IJavaSearchScope searchScope) {
        this.fSearchScope = searchScope;
    }

    public boolean isIgnored(String fullyQualifiedName) {
        if (this.getIgnoreFilters() != null && this.getIgnoreFilters().length > 0) {
            int i = 0;
            while (i < this.getIgnoreFilters().length) {
                String fullyQualifiedName1 = fullyQualifiedName;
                if (this.getIgnoreFilters()[i].match(fullyQualifiedName1)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isFilterEnabled() {
        IPreferenceStore settings = JavaPlugin.getDefault().getPreferenceStore();
        return settings.getBoolean(PREF_USE_FILTERS);
    }

    public void setFilterEnabled(boolean filterEnabled) {
        IPreferenceStore settings = JavaPlugin.getDefault().getPreferenceStore();
        settings.setValue(PREF_USE_FILTERS, filterEnabled);
    }

    public String getFilters() {
        IPreferenceStore settings = JavaPlugin.getDefault().getPreferenceStore();
        return settings.getString(PREF_FILTERS_LIST);
    }

    public void setFilters(String filters) {
        this.fFilters = null;
        IPreferenceStore settings = JavaPlugin.getDefault().getPreferenceStore();
        settings.setValue(PREF_FILTERS_LIST, filters);
    }

    private StringMatcher[] getIgnoreFilters() {
        if (this.fFilters == null) {
            String filterString = null;
            if (this.isFilterEnabled() && (filterString = this.getFilters()) == null) {
                filterString = DEFAULT_IGNORE_FILTERS;
            }
            this.fFilters = filterString != null ? CallHierarchy.parseList(filterString) : null;
        }
        return this.fFilters;
    }

    private static StringMatcher[] parseList(String listString) {
        ArrayList<StringMatcher> list = new ArrayList<StringMatcher>(10);
        StringTokenizer tokenizer = new StringTokenizer(listString, ",");
        while (tokenizer.hasMoreTokens()) {
            String textFilter = tokenizer.nextToken().trim();
            list.add(new StringMatcher(textFilter, false, false));
        }
        return list.toArray(new StringMatcher[list.size()]);
    }

    static CompilationUnit getCompilationUnitNode(IMember member, boolean resolveBindings) {
        if (member.isBinary()) {
            IClassFile classFile = member.getClassFile();
            try {
                if (classFile != null && classFile.exists() && classFile.getSource() != null) {
                    ASTParser parser = ASTParser.newParser((int)3);
                    parser.setSource(classFile);
                    parser.setResolveBindings(resolveBindings);
                    return (CompilationUnit)parser.createAST(null);
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        } else {
            ICompilationUnit icu = member.getCompilationUnit();
            if (icu != null && icu.exists()) {
                ASTParser parser = ASTParser.newParser((int)3);
                parser.setSource(icu);
                parser.setResolveBindings(resolveBindings);
                return (CompilationUnit)parser.createAST(null);
            }
        }
        return null;
    }
}

