/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.callhierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.jdt.internal.corext.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodCall;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodReferencesSearchRequestor;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.JavaPlugin;

class CallerMethodWrapper
extends MethodWrapper {
    public CallerMethodWrapper(MethodWrapper parent, MethodCall methodCall) {
        super(parent, methodCall);
    }

    protected IJavaSearchScope getSearchScope() {
        return CallHierarchy.getDefault().getSearchScope();
    }

    protected String getTaskName() {
        return CallHierarchyMessages.CallerMethodWrapper_taskname;
    }

    protected MethodWrapper createMethodWrapper(MethodCall methodCall) {
        return new CallerMethodWrapper(this, methodCall);
    }

    protected Map findChildren(IProgressMonitor progressMonitor) {
        try {
            MethodReferencesSearchRequestor searchRequestor = new MethodReferencesSearchRequestor();
            SearchEngine searchEngine = new SearchEngine();
            SubProgressMonitor monitor = new SubProgressMonitor(progressMonitor, 95, 2);
            IJavaSearchScope defaultSearchScope = this.getSearchScope();
            boolean isWorkspaceScope = SearchEngine.createWorkspaceScope().equals(defaultSearchScope);
            Iterator iter = this.getMembers().iterator();
            while (iter.hasNext()) {
                this.checkCanceled(progressMonitor);
                IMember member = (IMember)iter.next();
                SearchPattern pattern = SearchPattern.createPattern((IJavaElement)member, (int)2, (int)24);
                IJavaSearchScope searchScope = isWorkspaceScope ? this.getAccurateSearchScope(defaultSearchScope, member) : defaultSearchScope;
                searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, searchScope, (SearchRequestor)searchRequestor, (IProgressMonitor)monitor);
            }
            return searchRequestor.getCallers();
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            return new HashMap(0);
        }
    }

    private IJavaSearchScope getAccurateSearchScope(IJavaSearchScope defaultSearchScope, IMember member) throws JavaModelException {
        if (!JdtFlags.isPrivate(member)) {
            return defaultSearchScope;
        }
        if (member.getCompilationUnit() != null) {
            return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{member.getCompilationUnit()});
        }
        if (member.getClassFile() != null) {
            return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{member.getAncestor(4)});
        }
        return defaultSearchScope;
    }

    private Collection getMembers() {
        ArrayList<IMember> result = new ArrayList<IMember>();
        result.add(this.getMember());
        return result;
    }
}

