/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackager;

import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.jdt.ui.jarpackager.IManifestProvider;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.util.Assert;

public class ManifestProvider
implements IManifestProvider {
    private static final String SEALED_VALUE = "true";
    private static final String UNSEALED_VALUE = "false";

    public Manifest create(JarPackageData jarPackage) throws CoreException {
        Assert.isNotNull((Object)jarPackage);
        if (jarPackage.isManifestGenerated()) {
            return this.createGeneratedManifest(jarPackage);
        }
        try {
            return this.createSuppliedManifest(jarPackage);
        }
        catch (IOException ex) {
            throw JarPackagerUtil.createCoreException(ex.getLocalizedMessage(), ex);
        }
    }

    public Manifest createDefault(String manifestVersion) {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, manifestVersion);
        return manifest;
    }

    protected void putAdditionalEntries(Manifest manifest, JarPackageData jarPackage) {
    }

    private Manifest createGeneratedManifest(JarPackageData jarPackage) {
        Manifest manifest = new Manifest();
        this.putVersion(manifest, jarPackage);
        this.putSealing(manifest, jarPackage);
        this.putMainClass(manifest, jarPackage);
        this.putAdditionalEntries(manifest, jarPackage);
        return manifest;
    }

    private void putVersion(Manifest manifest, JarPackageData jarPackage) {
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, jarPackage.getManifestVersion());
    }

    private void putSealing(Manifest manifest, JarPackageData jarPackage) {
        block4: {
            block3: {
                if (!jarPackage.isJarSealed()) break block3;
                manifest.getMainAttributes().put(Attributes.Name.SEALED, SEALED_VALUE);
                IPackageFragment[] packages = jarPackage.getPackagesToUnseal();
                if (packages == null) break block4;
                int i = 0;
                while (i < packages.length) {
                    Attributes attributes = new Attributes();
                    attributes.put(Attributes.Name.SEALED, UNSEALED_VALUE);
                    manifest.getEntries().put(this.getInManifestFormat(packages[i]), attributes);
                    ++i;
                }
                break block4;
            }
            IPackageFragment[] packages = jarPackage.getPackagesToSeal();
            if (packages != null) {
                int i = 0;
                while (i < packages.length) {
                    Attributes attributes = new Attributes();
                    attributes.put(Attributes.Name.SEALED, SEALED_VALUE);
                    manifest.getEntries().put(this.getInManifestFormat(packages[i]), attributes);
                    ++i;
                }
            }
        }
    }

    private void putMainClass(Manifest manifest, JarPackageData jarPackage) {
        if (jarPackage.getManifestMainClass() != null && jarPackage.getManifestMainClass().getFullyQualifiedName().length() > 0) {
            manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, jarPackage.getManifestMainClass().getFullyQualifiedName());
        }
    }

    private String getInManifestFormat(IPackageFragment packageFragment) {
        String name = packageFragment.getElementName();
        return String.valueOf(name.replace('.', '/')) + '/';
    }

    /*
     * Exception decompiling
     */
    private Manifest createSuppliedManifest(JarPackageData jarPackage) throws CoreException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 43->46)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

