/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.ClassPathDetector;
import org.eclipse.jdt.internal.ui.wizards.JavaProjectWizardFirstPage;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class JavaProjectWizardSecondPage
extends JavaCapabilityConfigurationPage {
    private static final String FILENAME_PROJECT = ".project";
    private static final String FILENAME_CLASSPATH = ".classpath";
    private final JavaProjectWizardFirstPage fFirstPage;
    private URI fCurrProjectLocation;
    private IProject fCurrProject;
    private boolean fKeepContent;
    private File fDotProjectBackup;
    private File fDotClasspathBackup;
    private Boolean fIsAutobuild;

    public JavaProjectWizardSecondPage(JavaProjectWizardFirstPage mainPage) {
        this.fFirstPage = mainPage;
        this.fCurrProjectLocation = null;
        this.fCurrProject = null;
        this.fKeepContent = false;
        this.fDotProjectBackup = null;
        this.fDotClasspathBackup = null;
        this.fIsAutobuild = null;
    }

    protected boolean useNewSourcePage() {
        return true;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.changeToNewProject();
        } else {
            this.removeProject();
        }
        super.setVisible(visible);
    }

    private void changeToNewProject() {
        this.fKeepContent = this.fFirstPage.getDetect();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        if (JavaProjectWizardSecondPage.this.fIsAutobuild == null) {
                            JavaProjectWizardSecondPage.this.fIsAutobuild = CoreUtility.enableAutoBuild(false);
                        }
                        JavaProjectWizardSecondPage.this.updateProject(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(op));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.JavaProjectWizardSecondPage_error_title;
            String message = NewWizardMessages.JavaProjectWizardSecondPage_error_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void updateProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        this.fCurrProject = this.fFirstPage.getProjectHandle();
        this.fCurrProjectLocation = this.getProjectLocationURI();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.JavaProjectWizardSecondPage_operation_initialize, 7);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            URI realLocation = this.fCurrProjectLocation;
            if (this.fCurrProjectLocation == null) {
                try {
                    URI rootLocation = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
                    realLocation = new URI(rootLocation.getScheme(), null, Path.fromPortableString((String)rootLocation.getPath()).append(this.fCurrProject.getName()).toString(), null);
                }
                catch (URISyntaxException uRISyntaxException) {
                    Assert.isTrue((boolean)false, (String)"Can't happen");
                }
            }
            this.rememberExistingFiles(realLocation);
            JavaProjectWizardSecondPage.createProject(this.fCurrProject, this.fCurrProjectLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            IClasspathEntry[] entries = null;
            IPath outputLocation = null;
            if (this.fFirstPage.getDetect()) {
                if (!this.fCurrProject.getFile(FILENAME_CLASSPATH).exists()) {
                    ClassPathDetector detector = new ClassPathDetector(this.fCurrProject, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    entries = detector.getClasspath();
                    outputLocation = detector.getOutputLocation();
                } else {
                    monitor.worked(2);
                }
            } else if (this.fFirstPage.isSrcBin()) {
                IFolder folder;
                IPreferenceStore store = PreferenceConstants.getPreferenceStore();
                Path srcPath = new Path(store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName"));
                Path binPath = new Path(store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName"));
                if (srcPath.segmentCount() > 0) {
                    folder = this.fCurrProject.getFolder((IPath)srcPath);
                    CoreUtility.createFolder(folder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                if (binPath.segmentCount() > 0 && !binPath.equals((Object)srcPath)) {
                    folder = this.fCurrProject.getFolder((IPath)binPath);
                    CoreUtility.createFolder(folder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                IPath projectPath = this.fCurrProject.getFullPath();
                ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
                cpEntries.add(JavaCore.newSourceEntry((IPath)projectPath.append((IPath)srcPath)));
                cpEntries.addAll(Arrays.asList(this.getDefaultClasspathEntry()));
                entries = cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
                outputLocation = projectPath.append((IPath)binPath);
            } else {
                IPath projectPath = this.fCurrProject.getFullPath();
                ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
                cpEntries.add(JavaCore.newSourceEntry((IPath)projectPath));
                cpEntries.addAll(Arrays.asList(this.getDefaultClasspathEntry()));
                entries = cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
                outputLocation = projectPath;
                monitor.worked(2);
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.init(JavaCore.create((IProject)this.fCurrProject), outputLocation, entries, false);
            this.configureJavaProject((IProgressMonitor)new SubProgressMonitor(monitor, 3));
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var10_15 = null;
        }
        monitor.done();
    }

    private URI getProjectLocationURI() throws CoreException {
        if (this.fFirstPage.isInWorkspace()) {
            return null;
        }
        return URIUtil.toURI((IPath)this.fFirstPage.getLocationPath());
    }

    private IClasspathEntry[] getDefaultClasspathEntry() {
        IClasspathEntry[] defaultJRELibrary = PreferenceConstants.getDefaultJRELibrary();
        String compliance = this.fFirstPage.getCompilerCompliance();
        Path jreContainerPath = new Path(JavaRuntime.JRE_CONTAINER);
        if (compliance == null || defaultJRELibrary.length > 1 || !jreContainerPath.isPrefixOf(defaultJRELibrary[0].getPath())) {
            return defaultJRELibrary;
        }
        IVMInstall inst = this.fFirstPage.getJVM();
        if (inst != null) {
            IPath newPath = jreContainerPath.append(inst.getVMInstallType().getId()).append(inst.getName());
            return new IClasspathEntry[]{JavaCore.newContainerEntry((IPath)newPath)};
        }
        return defaultJRELibrary;
    }

    private void rememberExistingFiles(URI projectLocation) throws CoreException {
        this.fDotProjectBackup = null;
        this.fDotClasspathBackup = null;
        IFileStore file = EFS.getStore((URI)projectLocation);
        if (file.fetchInfo().exists()) {
            IFileStore classpathFile;
            IFileStore projectFile = file.getChild(FILENAME_PROJECT);
            if (projectFile.fetchInfo().exists()) {
                this.fDotProjectBackup = this.createBackup(projectFile, "project-desc");
            }
            if ((classpathFile = file.getChild(FILENAME_CLASSPATH)).fetchInfo().exists()) {
                this.fDotClasspathBackup = this.createBackup(classpathFile, "classpath-desc");
            }
        }
    }

    private void restoreExistingFiles(URI projectLocation, IProgressMonitor monitor) throws CoreException {
        int ticks = ((this.fDotProjectBackup != null ? 1 : 0) + (this.fDotClasspathBackup != null ? 1 : 0)) * 2;
        monitor.beginTask("", ticks);
        try {
            if (this.fDotProjectBackup != null) {
                IFileStore projectFile = EFS.getStore((URI)projectLocation).getChild(FILENAME_PROJECT);
                projectFile.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.copyFile(this.fDotProjectBackup, projectFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 4, NewWizardMessages.JavaProjectWizardSecondPage_problem_restore_project, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        try {
            if (this.fDotClasspathBackup != null) {
                IFileStore classpathFile = EFS.getStore((URI)projectLocation).getChild(FILENAME_CLASSPATH);
                classpathFile.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.copyFile(this.fDotClasspathBackup, classpathFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 4, NewWizardMessages.JavaProjectWizardSecondPage_problem_restore_classpath, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private File createBackup(IFileStore source, String name) throws CoreException {
        try {
            File bak = File.createTempFile("eclipse-" + name, ".bak");
            this.copyFile(source, bak);
            return bak;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.jdt.ui", 4, Messages.format(NewWizardMessages.JavaProjectWizardSecondPage_problem_backup, name), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void copyFile(IFileStore source, File target) throws IOException, CoreException {
        InputStream is = source.openInputStream(0, null);
        FileOutputStream os = new FileOutputStream(target);
        this.copyFile(is, os);
    }

    private void copyFile(File source, IFileStore target, IProgressMonitor monitor) throws IOException, CoreException {
        FileInputStream is = new FileInputStream(source);
        OutputStream os = target.openOutputStream(0, monitor);
        this.copyFile(is, os);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void copyFile(InputStream is, OutputStream os) throws IOException {
        try {
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                is.close();
                Object var7_11 = null;
            }
            catch (Throwable throwable2) {
                Object var7_10 = null;
                os.close();
                throw throwable2;
            }
            os.close();
            throw throwable;
        }
        try {}
        catch (Throwable throwable) {
            Object var7_12 = null;
            os.close();
            throw throwable;
        }
        is.close();
        Object var7_13 = null;
        os.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performFinish(IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            String compliance;
            monitor.beginTask(NewWizardMessages.JavaProjectWizardSecondPage_operation_create, 3);
            if (this.fCurrProject == null) {
                this.updateProject((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            this.configureJavaProject((IProgressMonitor)new SubProgressMonitor(monitor, 2));
            if (!this.fKeepContent && (compliance = this.fFirstPage.getCompilerCompliance()) != null) {
                IJavaProject project = JavaCore.create((IProject)this.fCurrProject);
                Map options = project.getOptions(false);
                JavaModelUtil.setCompilanceOptions(options, compliance);
                project.setOptions(options);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            this.fCurrProject = null;
            if (this.fIsAutobuild == null) throw throwable;
            CoreUtility.enableAutoBuild(this.fIsAutobuild);
            this.fIsAutobuild = null;
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
        this.fCurrProject = null;
        if (this.fIsAutobuild == null) return;
        CoreUtility.enableAutoBuild(this.fIsAutobuild);
        this.fIsAutobuild = null;
    }

    private void removeProject() {
        if (this.fCurrProject == null || !this.fCurrProject.exists()) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                JavaProjectWizardSecondPage.this.doRemoveProject(monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(op));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.JavaProjectWizardSecondPage_error_remove_title;
            String message = NewWizardMessages.JavaProjectWizardSecondPage_error_remove_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void doRemoveProject(IProgressMonitor monitor) throws InvocationTargetException {
        boolean noProgressMonitor;
        boolean bl = noProgressMonitor = this.fCurrProjectLocation == null;
        if (monitor == null || noProgressMonitor) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewWizardMessages.JavaProjectWizardSecondPage_operation_remove, 3);
        try {
            try {
                try {
                    URI projLoc = this.fCurrProject.getLocationURI();
                    boolean removeContent = !this.fKeepContent && this.fCurrProject.isSynchronized(2);
                    this.fCurrProject.delete(removeContent, false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    this.restoreExistingFiles(projLoc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    CoreUtility.enableAutoBuild(this.fIsAutobuild);
                    this.fIsAutobuild = null;
                    throw throwable;
                }
                {
                    Object var5_8 = null;
                    CoreUtility.enableAutoBuild(this.fIsAutobuild);
                    this.fIsAutobuild = null;
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            monitor.done();
            this.fCurrProject = null;
            this.fKeepContent = false;
            throw throwable;
        }
        {
            Object var7_11 = null;
        }
        monitor.done();
        this.fCurrProject = null;
        this.fKeepContent = false;
    }

    public void performCancel() {
        this.removeProject();
    }
}

