/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.dialogs.PathVariableSelectionDialog;

public class LinkFolderDialog
extends StatusDialog {
    private FolderNameField fFolderNameField;
    private LinkFields fDependenciesGroup;
    private IContainer fContainer;
    private IFolder fCreatedFolder;
    private boolean fCreateLink;
    private String fName;
    private String fTarget;

    public LinkFolderDialog(Shell parentShell, IContainer container) {
        this(parentShell, container, true);
    }

    public LinkFolderDialog(Shell parentShell, IContainer container, boolean createLink) {
        super(parentShell);
        this.fContainer = container;
        this.fCreateLink = createLink;
        this.setTitle(NewWizardMessages.LinkFolderDialog_title);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setStatusLineAboveButtons(true);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    public void setName(String name) {
        if (this.fFolderNameField != null) {
            this.fFolderNameField.setText(name);
        }
        this.fName = name;
    }

    public void setLinkTarget(String target) {
        if (this.fDependenciesGroup != null) {
            this.fDependenciesGroup.setLinkTarget(target);
        }
        this.fTarget = target;
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        int numOfColumns = 3;
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout(numOfColumns, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = this.convertWidthInCharsToPixels(80);
        composite.setLayoutData((Object)gridData);
        Label label = new Label(composite, 0);
        label.setFont(composite.getFont());
        label.setText(Messages.format(NewWizardMessages.LinkFolderDialog_createIn, this.fContainer.getFullPath().makeRelative().toString()));
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, numOfColumns, 1));
        this.fDependenciesGroup = new LinkFields(composite, numOfColumns);
        if (this.fTarget != null) {
            this.fDependenciesGroup.setLinkTarget(this.fTarget);
        }
        this.fFolderNameField = new FolderNameField(composite, numOfColumns);
        if (this.fName != null) {
            this.fFolderNameField.setText(this.fName);
        }
        Validator validator = new Validator();
        this.fDependenciesGroup.addObserver(validator);
        this.fFolderNameField.addObserver(validator);
        return composite;
    }

    private IFolder createFolderHandle(String folderName) {
        IWorkspaceRoot workspaceRoot = this.fContainer.getWorkspace().getRoot();
        IPath folderPath = this.fContainer.getFullPath().append(folderName);
        IFolder folderHandle = workspaceRoot.getFolder(folderPath);
        return folderHandle;
    }

    private IFolder createNewFolder(String folderName, String linkTargetName) {
        final IFolder folderHandle = this.createFolderHandle(folderName);
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    try {
                        monitor.beginTask(NewWizardMessages.NewFolderDialog_progress, 2000);
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        folderHandle.createLink(Path.fromOSString((String)LinkFolderDialog.this.fDependenciesGroup.getLinkTarget()), 16, monitor);
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException exception) {
            if (exception.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getShell(), (String)NewWizardMessages.NewFolderDialog_errorTitle, null, (IStatus)((CoreException)exception.getTargetException()).getStatus());
            } else {
                JavaPlugin.log(new Exception(Messages.format("Exception in {0}.createNewFolder(): {1}", new Object[]{((Object)((Object)this)).getClass().getName(), exception.getTargetException()})));
                MessageDialog.openError((Shell)this.getShell(), (String)NewWizardMessages.NewFolderDialog_errorTitle, (String)Messages.format(NewWizardMessages.NewFolderDialog_internalError, new Object[]{exception.getTargetException().getMessage()}));
            }
            return null;
        }
        return folderHandle;
    }

    protected void updateStatus(IStatus status) {
        super.updateStatus(status);
    }

    protected void okPressed() {
        if (this.fCreateLink) {
            String linkTarget = this.fDependenciesGroup.getLinkTarget();
            linkTarget = linkTarget.length() == 0 ? null : linkTarget;
            this.fCreatedFolder = this.createNewFolder(this.fFolderNameField.getText(), linkTarget);
        } else {
            this.fCreatedFolder = this.createFolderHandle(this.fFolderNameField.getText());
        }
        super.okPressed();
    }

    public IFolder getCreatedFolder() {
        return this.fCreatedFolder;
    }

    public IPath getLinkTarget() {
        return Path.fromOSString((String)this.fDependenciesGroup.getLinkTarget());
    }

    private final class FolderNameField
    extends Observable
    implements IDialogFieldListener {
        private StringDialogField fNameDialogField;

        public FolderNameField(Composite parent, int numOfColumns) {
            this.createControls(parent, numOfColumns);
        }

        private void createControls(Composite parent, int numColumns) {
            this.fNameDialogField = new StringDialogField();
            this.fNameDialogField.setLabelText(NewWizardMessages.LinkFolderDialog_folderNameGroup_label);
            this.fNameDialogField.doFillIntoGrid(parent, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.fNameDialogField.getTextControl(null));
            LayoutUtil.setHorizontalSpan((Control)this.fNameDialogField.getLabelControl(null), numColumns);
            DialogField.createEmptySpace(parent, numColumns - 1);
            this.fNameDialogField.setDialogFieldListener(this);
        }

        public StringDialogField getNameDialogField() {
            return this.fNameDialogField;
        }

        public void setText(String text) {
            this.fNameDialogField.setText(text);
            this.fNameDialogField.setFocus();
        }

        public String getText() {
            return this.fNameDialogField.getText();
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public void dialogFieldChanged(DialogField field) {
            this.fireEvent();
        }
    }

    private final class LinkFields
    extends Observable
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private StringButtonDialogField fLinkLocation;
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.jdt.ui.last.external.project";

        public LinkFields(Composite parent, int numColumns) {
            this.createControls(parent, numColumns);
        }

        private void createControls(Composite parent, int numColumns) {
            this.fLinkLocation = new StringButtonDialogField(this);
            this.fLinkLocation.setLabelText(NewWizardMessages.LinkFolderDialog_dependenciesGroup_locationLabel_desc);
            this.fLinkLocation.setButtonLabel(NewWizardMessages.LinkFolderDialog_dependenciesGroup_browseButton_desc);
            this.fLinkLocation.setDialogFieldListener(this);
            SelectionButtonDialogField variables = new SelectionButtonDialogField(8);
            variables.setLabelText(NewWizardMessages.LinkFolderDialog_dependenciesGroup_variables_desc);
            variables.setDialogFieldListener(new IDialogFieldListener(this){
                final /* synthetic */ LinkFields this$1;
                {
                    this.this$1 = linkFields;
                }

                public void dialogFieldChanged(DialogField field) {
                    LinkFields.access$0(this.this$1);
                }
            });
            this.fLinkLocation.doFillIntoGrid(parent, numColumns);
            LayoutUtil.setHorizontalSpan((Control)this.fLinkLocation.getLabelControl(null), numColumns);
            LayoutUtil.setHorizontalGrabbing((Control)this.fLinkLocation.getTextControl(null));
            variables.doFillIntoGrid(parent, 1);
        }

        public String getLinkTarget() {
            return this.fLinkLocation.getText();
        }

        public void setLinkTarget(String text) {
            this.fLinkLocation.setText(text);
        }

        public void changeControlPressed(DialogField field) {
            String selectedDirectory;
            File path;
            String prevLocation;
            DirectoryDialog dialog = new DirectoryDialog(LinkFolderDialog.this.getShell());
            dialog.setMessage(NewWizardMessages.JavaProjectWizardFirstPage_directory_message);
            String directoryName = this.getLinkTarget().trim();
            if (directoryName.length() == 0 && (prevLocation = JavaPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LAST_EXTERNAL_LOC)) != null) {
                directoryName = prevLocation;
            }
            if (directoryName.length() > 0 && (path = new File(directoryName)).exists()) {
                dialog.setFilterPath(directoryName);
            }
            if ((selectedDirectory = dialog.open()) != null) {
                this.fLinkLocation.setText(selectedDirectory);
                if (LinkFolderDialog.this.fName == null) {
                    LinkFolderDialog.this.fFolderNameField.setText(selectedDirectory.substring(selectedDirectory.lastIndexOf(File.separatorChar) + 1));
                }
                JavaPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, selectedDirectory);
            }
        }

        private void handleVariablesButtonPressed() {
            String[] variableNames;
            int variableTypes = 2;
            PathVariableSelectionDialog dialog = new PathVariableSelectionDialog(LinkFolderDialog.this.getShell(), variableTypes);
            if (dialog.open() == 0 && (variableNames = (String[])dialog.getResult()) != null && variableNames.length == 1) {
                this.fLinkLocation.setText(variableNames[0]);
                if (LinkFolderDialog.this.fName == null) {
                    LinkFolderDialog.this.fFolderNameField.setText(variableNames[0]);
                }
            }
        }

        public void dialogFieldChanged(DialogField field) {
            this.fireEvent();
        }

        private void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        static /* synthetic */ void access$0(LinkFields linkFields) {
            linkFields.handleVariablesButtonPressed();
        }
    }

    private final class Validator
    implements Observer {
        private Validator() {
        }

        public void update(Observable o, Object arg) {
            String name = LinkFolderDialog.this.fFolderNameField.getText();
            IStatus nameStatus = this.validateFolderName(name);
            if (nameStatus.matches(4)) {
                LinkFolderDialog.this.updateStatus(nameStatus);
            } else {
                IStatus dependencyStatus = this.validateLinkLocation(name);
                LinkFolderDialog.this.updateStatus(StatusUtil.getMoreSevere(nameStatus, dependencyStatus));
            }
        }

        private IStatus validateLinkLocation(String name) {
            IWorkspace workspace = JavaPlugin.getWorkspace();
            IPath path = Path.fromOSString((String)LinkFolderDialog.this.fDependenciesGroup.getLinkTarget());
            IStatus locationStatus = workspace.validateLinkLocation((IResource)LinkFolderDialog.this.fContainer.getFolder((IPath)new Path(name)), path);
            if (locationStatus.matches(4)) {
                return locationStatus;
            }
            String resolvedLinkTarget = this.resolveVariable();
            path = new Path(resolvedLinkTarget);
            File linkTargetFile = new Path(resolvedLinkTarget).toFile();
            if (linkTargetFile.exists()) {
                IStatus fileTypeStatus = this.validateFileType(linkTargetFile);
                if (!fileTypeStatus.isOK()) {
                    return fileTypeStatus;
                }
            } else if (locationStatus.isOK()) {
                return new StatusInfo(4, NewWizardMessages.NewFolderDialog_linkTargetNonExistent);
            }
            if (locationStatus.isOK()) {
                return new StatusInfo();
            }
            return new StatusInfo(locationStatus.getSeverity(), locationStatus.getMessage());
        }

        private IStatus validateFileType(File linkTargetFile) {
            if (!linkTargetFile.isDirectory()) {
                return new StatusInfo(4, NewWizardMessages.NewFolderDialog_linkTargetNotFolder);
            }
            return new StatusInfo();
        }

        private String resolveVariable() {
            IPathVariableManager pathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
            IPath path = Path.fromOSString((String)LinkFolderDialog.this.fDependenciesGroup.getLinkTarget());
            IPath resolvedPath = pathVariableManager.resolvePath(path);
            return resolvedPath.toOSString();
        }

        private IStatus validateFolderName(String name) {
            if (name.length() == 0) {
                return new StatusInfo(4, NewWizardMessages.NewFolderDialog_folderNameEmpty);
            }
            IStatus nameStatus = LinkFolderDialog.this.fContainer.getWorkspace().validateName(name, 2);
            if (!nameStatus.matches(4)) {
                return nameStatus;
            }
            Path path = new Path(name);
            if (LinkFolderDialog.this.fContainer.findMember((IPath)path) != null) {
                return new StatusInfo(4, Messages.format(NewWizardMessages.NewFolderDialog_folderNameEmpty_alreadyExists, name));
            }
            return nameStatus;
        }
    }
}

