/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.vtp.framework.media.binding.BindingGrammarTranslation;

public class BindingGrammarEntry {
    public static final String DEFAULT_NAME = "Untitled Entry";
    private String name;
    private Map translations = new LinkedHashMap();

    public BindingGrammarEntry(String name) {
        this.name = name == null || name.length() == 0 ? DEFAULT_NAME : name;
    }

    public BindingGrammarEntry(String name, BindingGrammarTranslation[] translations) {
        this(name);
        if (translations != null) {
            int i = 0;
            while (i < translations.length) {
                this.addTranslation(translations[i]);
                ++i;
            }
        }
    }

    public BindingGrammarEntry(String name, Collection translations) {
        this(name, translations == null ? null : translations.toArray(new BindingGrammarTranslation[translations.size()]));
    }

    public String getName() {
        return this.name;
    }

    public BindingGrammarTranslation getTranslation(Locale locale) {
        return (BindingGrammarTranslation)this.translations.get(locale);
    }

    public boolean addTranslation(BindingGrammarTranslation translation) {
        if (translation == null || this.translations.containsKey(translation.getLocale())) {
            return false;
        }
        this.translations.put(translation.getLocale(), translation);
        return true;
    }

    public boolean removeTranslation(BindingGrammarTranslation translation) {
        if (translation == null || !this.translations.containsValue(translation)) {
            return false;
        }
        this.translations.remove(translation.getLocale());
        return true;
    }

    public Set getTranslationLocales() {
        return new LinkedHashSet(this.translations.keySet());
    }

    public Collection getTranslations() {
        return new ArrayList(this.translations.values());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BindingGrammarEntry other = (BindingGrammarEntry)obj;
        return this.name.equals(other.name) && this.translations.equals(other.translations);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.name.hashCode() ^ this.translations.hashCode();
    }

    public String toString() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1) + "(name='" + this.name + "',translations=" + this.translations.keySet() + ')';
    }
}

