/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.binding;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.vtp.framework.media.grammars.Grammar;

public class BindingGrammarTranslation {
    private Locale locale = Locale.getDefault();
    private final List content = new ArrayList();

    public BindingGrammarTranslation(Locale locale) {
        this.locale = locale == null ? Locale.getDefault() : locale;
    }

    public BindingGrammarTranslation(Locale locale, List content) {
        this(locale, content == null ? null : content.toArray(new Grammar[content.size()]));
    }

    public BindingGrammarTranslation(Locale locale, Grammar[] content) {
        this(locale);
        if (content != null) {
            int i = 0;
            while (i < content.length) {
                this.add(content[i]);
                ++i;
            }
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean add(Grammar grammar) {
        if (grammar == null) {
            return false;
        }
        return this.content.add(grammar);
    }

    public boolean insert(int index, Grammar grammar) {
        if (grammar == null) {
            return false;
        }
        this.content.add(index, grammar);
        return true;
    }

    public Grammar get(int index) {
        return (Grammar)this.content.get(index);
    }

    public List getAll() {
        return new ArrayList(this.content);
    }

    public int size() {
        return this.content.size();
    }

    public void moveUp(int index) {
        this.content.add(index - 1, this.content.remove(index));
    }

    public void moveDown(int index) {
        this.content.add(index + 1, this.content.remove(index));
    }

    public Grammar remove(int index) {
        return (Grammar)this.content.remove(index);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BindingGrammarTranslation le = (BindingGrammarTranslation)obj;
        return this.locale.equals(le.locale) && this.content.equals(le.content);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.locale.hashCode() ^ this.content.hashCode();
    }

    public String toString() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1) + "(locale='" + this.locale + "',content=" + this.content + ")";
    }
}

