/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.vtp.framework.media.binding.BindingDialog;

public class BindingGroup {
    public static final String DEFAULT_NAME = "";
    private String name;
    private Map dialogs = new LinkedHashMap();

    public BindingGroup(String name) {
        this.name = name == null || name.length() == 0 ? DEFAULT_NAME : name;
    }

    public BindingGroup(String name, BindingDialog[] dialogs) {
        this(name);
        if (dialogs != null) {
            int i = 0;
            while (i < dialogs.length) {
                this.addDialog(dialogs[i]);
                ++i;
            }
        }
    }

    public BindingGroup(String name, Collection dialogs) {
        this(name, dialogs == null ? null : dialogs.toArray(new BindingDialog[dialogs.size()]));
    }

    public String getName() {
        return this.name;
    }

    public BindingDialog getDialog(String name) {
        return (BindingDialog)this.dialogs.get(name);
    }

    public boolean addDialog(BindingDialog dialog) {
        if (dialog == null || this.dialogs.containsKey(dialog.getName())) {
            return false;
        }
        this.dialogs.put(dialog.getName(), dialog);
        return true;
    }

    public boolean removeDialog(BindingDialog dialog) {
        if (dialog == null || !this.dialogs.containsValue(dialog)) {
            return false;
        }
        this.dialogs.remove(dialog.getName());
        return true;
    }

    public Set getDialogNames() {
        return new LinkedHashSet(this.dialogs.keySet());
    }

    public Collection getDialogs() {
        return new ArrayList(this.dialogs.values());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BindingGroup other = (BindingGroup)obj;
        return this.name.equals(other.name) && this.dialogs.equals(other.dialogs);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.name.hashCode() ^ this.dialogs.hashCode();
    }

    public String toString() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1) + "(name='" + this.name + "',dialogs=" + this.dialogs.values() + ')';
    }
}

