/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.files;

import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import org.eclipse.vtp.framework.media.files.MediaContainer;
import org.eclipse.vtp.framework.media.files.MediaContainerSupport;
import org.eclipse.vtp.framework.media.files.MediaObject;

public class MediaDirectory
extends MediaObject
implements MediaContainer {
    private final MediaContainerSupport container = new MediaContainerSupport();

    public MediaDirectory(String name) {
        super(name);
    }

    public MediaDirectory(String name, MediaObject[] contents) {
        super(name);
        if (contents != null) {
            int i = 0;
            while (i < contents.length) {
                this.add(contents[i]);
                ++i;
            }
        }
    }

    public MediaDirectory(String name, Collection contents) {
        this(name, contents == null ? null : contents.toArray(new MediaObject[contents.size()]));
    }

    public MediaDirectory(String name, Locale locale) {
        super(name, locale);
    }

    public MediaDirectory(String name, Locale locale, MediaObject[] contents) {
        super(name, locale);
        if (contents != null) {
            int i = 0;
            while (i < contents.length) {
                this.add(contents[i]);
                ++i;
            }
        }
    }

    public MediaDirectory(String name, Locale locale, Collection contents) {
        this(name, locale, contents == null ? null : contents.toArray(new MediaObject[contents.size()]));
    }

    public boolean add(MediaObject object) {
        return this.container.add(object);
    }

    public MediaObject get(String name) {
        return this.container.get(name);
    }

    public MediaObject find(String path) {
        return this.container.find(path);
    }

    public Set getNames() {
        return this.container.getNames();
    }

    public Collection getAll() {
        return this.container.getAll();
    }

    public Set getDirectoryNames() {
        return this.container.getDirectoryNames();
    }

    public Collection getDirectories() {
        return this.container.getDirectories();
    }

    public Set getFileNames() {
        return this.container.getFileNames();
    }

    public Collection getFiles() {
        return this.container.getFiles();
    }

    public boolean remove(MediaObject object) {
        return this.container.remove(object);
    }

    public boolean isDirectory() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MediaDirectory md = (MediaDirectory)obj;
        return this.getName().equals(md.getName()) && (this.getLocale() == null && md.getLocale() == null || this.getLocale() != null && this.getLocale().equals(md.getLocale())) && this.container.equals(md.container);
    }

    public int hashCode() {
        int hashCode = this.getName().hashCode();
        if (this.getLocale() != null) {
            hashCode ^= this.getLocale().hashCode();
        }
        return hashCode ^ this.container.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1)).append("(name='").append(this.getName()).append("',");
        if (this.getLocale() != null) {
            buf.append("locale=").append(this.getLocale()).append(',').toString();
        }
        return buf.append("contents=").append(this.getNames()).append(")").toString();
    }
}

