/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.language;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import org.eclipse.vtp.framework.media.language.Translator;
import org.eclipse.vtp.framework.media.language.TranslatorOutput;

public class DefaultTranslator
implements Translator {
    public void translateDate(Date date, Locale locale, TranslatorOutput out) {
        out.text(DateFormat.getDateInstance(1, locale).format(date));
    }

    public void translateTime(Date time, boolean showTimeZone, Locale locale, TranslatorOutput out) {
        out.text(DateFormat.getTimeInstance(showTimeZone ? 1 : 2, locale).format(time));
    }

    public void translateDateTime(Date datetime, boolean showTimeZone, Locale locale, TranslatorOutput out) {
        this.translateDate(datetime, locale, out);
        this.translateTime(datetime, showTimeZone, locale, out);
    }

    public void translateDigits(String digits, Locale locale, TranslatorOutput out) {
        int i = 0;
        while (i < digits.length()) {
            this.translateNumber(Integer.parseInt(String.valueOf(digits.charAt(i))), locale, out);
            ++i;
        }
    }

    public void translateMoney(BigDecimal money, Currency currency, Locale locale, TranslatorOutput out) {
        out.text(money.toString());
        out.text(currency.getCurrencyCode());
    }

    public void translateNumber(int number, Locale locale, TranslatorOutput out) {
        if (number < 0) {
            out.text("negative");
        }
        out.text(String.valueOf(Math.abs(number)));
    }

    public void translateOrdinal(int ordinal, Locale locale, TranslatorOutput out) {
        String prefix = "";
        if (ordinal < 0) {
            prefix = "negative ";
        }
        ordinal = Math.abs(ordinal);
        String suffix = null;
        int hundredRemainder = ordinal % 100;
        int tenRemainder = ordinal % 10;
        if (hundredRemainder - tenRemainder == 10) {
            tenRemainder = 4;
        }
        switch (tenRemainder) {
            case 1: {
                suffix = "st";
                break;
            }
            case 2: {
                suffix = "nd";
                break;
            }
            case 3: {
                suffix = "rd";
                break;
            }
            default: {
                suffix = "th";
            }
        }
        out.text(String.valueOf(prefix) + ordinal + suffix);
    }

    public void translateLetter(char letter, Locale locale, TranslatorOutput out) {
        out.text(" ");
        out.text(String.valueOf(letter).toLowerCase(locale));
        out.text(" ");
    }
}

