/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.persona;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.vtp.framework.media.persona.PersonaGrammarEntry;

public class PersonaGrammarGroup {
    public static final String DEFAULT_NAME = "Untitled Group";
    private String name;
    private Map entries = new LinkedHashMap();

    public PersonaGrammarGroup(String name) {
        this.name = name == null || name.length() == 0 ? DEFAULT_NAME : name;
    }

    public PersonaGrammarGroup(String name, PersonaGrammarEntry[] entries) {
        this(name);
        if (entries != null) {
            int i = 0;
            while (i < entries.length) {
                this.addEntry(entries[i]);
                ++i;
            }
        }
    }

    public PersonaGrammarGroup(String name, Collection entries) {
        this(name, entries == null ? null : entries.toArray(new PersonaGrammarEntry[entries.size()]));
    }

    public String getName() {
        return this.name;
    }

    public PersonaGrammarEntry getEntry(String name) {
        return (PersonaGrammarEntry)this.entries.get(name);
    }

    public boolean addEntry(PersonaGrammarEntry entry) {
        if (entry == null || this.entries.containsKey(entry.getName())) {
            return false;
        }
        this.entries.put(entry.getName(), entry);
        return true;
    }

    public boolean removeEntry(PersonaGrammarEntry entry) {
        if (entry == null || !this.entries.containsValue(entry)) {
            return false;
        }
        this.entries.remove(entry.getName());
        return true;
    }

    public Set getEntryNames() {
        return new LinkedHashSet(this.entries.keySet());
    }

    public Collection getEntries() {
        return new ArrayList(this.entries.values());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PersonaGrammarGroup other = (PersonaGrammarGroup)obj;
        return this.name.equals(other.name) && this.entries.equals(other.entries);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.name.hashCode() ^ this.entries.hashCode();
    }

    public String toString() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1) + "(name='" + this.name + "',entries=" + this.entries.keySet() + ')';
    }
}

