/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.persona;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.vtp.framework.media.persona.PersonaPromptGroup;

public class PersonaPrompts {
    private Map groups = new LinkedHashMap();

    public PersonaPrompts() {
    }

    public PersonaPrompts(PersonaPromptGroup[] groups) {
        if (groups != null) {
            int i = 0;
            while (i < groups.length) {
                this.addGroup(groups[i]);
                ++i;
            }
        }
    }

    public PersonaPrompts(Collection groups) {
        this(groups == null ? null : groups.toArray(new PersonaPromptGroup[groups.size()]));
    }

    public PersonaPromptGroup getGroup(String name) {
        return (PersonaPromptGroup)this.groups.get(name);
    }

    public boolean addGroup(PersonaPromptGroup group) {
        if (group == null || this.groups.containsKey(group.getName())) {
            return false;
        }
        this.groups.put(group.getName(), group);
        return true;
    }

    public boolean removeGroup(PersonaPromptGroup group) {
        if (group == null || !this.groups.containsValue(group)) {
            return false;
        }
        this.groups.remove(group.getName());
        return true;
    }

    public Set getGroupNames() {
        return new LinkedHashSet(this.groups.keySet());
    }

    public Collection getGroups() {
        return new ArrayList(this.groups.values());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.groups.equals(((PersonaPrompts)obj).groups);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.groups.hashCode();
    }

    public String toString() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1) + "(groups=" + this.groups.keySet() + ')';
    }
}

