/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.prompts;

import java.util.Date;
import org.eclipse.vtp.framework.media.prompts.Prompt;

public class DateTimePrompt
extends Prompt {
    private Date value = new Date();
    private boolean showingTimeZone = false;

    public DateTimePrompt() {
    }

    public DateTimePrompt(Date value) {
        this.setValue(value);
    }

    public DateTimePrompt(Date value, boolean showingTimeZone) {
        this.setValue(value);
        this.setShowingTimeZone(showingTimeZone);
    }

    public Date getValue() {
        return this.value;
    }

    public void setValue(Date value) {
        this.value = value == null ? new Date() : value;
    }

    public boolean isShowingTimeZone() {
        return this.showingTimeZone;
    }

    public void setShowingTimeZone(boolean showingTimeZone) {
        this.showingTimeZone = showingTimeZone;
    }

    public Object accept(Prompt.Visitor visitor) {
        return visitor.dateTimePrompt(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DateTimePrompt other = (DateTimePrompt)obj;
        return this.value.equals(other.value) && this.showingTimeZone == other.showingTimeZone;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.value.hashCode() ^ (this.showingTimeZone ? -1 : 0);
    }

    public String toString() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1) + "(value=" + this.value + ",showingTimeZone=" + this.showingTimeZone + ')';
    }
}

