/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.prompts;

import java.math.BigDecimal;
import java.util.Currency;
import java.util.Locale;
import org.eclipse.vtp.framework.media.prompts.Prompt;

public class MoneyPrompt
extends Prompt {
    private BigDecimal value = new BigDecimal("0");
    private Currency currency = Currency.getInstance(Locale.getDefault());

    public MoneyPrompt() {
    }

    public MoneyPrompt(BigDecimal value) {
        this.setValue(value);
    }

    public MoneyPrompt(Currency currency) {
        this.setCurrency(currency);
    }

    public MoneyPrompt(BigDecimal value, Currency currency) {
        this.setValue(value);
        this.setCurrency(currency);
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value == null ? new BigDecimal(0.0) : value;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency == null ? Currency.getInstance(Locale.getDefault()) : currency;
    }

    public Object accept(Prompt.Visitor visitor) {
        return visitor.moneyPrompt(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MoneyPrompt other = (MoneyPrompt)obj;
        return this.value.equals(other.value) && this.currency.equals(other.currency);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.value.hashCode() ^ this.currency.hashCode();
    }

    public String toString() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1) + "(currency=" + this.currency.getSymbol() + ',' + this.value + ')';
    }
}

