/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.vtp.framework.media.util.BindingIndex;
import org.eclipse.vtp.framework.media.util.CustomBindingIndex;
import org.eclipse.vtp.framework.media.util.DefaultBindingIndex;
import org.eclipse.vtp.framework.media.util.DialogAggregate;

public class BindingAggragate {
    private DefaultBindingIndex defaultBrand = null;
    private final Map customBrands = new HashMap();
    private final Map dialogAggregatesByBrandByDialogByGroupByModule = new HashMap();

    public BindingAggragate(DefaultBindingIndex defaultBrand) {
        this.defaultBrand = defaultBrand;
    }

    public BindingAggragate(DefaultBindingIndex defaultBrand, Map customBrands) {
        this(defaultBrand);
        this.customBrands.putAll(customBrands);
    }

    public DefaultBindingIndex getDefaultBrand() {
        return this.defaultBrand;
    }

    public Set getCustomBrands() {
        return Collections.unmodifiableSet(this.customBrands.keySet());
    }

    public CustomBindingIndex getCustomBrandBindings(String brand) {
        return (CustomBindingIndex)this.customBrands.get(brand);
    }

    public void setDefaultBrand(DefaultBindingIndex defaultBrand) {
        this.defaultBrand = defaultBrand;
    }

    public void customBrandAdded(String brand, CustomBindingIndex binding) {
        this.customBrands.put(brand, binding);
    }

    public void customBrandRemoved(String brand) {
        this.customBrands.remove(brand);
        Iterator i = this.dialogAggregatesByBrandByDialogByGroupByModule.values().iterator();
        while (i.hasNext()) {
            Iterator j = ((Map)i.next()).values().iterator();
            while (j.hasNext()) {
                Iterator k = ((Map)j.next()).values().iterator();
                while (k.hasNext()) {
                    ((Map)k.next()).remove(brand);
                }
            }
        }
    }

    public Map getMessageDialogAggregates(String module, String group, String dialog) {
        return this.getDialogAggregates(module, group, dialog, 1);
    }

    public Map getFieldDialogAggregates(String module, String group, String dialog) {
        return this.getDialogAggregates(module, group, dialog, 2);
    }

    public Map getMenuDialogAggregates(String module, String group, String dialog) {
        return this.getDialogAggregates(module, group, dialog, 3);
    }

    public Map getDynamicMenuDialogAggregates(String module, String group, String dialog) {
        return this.getDialogAggregates(module, group, dialog, 4);
    }

    private Map getDialogAggregates(String module, String group, String dialog, int type) {
        HashMap<String, DialogAggregate> dialogAggregatesByBrand;
        HashMap<String, HashMap<String, DialogAggregate>> dialogAggregatesByBrandByDialog;
        HashMap dialogAggregatesByBrandByDialogByGroup = (HashMap)this.dialogAggregatesByBrandByDialogByGroupByModule.get(module);
        if (dialogAggregatesByBrandByDialogByGroup == null) {
            dialogAggregatesByBrandByDialogByGroup = new HashMap();
            this.dialogAggregatesByBrandByDialogByGroupByModule.put(module, dialogAggregatesByBrandByDialogByGroup);
        }
        if ((dialogAggregatesByBrandByDialog = (HashMap<String, HashMap<String, DialogAggregate>>)dialogAggregatesByBrandByDialogByGroup.get(group)) == null) {
            dialogAggregatesByBrandByDialog = new HashMap<String, HashMap<String, DialogAggregate>>();
            dialogAggregatesByBrandByDialogByGroup.put(group, dialogAggregatesByBrandByDialog);
        }
        if ((dialogAggregatesByBrand = (HashMap<String, DialogAggregate>)dialogAggregatesByBrandByDialog.get(dialog)) == null) {
            dialogAggregatesByBrand = new HashMap<String, DialogAggregate>();
            dialogAggregatesByBrandByDialog.put(dialog, dialogAggregatesByBrand);
        }
        if (!dialogAggregatesByBrand.containsKey("")) {
            dialogAggregatesByBrand.put("", new DialogAggregate(this.defaultBrand, module, group, dialog, type));
        }
        Iterator i = this.customBrands.keySet().iterator();
        while (i.hasNext()) {
            String brand = (String)i.next();
            if (dialogAggregatesByBrand.containsKey(brand)) continue;
            dialogAggregatesByBrand.put(brand, new DialogAggregate((BindingIndex)this.customBrands.get(brand), module, group, dialog, type));
        }
        return Collections.unmodifiableMap(dialogAggregatesByBrand);
    }
}

