/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.vtp.framework.media.files.MediaFile;
import org.eclipse.vtp.framework.media.files.MediaFiles;
import org.eclipse.vtp.framework.media.files.MediaObject;
import org.eclipse.vtp.framework.media.grammars.CharactersGrammar;
import org.eclipse.vtp.framework.media.grammars.FileGrammar;
import org.eclipse.vtp.framework.media.grammars.Grammar;
import org.eclipse.vtp.framework.media.grammars.ReferenceGrammar;
import org.eclipse.vtp.framework.media.grammars.TextGrammar;
import org.eclipse.vtp.framework.media.library.LibraryGrammarEntry;
import org.eclipse.vtp.framework.media.library.LibraryGrammarTranslation;
import org.eclipse.vtp.framework.media.library.LibraryPromptEntry;
import org.eclipse.vtp.framework.media.library.LibraryPromptTranslation;
import org.eclipse.vtp.framework.media.library.MediaLibrary;
import org.eclipse.vtp.framework.media.prompts.CharactersPrompt;
import org.eclipse.vtp.framework.media.prompts.DatePrompt;
import org.eclipse.vtp.framework.media.prompts.DateTimePrompt;
import org.eclipse.vtp.framework.media.prompts.DigitsPrompt;
import org.eclipse.vtp.framework.media.prompts.FilePrompt;
import org.eclipse.vtp.framework.media.prompts.MoneyPrompt;
import org.eclipse.vtp.framework.media.prompts.NumberPrompt;
import org.eclipse.vtp.framework.media.prompts.OrdinalPrompt;
import org.eclipse.vtp.framework.media.prompts.Prompt;
import org.eclipse.vtp.framework.media.prompts.ReferencePrompt;
import org.eclipse.vtp.framework.media.prompts.TextPrompt;
import org.eclipse.vtp.framework.media.prompts.TimePrompt;
import org.eclipse.vtp.framework.media.prompts.VariablePrompt;
import org.eclipse.vtp.framework.media.util.GrammarSolutionCollector;
import org.eclipse.vtp.framework.media.util.GrammarSolutionOutput;
import org.eclipse.vtp.framework.media.util.PersonaIndex;
import org.eclipse.vtp.framework.media.util.PromptSolutionCollector;
import org.eclipse.vtp.framework.media.util.PromptSolutionOutput;

public abstract class BrandLibraryIndex {
    private MediaLibrary library = null;
    private MediaFiles files = null;
    private String filePrefix = "";

    protected BrandLibraryIndex() {
    }

    protected BrandLibraryIndex(MediaLibrary library, MediaFiles files, String filePrefix) {
        this.setLibrary(library);
        this.setFiles(files);
        this.setFilePrefix(filePrefix);
    }

    public void setLibrary(MediaLibrary library) {
        this.library = library;
    }

    public MediaLibrary getLibrary() {
        return this.library;
    }

    public void setFiles(MediaFiles files) {
        this.files = files;
    }

    public MediaFiles getFiles() {
        return this.files;
    }

    public void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix == null ? "" : filePrefix;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public Collection getPromptEntryNames() {
        return this.library.getPrompts().getEntryNames();
    }

    public LibraryPromptEntry getPromptEntry(String name) {
        return this.library.getPrompts().getEntry(name);
    }

    public Collection getGrammarEntryNames() {
        return this.library.getGrammars().getEntryNames();
    }

    public LibraryGrammarEntry getGrammarEntry(String name) {
        return this.library.getGrammars().getEntry(name);
    }

    public abstract Locale[] getLocales();

    public abstract Locale getDefaultLocale();

    public abstract PersonaIndex getPersonaIndex(Locale var1);

    public abstract Map indexAvailablePrompts(String var1, String var2);

    public abstract Map indexAvailableGrammars(String var1, String var2);

    public boolean hasAudioFile(String path) {
        return this.hasAudioFile(path, this.getDefaultLocale());
    }

    public boolean hasAudioFile(String path, Locale locale) {
        if (this.files != null) {
            if (this.filePrefix.length() > 0 && path.startsWith(this.filePrefix) && this.files.find(path.substring(this.filePrefix.length())) != null) {
                return true;
            }
            if (this.files.find(path) != null) {
                return true;
            }
        }
        if (this.getPersonaIndex(locale) != null) {
            return this.getPersonaIndex(locale).hasAudioFile(path);
        }
        return false;
    }

    public String getAlternateText(String filePath) {
        return this.getAlternateText(filePath, this.getDefaultLocale());
    }

    public String getAlternateText(String filePath, Locale locale) {
        PersonaIndex persona;
        if (this.files != null) {
            MediaObject obj = this.files.find(filePath);
            if (obj instanceof MediaFile) {
                return ((MediaFile)obj).getAlternateText();
            }
            if (filePath.startsWith(this.filePrefix) && (obj = this.files.find(filePath.substring(this.filePrefix.length()))) instanceof MediaFile) {
                return ((MediaFile)obj).getAlternateText();
            }
        }
        if ((persona = this.getPersonaIndex(locale)) != null) {
            return persona.getAlternateText(filePath);
        }
        return "";
    }

    public List solvePrompt(Prompt prompt) {
        PromptSolutionCollector collector = new PromptSolutionCollector();
        this.solvePrompt(prompt, collector);
        return collector.getResults();
    }

    public List solvePrompt(Prompt prompt, Locale locale) {
        PromptSolutionCollector collector = new PromptSolutionCollector();
        this.solvePrompt(prompt, collector, locale);
        return collector.getResults();
    }

    public boolean solvePrompt(Prompt prompt, PromptSolutionOutput output) {
        return this.solvePrompt(prompt, output, this.getDefaultLocale());
    }

    public boolean solvePrompt(Prompt prompt, PromptSolutionOutput output, Locale locale) {
        return prompt.accept(new PromptSolver(output, locale)) == Boolean.TRUE;
    }

    public List solveGrammar(Grammar grammar) {
        GrammarSolutionCollector collector = new GrammarSolutionCollector();
        this.solveGrammar(grammar, collector);
        return collector.getResults();
    }

    public List solveGrammar(Grammar grammar, Locale locale) {
        GrammarSolutionCollector collector = new GrammarSolutionCollector();
        this.solveGrammar(grammar, collector, locale);
        return collector.getResults();
    }

    public boolean solveGrammar(Grammar grammar, GrammarSolutionOutput output) {
        return this.solveGrammar(grammar, output, this.getDefaultLocale());
    }

    public boolean solveGrammar(Grammar grammar, GrammarSolutionOutput output, Locale locale) {
        return grammar.accept(new GrammarSolver(output, locale)) == Boolean.TRUE;
    }

    protected abstract boolean solveUnresolvedPrompt(ReferencePrompt var1, PromptSolutionOutput var2, Locale var3);

    protected abstract boolean solveUnresolvedGrammar(ReferenceGrammar var1, GrammarSolutionOutput var2, Locale var3);

    private class PromptSolver
    implements Prompt.Visitor {
        private PromptSolutionOutput output;
        private Locale locale;

        public PromptSolver(PromptSolutionOutput output, Locale locale) {
            this.locale = locale;
            this.output = output;
        }

        public Object charactersPrompt(CharactersPrompt charactersPrompt) {
            PersonaIndex persona = BrandLibraryIndex.this.getPersonaIndex(this.locale);
            if (persona != null && persona.solvePrompt(charactersPrompt, this.output)) {
                return Boolean.TRUE;
            }
            persona = BrandLibraryIndex.this.getPersonaIndex(BrandLibraryIndex.this.getDefaultLocale());
            if (persona != null && persona.solvePrompt(charactersPrompt, this.output)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Object datePrompt(DatePrompt datePrompt) {
            PersonaIndex persona = BrandLibraryIndex.this.getPersonaIndex(this.locale);
            if (persona != null && persona.solvePrompt(datePrompt, this.output)) {
                return Boolean.TRUE;
            }
            persona = BrandLibraryIndex.this.getPersonaIndex(BrandLibraryIndex.this.getDefaultLocale());
            if (persona != null && persona.solvePrompt(datePrompt, this.output)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Object dateTimePrompt(DateTimePrompt dateTimePrompt) {
            PersonaIndex persona = BrandLibraryIndex.this.getPersonaIndex(this.locale);
            if (persona != null && persona.solvePrompt(dateTimePrompt, this.output)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Object digitsPrompt(DigitsPrompt digitsPrompt) {
            PersonaIndex persona = BrandLibraryIndex.this.getPersonaIndex(this.locale);
            if (persona != null && persona.solvePrompt(digitsPrompt, this.output)) {
                return Boolean.TRUE;
            }
            persona = BrandLibraryIndex.this.getPersonaIndex(BrandLibraryIndex.this.getDefaultLocale());
            if (persona != null && persona.solvePrompt(digitsPrompt, this.output)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Object filePrompt(FilePrompt filePrompt) {
            this.output.writeFile(filePrompt.getPath().startsWith(BrandLibraryIndex.this.getFilePrefix()) ? filePrompt.getPath() : String.valueOf(BrandLibraryIndex.this.getFilePrefix()) + filePrompt.getPath());
            return Boolean.TRUE;
        }

        public Object moneyPrompt(MoneyPrompt moneyPrompt) {
            PersonaIndex persona = BrandLibraryIndex.this.getPersonaIndex(this.locale);
            if (persona != null && persona.solvePrompt(moneyPrompt, this.output)) {
                return Boolean.TRUE;
            }
            persona = BrandLibraryIndex.this.getPersonaIndex(BrandLibraryIndex.this.getDefaultLocale());
            if (persona != null && persona.solvePrompt(moneyPrompt, this.output)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Object numberPrompt(NumberPrompt numberPrompt) {
            PersonaIndex persona = BrandLibraryIndex.this.getPersonaIndex(this.locale);
            if (persona != null && persona.solvePrompt(numberPrompt, this.output)) {
                return Boolean.TRUE;
            }
            persona = BrandLibraryIndex.this.getPersonaIndex(BrandLibraryIndex.this.getDefaultLocale());
            if (persona != null && persona.solvePrompt(numberPrompt, this.output)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Object ordinalPrompt(OrdinalPrompt ordinalPrompt) {
            PersonaIndex persona = BrandLibraryIndex.this.getPersonaIndex(this.locale);
            if (persona != null && persona.solvePrompt(ordinalPrompt, this.output)) {
                return Boolean.TRUE;
            }
            persona = BrandLibraryIndex.this.getPersonaIndex(BrandLibraryIndex.this.getDefaultLocale());
            if (persona != null && persona.solvePrompt(ordinalPrompt, this.output)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Object referencePrompt(ReferencePrompt referencePrompt) {
            LibraryPromptEntry entry;
            if ((referencePrompt.getContainer().length() == 0 || "Local Prompts".equals(referencePrompt.getContainer())) && (entry = BrandLibraryIndex.this.library.getPrompts().getEntry(referencePrompt.getName())) != null) {
                LibraryPromptTranslation trans = entry.getTranslation(this.locale);
                if (trans == null || trans.getAll().isEmpty()) {
                    trans = entry.getTranslation(new Locale(this.locale.getLanguage(), this.locale.getCountry()));
                }
                if (trans == null || trans.getAll().isEmpty()) {
                    trans = entry.getTranslation(new Locale(this.locale.getLanguage()));
                }
                if (trans != null) {
                    boolean result = false;
                    Iterator i = trans.getAll().iterator();
                    while (i.hasNext()) {
                        result |= ((Prompt)i.next()).accept(this) == Boolean.TRUE;
                    }
                    if (result) {
                        return Boolean.TRUE;
                    }
                }
            }
            return BrandLibraryIndex.this.solveUnresolvedPrompt(referencePrompt, this.output, this.locale) ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object textPrompt(TextPrompt textPrompt) {
            this.output.writeText(textPrompt.getContent());
            return Boolean.TRUE;
        }

        public Object variablePrompt(VariablePrompt variablePrompt) {
            PersonaIndex persona = BrandLibraryIndex.this.getPersonaIndex(this.locale);
            if (persona != null && persona.solvePrompt(variablePrompt, this.output)) {
                return Boolean.TRUE;
            }
            persona = BrandLibraryIndex.this.getPersonaIndex(BrandLibraryIndex.this.getDefaultLocale());
            if (persona != null && persona.solvePrompt(variablePrompt, this.output)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Object timePrompt(TimePrompt timePrompt) {
            PersonaIndex persona = BrandLibraryIndex.this.getPersonaIndex(this.locale);
            if (persona != null && persona.solvePrompt(timePrompt, this.output)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    private class GrammarSolver
    implements Grammar.Visitor {
        private GrammarSolutionOutput output;
        private Locale locale;

        public GrammarSolver(GrammarSolutionOutput output, Locale locale) {
            this.locale = locale;
            this.output = output;
        }

        public Object charactersGrammar(CharactersGrammar charactersGrammar) {
            this.output.writeCharacters(charactersGrammar.getCharacters());
            return Boolean.TRUE;
        }

        public Object fileGrammar(FileGrammar fileGrammar) {
            this.output.writeFile(fileGrammar.getPath().startsWith(BrandLibraryIndex.this.getFilePrefix()) ? fileGrammar.getPath() : String.valueOf(BrandLibraryIndex.this.getFilePrefix()) + fileGrammar.getPath());
            return Boolean.TRUE;
        }

        public Object referenceGrammar(ReferenceGrammar referenceGrammar) {
            LibraryGrammarEntry entry;
            if ((referenceGrammar.getContainer().length() == 0 || "Local Grammars".equals(referenceGrammar.getContainer())) && (entry = BrandLibraryIndex.this.library.getGrammars().getEntry(referenceGrammar.getName())) != null) {
                LibraryGrammarTranslation trans = entry.getTranslation(this.locale);
                if (trans == null || trans.getAll().isEmpty()) {
                    trans = entry.getTranslation(new Locale(this.locale.getLanguage(), this.locale.getCountry()));
                }
                if (trans == null || trans.getAll().isEmpty()) {
                    trans = entry.getTranslation(new Locale(this.locale.getLanguage()));
                }
                if (trans != null) {
                    boolean result = false;
                    Iterator i = trans.getAll().iterator();
                    while (i.hasNext()) {
                        result |= ((Grammar)i.next()).accept(this) == Boolean.TRUE;
                    }
                    if (result) {
                        return Boolean.TRUE;
                    }
                }
            }
            return BrandLibraryIndex.this.solveUnresolvedGrammar(referenceGrammar, this.output, this.locale) ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object textGrammar(TextGrammar textGrammar) {
            this.output.writeText(textGrammar.getContent());
            return Boolean.TRUE;
        }
    }
}

