/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.util;

import java.math.BigDecimal;
import org.eclipse.vtp.framework.media.binding.BindingDialog;
import org.eclipse.vtp.framework.media.binding.BindingFieldDialog;
import org.eclipse.vtp.framework.media.binding.BindingGrammarEntry;
import org.eclipse.vtp.framework.media.binding.BindingGroup;
import org.eclipse.vtp.framework.media.binding.BindingInputDialog;
import org.eclipse.vtp.framework.media.binding.BindingMenuDialog;
import org.eclipse.vtp.framework.media.binding.BindingMessageDialog;
import org.eclipse.vtp.framework.media.binding.BindingModule;
import org.eclipse.vtp.framework.media.binding.BindingPromptEntry;
import org.eclipse.vtp.framework.media.util.BindingIndex;
import org.eclipse.vtp.framework.media.util.CustomBindingIndex;

public class DialogAggregate {
    public static final int TYPE_MESSAGE = 1;
    public static final int TYPE_FIELD = 2;
    public static final int TYPE_MENU = 3;
    public static final int TYPE_DYNAMIC_MENU = 4;
    private final BindingIndex binding;
    private final String module;
    private final String group;
    private final String dialog;
    private final int type;
    private BindingDialog instance = null;
    private BindingDialog defaultInstance = null;

    public DialogAggregate(BindingIndex binding, String module, String group, String dialog, int type) {
        this.binding = binding;
        this.module = module;
        this.group = group;
        this.dialog = dialog;
        this.type = type;
    }

    public BindingIndex getBinding() {
        return this.binding;
    }

    public BindingPromptEntry getCustomPrompt(String id) {
        BindingDialog defDialog;
        BindingPromptEntry prompt = this.getDialog().getCustomPrompt(id);
        if (prompt == null && (defDialog = this.getDefaultDialog()) != null) {
            prompt = defDialog.getCustomPrompt(id);
        }
        return prompt;
    }

    public void setCustomPrompt(String id, BindingPromptEntry entry) {
        this.getDialog().putCustomPrompt(id, entry);
    }

    public BindingGrammarEntry getCustomGrammar(String id) {
        BindingDialog defDialog;
        BindingGrammarEntry grammar = this.getDialog().getCustomGrammar(id);
        if (grammar == null && (defDialog = this.getDefaultDialog()) != null) {
            grammar = defDialog.getCustomGrammar(id);
        }
        return grammar;
    }

    public void setCustomGrammar(String id, BindingGrammarEntry entry) {
        this.getDialog().putCustomGrammar(id, entry);
    }

    public BindingPromptEntry getMessagePrompt() {
        switch (this.type) {
            case 1: {
                BindingDialog defDialog;
                BindingPromptEntry prompt = ((BindingMessageDialog)this.getDialog()).getMessagePrompt();
                if (prompt == null && (defDialog = this.getDefaultDialog()) != null) {
                    prompt = ((BindingMessageDialog)defDialog).getMessagePrompt();
                }
                return prompt;
            }
        }
        throw new IllegalStateException("Not a message dialog");
    }

    public void setMessagePrompt(BindingPromptEntry prompt) {
        switch (this.type) {
            case 1: {
                ((BindingMessageDialog)this.getDialog()).setMessagePrompt(prompt);
                break;
            }
            default: {
                throw new IllegalStateException("Not a message dialog");
            }
        }
    }

    public BindingPromptEntry getFieldPrompt() {
        switch (this.type) {
            case 2: {
                BindingDialog defDialog;
                BindingPromptEntry prompt = ((BindingFieldDialog)this.getDialog()).getFieldPrompt();
                if (prompt == null && (defDialog = this.getDefaultDialog()) != null) {
                    prompt = ((BindingFieldDialog)defDialog).getFieldPrompt();
                }
                return prompt;
            }
        }
        throw new IllegalStateException("Not a field dialog");
    }

    public void setFieldPrompt(BindingPromptEntry prompt) {
        switch (this.type) {
            case 2: {
                ((BindingFieldDialog)this.getDialog()).setFieldPrompt(prompt);
                break;
            }
            default: {
                throw new IllegalStateException("Not a field dialog");
            }
        }
    }

    public BindingGrammarEntry getFieldGrammar() {
        switch (this.type) {
            case 2: {
                BindingDialog defDialog;
                BindingGrammarEntry grammar = ((BindingFieldDialog)this.getDialog()).getFieldGrammar();
                if (grammar == null && (defDialog = this.getDefaultDialog()) != null) {
                    grammar = ((BindingFieldDialog)defDialog).getFieldGrammar();
                }
                return grammar;
            }
        }
        throw new IllegalStateException("Not a field dialog");
    }

    public void setFieldGrammar(BindingGrammarEntry grammar) {
        switch (this.type) {
            case 2: {
                ((BindingFieldDialog)this.getDialog()).setFieldGrammar(grammar);
                break;
            }
            default: {
                throw new IllegalStateException("Not a field dialog");
            }
        }
    }

    public BindingPromptEntry getMenuPrompt() {
        switch (this.type) {
            case 3: 
            case 4: {
                BindingDialog defDialog;
                BindingPromptEntry prompt = ((BindingMenuDialog)this.getDialog()).getMenuPrompt();
                if (prompt == null && (defDialog = this.getDefaultDialog()) != null) {
                    prompt = ((BindingMenuDialog)defDialog).getMenuPrompt();
                }
                return prompt;
            }
        }
        throw new IllegalStateException("Not a menu dialog");
    }

    public void setMenuPrompt(BindingPromptEntry prompt) {
        switch (this.type) {
            case 3: 
            case 4: {
                ((BindingMenuDialog)this.getDialog()).setMenuPrompt(prompt);
                break;
            }
            default: {
                throw new IllegalStateException("Not a menu dialog");
            }
        }
    }

    public BindingPromptEntry getMenuOptionPrompt(String id) {
        switch (this.type) {
            case 3: 
            case 4: {
                BindingDialog defDialog;
                BindingPromptEntry prompt = ((BindingMenuDialog)this.getDialog()).getOptionPrompt(id);
                if (prompt == null && (defDialog = this.getDefaultDialog()) != null) {
                    prompt = ((BindingMenuDialog)defDialog).getOptionPrompt(id);
                }
                return prompt;
            }
        }
        throw new IllegalStateException("Not a menu dialog");
    }

    public void setMenuOptionPrompt(String id, BindingPromptEntry prompt) {
        switch (this.type) {
            case 3: 
            case 4: {
                ((BindingMenuDialog)this.getDialog()).putOptionPrompt(id, prompt);
                break;
            }
            default: {
                throw new IllegalStateException("Not a menu dialog");
            }
        }
    }

    public BindingGrammarEntry getMenuOptionGrammar(String id) {
        switch (this.type) {
            case 3: 
            case 4: {
                BindingDialog defDialog;
                BindingGrammarEntry grammar = ((BindingMenuDialog)this.getDialog()).getOptionGrammar(id);
                if (grammar == null && (defDialog = this.getDefaultDialog()) != null) {
                    grammar = ((BindingMenuDialog)defDialog).getOptionGrammar(id);
                }
                return grammar;
            }
        }
        throw new IllegalStateException("Not a menu dialog");
    }

    public void setMenuOptionGrammar(String id, BindingGrammarEntry grammar) {
        switch (this.type) {
            case 3: 
            case 4: {
                ((BindingMenuDialog)this.getDialog()).putOptionGrammar(id, grammar);
                break;
            }
            default: {
                throw new IllegalStateException("Not a menu dialog");
            }
        }
    }

    public BindingPromptEntry getNoInputPrompt() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                BindingDialog defDialog;
                BindingPromptEntry noInputPrompt = ((BindingInputDialog)this.getDialog()).getNoInputPrompt();
                if (noInputPrompt == null && (defDialog = this.getDefaultDialog()) != null) {
                    noInputPrompt = ((BindingInputDialog)defDialog).getNoInputPrompt();
                }
                return noInputPrompt;
            }
        }
        throw new IllegalStateException("Not an input dialog");
    }

    public void setNoInputPrompt(BindingPromptEntry prompt) {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                ((BindingInputDialog)this.getDialog()).setNoInputPrompt(prompt);
                break;
            }
            default: {
                throw new IllegalStateException("Not an input dialog");
            }
        }
    }

    public BindingPromptEntry getNoMatchPrompt() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                BindingDialog defDialog;
                BindingPromptEntry noMatchPrompt = ((BindingInputDialog)this.getDialog()).getNoMatchPrompt();
                if (noMatchPrompt == null && (defDialog = this.getDefaultDialog()) != null) {
                    noMatchPrompt = ((BindingInputDialog)defDialog).getNoMatchPrompt();
                }
                return noMatchPrompt;
            }
        }
        throw new IllegalStateException("Not an input dialog");
    }

    public void setNoMatchPrompt(BindingPromptEntry prompt) {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                ((BindingInputDialog)this.getDialog()).setNoMatchPrompt(prompt);
                break;
            }
            default: {
                throw new IllegalStateException("Not an input dialog");
            }
        }
    }

    public BigDecimal getConfidenceLevel() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                BindingDialog defDialog;
                BigDecimal value = ((BindingInputDialog)this.getDialog()).getConfidenceLevel();
                if (value == null && (defDialog = this.getDefaultDialog()) != null) {
                    value = ((BindingInputDialog)defDialog).getConfidenceLevel();
                }
                return value;
            }
        }
        throw new IllegalStateException("Not an input dialog");
    }

    public BindingGrammarEntry getConfirmAcceptGrammar() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                BindingDialog defDialog;
                BindingGrammarEntry value = ((BindingInputDialog)this.getDialog()).getConfirmAcceptGrammar();
                if (value == null && (defDialog = this.getDefaultDialog()) != null) {
                    value = ((BindingInputDialog)defDialog).getConfirmAcceptGrammar();
                }
                return value;
            }
        }
        throw new IllegalStateException("Not an input dialog");
    }

    public BindingPromptEntry getConfirmAcceptPrompt() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                BindingDialog defDialog;
                BindingPromptEntry value = ((BindingInputDialog)this.getDialog()).getConfirmAcceptPrompt();
                if (value == null && (defDialog = this.getDefaultDialog()) != null) {
                    value = ((BindingInputDialog)defDialog).getConfirmAcceptPrompt();
                }
                return value;
            }
        }
        throw new IllegalStateException("Not an input dialog");
    }

    public int getConfirmMode() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                BindingDialog defDialog;
                int value = ((BindingInputDialog)this.getDialog()).getConfirmMode();
                if (value < 0 && (defDialog = this.getDefaultDialog()) != null) {
                    value = ((BindingInputDialog)defDialog).getConfirmMode();
                }
                return value;
            }
        }
        throw new IllegalStateException("Not an input dialog");
    }

    public BindingPromptEntry getConfirmPrompt() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                BindingDialog defDialog;
                BindingPromptEntry value = ((BindingInputDialog)this.getDialog()).getConfirmPrompt();
                if (value == null && (defDialog = this.getDefaultDialog()) != null) {
                    value = ((BindingInputDialog)defDialog).getConfirmPrompt();
                }
                return value;
            }
        }
        throw new IllegalStateException("Not an input dialog");
    }

    public BindingGrammarEntry getConfirmRejectGrammar() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                BindingDialog defDialog;
                BindingGrammarEntry value = ((BindingInputDialog)this.getDialog()).getConfirmRejectGrammar();
                if (value == null && (defDialog = this.getDefaultDialog()) != null) {
                    value = ((BindingInputDialog)defDialog).getConfirmRejectGrammar();
                }
                return value;
            }
        }
        throw new IllegalStateException("Not an input dialog");
    }

    public BindingPromptEntry getConfirmRejectPrompt() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                BindingDialog defDialog;
                BindingPromptEntry value = ((BindingInputDialog)this.getDialog()).getConfirmRejectPrompt();
                if (value == null && (defDialog = this.getDefaultDialog()) != null) {
                    value = ((BindingInputDialog)defDialog).getConfirmRejectPrompt();
                }
                return value;
            }
        }
        throw new IllegalStateException("Not an input dialog");
    }

    public long getIncompleteSpeechTimeout() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                BindingDialog defDialog;
                long value = ((BindingInputDialog)this.getDialog()).getIncompleteSpeechTimeout();
                if (value < 0L && (defDialog = this.getDefaultDialog()) != null) {
                    value = ((BindingInputDialog)defDialog).getIncompleteSpeechTimeout();
                }
                return value;
            }
        }
        throw new IllegalStateException("Not an input dialog");
    }

    public long getInitialInputTimeout() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                BindingDialog defDialog;
                long value = ((BindingInputDialog)this.getDialog()).getInitialInputTimeout();
                if (value < 0L && (defDialog = this.getDefaultDialog()) != null) {
                    value = ((BindingInputDialog)defDialog).getInitialInputTimeout();
                }
                return value;
            }
        }
        throw new IllegalStateException("Not an input dialog");
    }

    public int getInputMode() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                BindingDialog defDialog;
                int value = ((BindingInputDialog)this.getDialog()).getInputMode();
                if (value < 0 && (defDialog = this.getDefaultDialog()) != null) {
                    value = ((BindingInputDialog)defDialog).getInputMode();
                }
                return value;
            }
        }
        throw new IllegalStateException("Not an input dialog");
    }

    public long getInterDigitTimeout() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                BindingDialog defDialog;
                long value = ((BindingInputDialog)this.getDialog()).getInterDigitTimeout();
                if (value < 0L && (defDialog = this.getDefaultDialog()) != null) {
                    value = ((BindingInputDialog)defDialog).getInterDigitTimeout();
                }
                return value;
            }
        }
        throw new IllegalStateException("Not an input dialog");
    }

    public int getMaximumNBestResults() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                BindingDialog defDialog;
                int value = ((BindingInputDialog)this.getDialog()).getMaximumNBestResults();
                if (value < 0 && (defDialog = this.getDefaultDialog()) != null) {
                    value = ((BindingInputDialog)defDialog).getMaximumNBestResults();
                }
                return value;
            }
        }
        throw new IllegalStateException("Not an input dialog");
    }

    public int getMaximumSpeechLength() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                BindingDialog defDialog;
                int value = ((BindingInputDialog)this.getDialog()).getMaximumSpeechLength();
                if (value < 0 && (defDialog = this.getDefaultDialog()) != null) {
                    value = ((BindingInputDialog)defDialog).getMaximumSpeechLength();
                }
                return value;
            }
        }
        throw new IllegalStateException("Not an input dialog");
    }

    public BigDecimal getSensitivity() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                BindingDialog defDialog;
                BigDecimal value = ((BindingInputDialog)this.getDialog()).getSensitivity();
                if (value == null && (defDialog = this.getDefaultDialog()) != null) {
                    value = ((BindingInputDialog)defDialog).getSensitivity();
                }
                return value;
            }
        }
        throw new IllegalStateException("Not an input dialog");
    }

    public Boolean getBargeIn() {
        BindingDialog defDialog;
        Boolean value = this.getDialog().getBargeIn();
        if (value == null && (defDialog = this.getDefaultDialog()) != null) {
            value = defDialog.getBargeIn();
        }
        return value;
    }

    public long getSpeechCompletionTimeout() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                BindingDialog defDialog;
                long value = ((BindingInputDialog)this.getDialog()).getSpeechCompletionTimeout();
                if (value < 0L && (defDialog = this.getDefaultDialog()) != null) {
                    value = ((BindingInputDialog)defDialog).getSpeechCompletionTimeout();
                }
                return value;
            }
        }
        throw new IllegalStateException("Not an input dialog");
    }

    public BigDecimal getSpeedVsAccuracy() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                BindingDialog defDialog;
                BigDecimal value = ((BindingInputDialog)this.getDialog()).getSpeedVsAccuracy();
                if (value == null && (defDialog = this.getDefaultDialog()) != null) {
                    value = ((BindingInputDialog)defDialog).getSpeedVsAccuracy();
                }
                return value;
            }
        }
        throw new IllegalStateException("Not an input dialog");
    }

    public char getTerminationCharacter() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                BindingDialog defDialog;
                char value = ((BindingInputDialog)this.getDialog()).getTerminationCharacter();
                if (value == '\u0000' && (defDialog = this.getDefaultDialog()) != null) {
                    value = ((BindingInputDialog)defDialog).getTerminationCharacter();
                }
                return value;
            }
        }
        throw new IllegalStateException("Not an input dialog");
    }

    public long getTerminationTimeout() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                BindingDialog defDialog;
                long value = ((BindingInputDialog)this.getDialog()).getTerminationTimeout();
                if (value < 0L && (defDialog = this.getDefaultDialog()) != null) {
                    value = ((BindingInputDialog)defDialog).getTerminationTimeout();
                }
                return value;
            }
        }
        throw new IllegalStateException("Not an input dialog");
    }

    public void setConfidenceLevel(BigDecimal confidenceLevel) {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                ((BindingInputDialog)this.getDialog()).setConfidenceLevel(confidenceLevel);
                break;
            }
            default: {
                throw new IllegalStateException("Not an input dialog");
            }
        }
    }

    public void setConfirmAcceptGrammar(BindingGrammarEntry confirmAcceptGrammar) {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                ((BindingInputDialog)this.getDialog()).setConfirmAcceptGrammar(confirmAcceptGrammar);
                break;
            }
            default: {
                throw new IllegalStateException("Not an input dialog");
            }
        }
    }

    public void setConfirmAcceptPrompt(BindingPromptEntry confirmAcceptPrompt) {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                ((BindingInputDialog)this.getDialog()).setConfirmAcceptPrompt(confirmAcceptPrompt);
                break;
            }
            default: {
                throw new IllegalStateException("Not an input dialog");
            }
        }
    }

    public void setConfirmMode(int confirmMode) {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                ((BindingInputDialog)this.getDialog()).setConfirmMode(confirmMode);
                break;
            }
            default: {
                throw new IllegalStateException("Not an input dialog");
            }
        }
    }

    public void setConfirmPrompt(BindingPromptEntry confirmPrompt) {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                ((BindingInputDialog)this.getDialog()).setConfirmPrompt(confirmPrompt);
                break;
            }
            default: {
                throw new IllegalStateException("Not an input dialog");
            }
        }
    }

    public void setConfirmRejectGrammar(BindingGrammarEntry confirmRejectGrammar) {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                ((BindingInputDialog)this.getDialog()).setConfirmRejectGrammar(confirmRejectGrammar);
                break;
            }
            default: {
                throw new IllegalStateException("Not an input dialog");
            }
        }
    }

    public void setConfirmRejectPrompt(BindingPromptEntry confirmRejectPrompt) {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                ((BindingInputDialog)this.getDialog()).setConfirmRejectPrompt(confirmRejectPrompt);
                break;
            }
            default: {
                throw new IllegalStateException("Not an input dialog");
            }
        }
    }

    public void setIncompleteSpeechTimeout(long incompleteSpeechTimeout) {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                ((BindingInputDialog)this.getDialog()).setIncompleteSpeechTimeout(incompleteSpeechTimeout);
                break;
            }
            default: {
                throw new IllegalStateException("Not an input dialog");
            }
        }
    }

    public void setInitialInputTimeout(long initialInputTimeout) {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                ((BindingInputDialog)this.getDialog()).setInitialInputTimeout(initialInputTimeout);
                break;
            }
            default: {
                throw new IllegalStateException("Not an input dialog");
            }
        }
    }

    public void setInputMode(int inputMode) {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                ((BindingInputDialog)this.getDialog()).setInputMode(inputMode);
                break;
            }
            default: {
                throw new IllegalStateException("Not an input dialog");
            }
        }
    }

    public void setInterDigitTimeout(long interDigitTimeout) {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                ((BindingInputDialog)this.getDialog()).setInterDigitTimeout(interDigitTimeout);
                break;
            }
            default: {
                throw new IllegalStateException("Not an input dialog");
            }
        }
    }

    public void setMaximumNBestResults(int maximumNBestResults) {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                ((BindingInputDialog)this.getDialog()).setMaximumNBestResults(maximumNBestResults);
                break;
            }
            default: {
                throw new IllegalStateException("Not an input dialog");
            }
        }
    }

    public void setMaximumSpeechLength(int maximumSpeechLength) {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                ((BindingInputDialog)this.getDialog()).setMaximumSpeechLength(maximumSpeechLength);
                break;
            }
            default: {
                throw new IllegalStateException("Not an input dialog");
            }
        }
    }

    public void setSensitivity(BigDecimal sensitivity) {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                ((BindingInputDialog)this.getDialog()).setSensitivity(sensitivity);
                break;
            }
            default: {
                throw new IllegalStateException("Not an input dialog");
            }
        }
    }

    public void setSpeechCompletionTimeout(long speechCompletionTimeout) {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                ((BindingInputDialog)this.getDialog()).setSpeechCompletionTimeout(speechCompletionTimeout);
                break;
            }
            default: {
                throw new IllegalStateException("Not an input dialog");
            }
        }
    }

    public void setSpeedVsAccuracy(BigDecimal speedVsAccuracy) {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                ((BindingInputDialog)this.getDialog()).setSpeedVsAccuracy(speedVsAccuracy);
                break;
            }
            default: {
                throw new IllegalStateException("Not an input dialog");
            }
        }
    }

    public void setTerminationCharacter(char terminationCharacter) {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                ((BindingInputDialog)this.getDialog()).setTerminationCharacter(terminationCharacter);
                break;
            }
            default: {
                throw new IllegalStateException("Not an input dialog");
            }
        }
    }

    public void setTerminationTimeout(long terminationTimeout) {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                ((BindingInputDialog)this.getDialog()).setTerminationTimeout(terminationTimeout);
                break;
            }
            default: {
                throw new IllegalStateException("Not an input dialog");
            }
        }
    }

    public void setBargeIn(Boolean bargeIn) {
        this.getDialog().setBargeIn(bargeIn);
    }

    private BindingDialog getDialog() {
        if (this.instance == null) {
            BindingGroup grp;
            BindingModule mod = this.binding.getBinding().getModule(this.module);
            if (mod == null) {
                mod = new BindingModule(this.module);
                this.binding.getBinding().addModule(mod);
            }
            if ((grp = mod.getGroup(this.group)) == null) {
                grp = new BindingGroup(this.group);
                mod.addGroup(grp);
            }
            this.instance = grp.getDialog(this.dialog);
            if (this.instance == null) {
                switch (this.type) {
                    case 1: {
                        this.instance = new BindingMessageDialog(this.dialog);
                        break;
                    }
                    case 2: {
                        this.instance = new BindingFieldDialog(this.dialog);
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.instance = new BindingMenuDialog(this.dialog);
                    }
                }
                grp.addDialog(this.instance);
            }
        }
        return this.instance;
    }

    private BindingDialog getDefaultDialog() {
        if (this.defaultInstance == null && this.binding instanceof CustomBindingIndex) {
            BindingGroup grp;
            BindingModule mod = ((CustomBindingIndex)this.binding).getParentIndex().getBinding().getModule(this.module);
            if (mod == null) {
                mod = new BindingModule(this.module);
                ((CustomBindingIndex)this.binding).getParentIndex().getBinding().addModule(mod);
            }
            if ((grp = mod.getGroup(this.group)) == null) {
                grp = new BindingGroup(this.group);
                mod.addGroup(grp);
            }
            this.defaultInstance = grp.getDialog(this.dialog);
            if (this.defaultInstance == null) {
                switch (this.type) {
                    case 1: {
                        this.defaultInstance = new BindingMessageDialog(this.dialog);
                        break;
                    }
                    case 2: {
                        this.defaultInstance = new BindingFieldDialog(this.dialog);
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.defaultInstance = new BindingMenuDialog(this.dialog);
                    }
                }
                grp.addDialog(this.defaultInstance);
            }
        }
        return this.defaultInstance;
    }

    public int getType() {
        return this.type;
    }
}

