/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.xml;

import java.util.Iterator;
import org.eclipse.vtp.framework.media.files.MediaContainer;
import org.eclipse.vtp.framework.media.files.MediaDirectory;
import org.eclipse.vtp.framework.media.files.MediaFile;
import org.eclipse.vtp.framework.media.files.MediaFiles;
import org.eclipse.vtp.framework.media.files.MediaObject;
import org.eclipse.vtp.framework.media.xml.AbstractEncoder;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FilesEncoder
extends AbstractEncoder {
    private MediaFiles source = null;

    public FilesEncoder() {
    }

    public FilesEncoder(MediaFiles source) {
        this.source = source;
    }

    public void setSource(MediaFiles source) {
        this.source = source;
    }

    public void encode() throws SAXException {
        if (this.source == null) {
            return;
        }
        ContentHandler handler = this.getContentHandler();
        if (handler == null) {
            return;
        }
        AttributesImpl atts = new AttributesImpl();
        handler.startDocument();
        this.encodeStartNamespace("files", "http://eclipse.org/vtp/xsd/openVXML/media/files#1.0", atts);
        handler.startElement("http://eclipse.org/vtp/xsd/openVXML/media/files#1.0", "descriptor", "files:descriptor", atts);
        atts.clear();
        this.encodeContainer(this.source, atts);
        handler.endElement("http://eclipse.org/vtp/xsd/openVXML/media/files#1.0", "descriptor", "files:descriptor");
        this.encodeEndNamespace("files");
        handler.endDocument();
    }

    private void encodeContainer(MediaContainer container, AttributesImpl atts) throws SAXException {
        ContentHandler handler = this.getContentHandler();
        Iterator i = container.getAll().iterator();
        while (i.hasNext()) {
            MediaObject mo = (MediaObject)i.next();
            atts.addAttribute("", "name", "name", "CDATA", mo.getName());
            if (mo.getLocale() != null) {
                atts.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", "CDATA", this.encodeLocale(mo.getLocale()));
            }
            if (mo.isFile()) {
                MediaFile mf = (MediaFile)mo;
                handler.startElement("", "file", "file", atts);
                atts.clear();
                handler.characters(mf.getAlternateText().toCharArray(), 0, mf.getAlternateText().length());
                handler.endElement("", "file", "file");
                continue;
            }
            MediaDirectory md = (MediaDirectory)mo;
            handler.startElement("", "directory", "directory", atts);
            atts.clear();
            this.encodeContainer(md, atts);
            handler.endElement("", "directory", "directory");
        }
    }
}

