/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.xml;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.vtp.framework.media.library.LibraryGrammarEntry;
import org.eclipse.vtp.framework.media.library.LibraryGrammarTranslation;
import org.eclipse.vtp.framework.media.library.LibraryGrammars;
import org.eclipse.vtp.framework.media.library.LibraryPromptEntry;
import org.eclipse.vtp.framework.media.library.LibraryPromptTranslation;
import org.eclipse.vtp.framework.media.library.LibraryPrompts;
import org.eclipse.vtp.framework.media.library.MediaLibrary;
import org.eclipse.vtp.framework.media.xml.AbstractDecoder;
import org.eclipse.vtp.framework.media.xml.GrammarDecoder;
import org.eclipse.vtp.framework.media.xml.PromptDecoder;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class LibraryDecoder
extends AbstractDecoder {
    private static final Set ENTRY_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("characters", "date", "date-time", "digits", "file", "money", "number", "ordinal", "reference", "text", "time")));
    private final PromptDecoder promptDecoder = new PromptDecoder("library");
    private final GrammarDecoder grammarDecoder = new GrammarDecoder("library");
    private ContentHandler currentDecoder = null;
    private MediaLibrary result = null;

    public void startDocument() throws SAXException {
        this.result = null;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("http://eclipse.org/vtp/xsd/openVXML/media/library#1.0".equals(uri) && "descriptor".equals(localName) || "library:descriptor".equals(qName)) {
            this.push(new MediaLibrary());
        } else if ("".equals(uri)) {
            if ("prompts".equals(localName) || "prompts".equals(qName)) {
                this.push(new LibraryPrompts());
            } else if ("grammars".equals(localName) || "grammars".equals(qName)) {
                this.push(new LibraryGrammars());
            } else if ("entry".equals(localName) || "entry".equals(qName)) {
                this.push(this.peek() instanceof LibraryPrompts ? new LibraryPromptEntry(atts.getValue("name")) : new LibraryGrammarEntry(atts.getValue("name")));
            } else if ("translation".equals(localName) || "translation".equals(qName)) {
                this.push(this.peek() instanceof LibraryPromptEntry ? new LibraryPromptTranslation(this.decodeLocale(atts.getValue("xml:lang"))) : new LibraryGrammarTranslation(this.decodeLocale(atts.getValue("xml:lang"))));
            } else if (ENTRY_NAMES.contains(localName) || ENTRY_NAMES.contains(qName)) {
                this.currentDecoder = this.peek() instanceof LibraryPromptTranslation ? this.promptDecoder : this.grammarDecoder;
                this.currentDecoder.startElement(uri, localName, qName, atts);
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentDecoder == null) {
            super.characters(ch, start, length);
        } else {
            this.currentDecoder.characters(ch, start, length);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("http://eclipse.org/vtp/xsd/openVXML/media/library#1.0".equals(uri) && "descriptor".equals(localName) || "library:descriptor".equals(qName)) {
            this.result = (MediaLibrary)this.pop();
        } else if ("".equals(uri)) {
            if ("prompts".equals(localName) || "prompts".equals(qName)) {
                LibraryPrompts prompts = (LibraryPrompts)this.pop();
                ((MediaLibrary)this.peek()).setPrompts(prompts);
            } else if ("grammars".equals(localName) || "grammars".equals(qName)) {
                LibraryGrammars grammars = (LibraryGrammars)this.pop();
                ((MediaLibrary)this.peek()).setGrammars(grammars);
            } else if ("entry".equals(localName) || "entry".equals(qName)) {
                if (this.peek() instanceof LibraryPromptEntry) {
                    LibraryPromptEntry group = (LibraryPromptEntry)this.pop();
                    ((LibraryPrompts)this.peek()).addEntry(group);
                } else {
                    LibraryGrammarEntry group = (LibraryGrammarEntry)this.pop();
                    ((LibraryGrammars)this.peek()).addEntry(group);
                }
            } else if ("translation".equals(localName) || "translation".equals(qName)) {
                if (this.peek() instanceof LibraryPromptTranslation) {
                    LibraryPromptTranslation trans = (LibraryPromptTranslation)this.pop();
                    ((LibraryPromptEntry)this.peek()).addTranslation(trans);
                } else {
                    LibraryGrammarTranslation trans = (LibraryGrammarTranslation)this.pop();
                    ((LibraryGrammarEntry)this.peek()).addTranslation(trans);
                }
            } else if (ENTRY_NAMES.contains(localName) || ENTRY_NAMES.contains(qName)) {
                this.currentDecoder.endElement(uri, localName, qName);
                if (this.peek() instanceof LibraryPromptTranslation) {
                    ((LibraryPromptTranslation)this.peek()).add(this.promptDecoder.getResult());
                } else {
                    ((LibraryGrammarTranslation)this.peek()).add(this.grammarDecoder.getResult());
                }
                this.currentDecoder = null;
            }
        }
    }

    public MediaLibrary getResult() {
        return this.result;
    }
}

