/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media.xml;

import java.util.Iterator;
import org.eclipse.vtp.framework.media.grammars.Grammar;
import org.eclipse.vtp.framework.media.persona.MediaPersona;
import org.eclipse.vtp.framework.media.persona.PersonaGrammarEntry;
import org.eclipse.vtp.framework.media.persona.PersonaGrammarGroup;
import org.eclipse.vtp.framework.media.persona.PersonaPromptEntry;
import org.eclipse.vtp.framework.media.persona.PersonaPromptGroup;
import org.eclipse.vtp.framework.media.prompts.Prompt;
import org.eclipse.vtp.framework.media.xml.AbstractEncoder;
import org.eclipse.vtp.framework.media.xml.GrammarEncoder;
import org.eclipse.vtp.framework.media.xml.PromptEncoder;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PersonaEncoder
extends AbstractEncoder {
    private final PromptEncoder promptEncoder = new PromptEncoder("group");
    private final GrammarEncoder grammarEncoder = new GrammarEncoder("group");
    private MediaPersona source = null;

    public PersonaEncoder() {
    }

    public PersonaEncoder(MediaPersona source) {
        this.setSource(source);
    }

    public void setSource(MediaPersona source) {
        this.source = source;
    }

    public void encode() throws SAXException {
        Iterator k;
        Object entry;
        Iterator j;
        Object group;
        if (this.source == null) {
            return;
        }
        ContentHandler handler = this.getContentHandler();
        if (handler == null) {
            return;
        }
        this.promptEncoder.setContentHandler(handler);
        this.grammarEncoder.setContentHandler(handler);
        AttributesImpl atts = new AttributesImpl();
        handler.startDocument();
        this.encodeStartNamespace("persona", "http://eclipse.org/vtp/xsd/openVXML/media/persona#1.0", atts);
        atts.addAttribute("", "language", "language", "CDATA", this.source.getLanguage());
        handler.startElement("http://eclipse.org/vtp/xsd/openVXML/media/persona#1.0", "descriptor", "persona:descriptor", atts);
        atts.clear();
        handler.startElement("", "prompts", "prompts", atts);
        Iterator i = this.source.getPrompts().getGroups().iterator();
        while (i.hasNext()) {
            group = (PersonaPromptGroup)i.next();
            atts.addAttribute("", "name", "name", "CDATA", ((PersonaPromptGroup)group).getName());
            handler.startElement("", "group", "group", atts);
            atts.clear();
            j = ((PersonaPromptGroup)group).getEntries().iterator();
            while (j.hasNext()) {
                entry = (PersonaPromptEntry)j.next();
                atts.addAttribute("", "name", "name", "CDATA", ((PersonaPromptEntry)entry).getName());
                handler.startElement("", "entry", "entry", atts);
                atts.clear();
                k = ((PersonaPromptEntry)entry).getAll().iterator();
                while (k.hasNext()) {
                    this.promptEncoder.setSource((Prompt)k.next());
                    this.promptEncoder.encode();
                }
                handler.endElement("", "entry", "entry");
            }
            handler.endElement("", "group", "group");
        }
        handler.endElement("", "prompts", "prompts");
        handler.startElement("", "grammars", "grammars", atts);
        i = this.source.getGrammars().getGroups().iterator();
        while (i.hasNext()) {
            group = (PersonaGrammarGroup)i.next();
            atts.addAttribute("", "name", "name", "CDATA", ((PersonaGrammarGroup)group).getName());
            handler.startElement("", "group", "group", atts);
            atts.clear();
            j = ((PersonaGrammarGroup)group).getEntries().iterator();
            while (j.hasNext()) {
                entry = (PersonaGrammarEntry)j.next();
                atts.addAttribute("", "name", "name", "CDATA", ((PersonaGrammarEntry)entry).getName());
                handler.startElement("", "entry", "entry", atts);
                atts.clear();
                k = ((PersonaGrammarEntry)entry).getAll().iterator();
                while (k.hasNext()) {
                    this.grammarEncoder.setSource((Grammar)k.next());
                    this.grammarEncoder.encode();
                }
                handler.endElement("", "entry", "entry");
            }
            handler.endElement("", "group", "group");
        }
        handler.endElement("", "grammars", "grammars");
        handler.endElement("http://eclipse.org/vtp/xsd/openVXML/media/persona#1.0", "descriptor", "persona:descriptor");
        this.encodeEndNamespace("persona");
        handler.endDocument();
    }
}

