/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core;

import com.ibm.icu.text.MessageFormat;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IDebugEventFilter;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.IMemoryBlockManager;
import org.eclipse.debug.core.IProcessFactory;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.debug.internal.core.BreakpointManager;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.ExpressionManager;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.internal.core.LogicalStructureManager;
import org.eclipse.debug.internal.core.MemoryBlockManager;
import org.eclipse.debug.internal.core.sourcelookup.SourceLookupMessages;
import org.eclipse.debug.internal.core.sourcelookup.SourceLookupUtils;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DebugPlugin
extends Plugin {
    private static final String PI_DEBUG_CORE = "org.eclipse.debug.core";
    public static final String EXTENSION_POINT_LAUNCH_CONFIGURATION_TYPES = "launchConfigurationTypes";
    public static final String EXTENSION_POINT_LAUNCH_CONFIGURATION_COMPARATORS = "launchConfigurationComparators";
    public static final String EXTENSION_POINT_BREAKPOINTS = "breakpoints";
    public static final String EXTENSION_POINT_STATUS_HANDLERS = "statusHandlers";
    public static final String EXTENSION_POINT_SOURCE_LOCATORS = "sourceLocators";
    public static final String EXTENSION_POINT_LAUNCH_MODES = "launchModes";
    public static final String EXTENSION_POINT_LAUNCH_DELEGATES = "launchDelegates";
    public static final String EXTENSION_POINT_PROCESS_FACTORIES = "processFactories";
    public static final String EXTENSION_POINT_LOGICAL_STRUCTURE_TYPES = "logicalStructureTypes";
    public static final String EXTENSION_POINT_LOGICAL_STRUCTURE_PROVIDERS = "logicalStructureProviders";
    public static final String EXTENSION_POINT_SOURCE_CONTAINER_TYPES = "sourceContainerTypes";
    public static final String EXTENSION_POINT_SOURCE_PATH_COMPUTERS = "sourcePathComputers";
    public static final int INTERNAL_ERROR = 120;
    public static final int ERR_WORKING_DIRECTORY_NOT_SUPPORTED = 115;
    public static final String ATTR_PROCESS_FACTORY_ID = "process_factory_id";
    public static final String ATTR_CAPTURE_OUTPUT = "org.eclipse.debug.core.capture_output";
    private static DebugPlugin fgDebugPlugin = null;
    private BreakpointManager fBreakpointManager;
    private ExpressionManager fExpressionManager;
    private LaunchManager fLaunchManager;
    private MemoryBlockManager fMemoryBlockManager;
    private ListenerList fEventListeners = new ListenerList();
    private ListenerList fEventFilters = null;
    private boolean fShuttingDown = false;
    private int fDispatching = 0;
    private Vector fRunnables = null;
    private final Object fRunnableLock = new Object();
    private AsynchJob fAsynchJob = null;
    private HashMap fStatusHandlers = null;
    private HashMap fProcessFactories = null;
    private static final int NOTIFY_FILTERS = 0;
    private static final int NOTIFY_EVENTS = 1;
    private List fEventQueue = new ArrayList();
    private EventDispatchJob fEventDispatchJob = new EventDispatchJob();

    public static DebugPlugin getDefault() {
        return fgDebugPlugin;
    }

    private static void setDefault(DebugPlugin plugin) {
        fgDebugPlugin = plugin;
    }

    public static String getUniqueIdentifier() {
        return PI_DEBUG_CORE;
    }

    public DebugPlugin() {
        DebugPlugin.setDefault(this);
    }

    public void addDebugEventListener(IDebugEventSetListener listener) {
        this.fEventListeners.add((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDebugEventSet(DebugEvent[] events) {
        if (this.isShuttingDown() || events == null || this.fEventListeners.isEmpty()) {
            return;
        }
        List list = this.fEventQueue;
        synchronized (list) {
            this.fEventQueue.add(events);
        }
        this.fEventDispatchJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable r) {
        Object object = this.fRunnableLock;
        synchronized (object) {
            if (this.fRunnables == null) {
                this.fRunnables = new Vector(5);
                this.fAsynchJob = new AsynchJob();
            }
            this.fRunnables.add(r);
        }
        if (!this.isDispatching()) {
            this.fAsynchJob.schedule();
        }
    }

    public IBreakpointManager getBreakpointManager() {
        if (this.fBreakpointManager == null) {
            this.fBreakpointManager = new BreakpointManager();
        }
        return this.fBreakpointManager;
    }

    public ILaunchManager getLaunchManager() {
        if (this.fLaunchManager == null) {
            this.fLaunchManager = new LaunchManager();
        }
        return this.fLaunchManager;
    }

    public IMemoryBlockManager getMemoryBlockManager() {
        if (this.fMemoryBlockManager == null) {
            this.fMemoryBlockManager = new MemoryBlockManager();
        }
        return this.fMemoryBlockManager;
    }

    public IStatusHandler getStatusHandler(IStatus status) {
        IConfigurationElement config;
        StatusHandlerKey key = new StatusHandlerKey(status.getPlugin(), status.getCode());
        if (this.fStatusHandlers == null) {
            this.initializeStatusHandlers();
        }
        if ((config = (IConfigurationElement)this.fStatusHandlers.get(key)) != null) {
            try {
                Object handler = config.createExecutableExtension("class");
                if (handler instanceof IStatusHandler) {
                    return (IStatusHandler)handler;
                }
                this.invalidStatusHandler(null, MessageFormat.format((String)DebugCoreMessages.DebugPlugin_Registered_status_handler__0__does_not_implement_required_interface_IStatusHandler__1, (Object[])new String[]{config.getDeclaringExtension().getUniqueIdentifier()}));
            }
            catch (CoreException e) {
                DebugPlugin.log(e);
            }
        }
        return null;
    }

    public IExpressionManager getExpressionManager() {
        if (this.fExpressionManager == null) {
            this.fExpressionManager = new ExpressionManager();
        }
        return this.fExpressionManager;
    }

    public void removeDebugEventListener(IDebugEventSetListener listener) {
        this.fEventListeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext context) throws Exception {
        try {
            this.setShuttingDown(true);
            if (this.fAsynchJob != null) {
                this.fAsynchJob.cancel();
            }
            if (this.fLaunchManager != null) {
                this.fLaunchManager.shutdown();
            }
            if (this.fBreakpointManager != null) {
                this.fBreakpointManager.shutdown();
            }
            if (this.fMemoryBlockManager != null) {
                this.fMemoryBlockManager.shutdown();
            }
            this.fEventListeners.clear();
            if (this.fEventFilters != null) {
                this.fEventFilters = null;
            }
            SourceLookupUtils.shutdown();
            DebugPlugin.setDefault(null);
            ResourcesPlugin.getWorkspace().removeSaveParticipant((Plugin)this);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.stop(context);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        super.stop(context);
    }

    public static IProcess newProcess(ILaunch launch, Process process, String label) {
        return DebugPlugin.newProcess(launch, process, label, null);
    }

    public static IProcess newProcess(ILaunch launch, Process process, String label, Map attributes) {
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        String processFactoryID = null;
        if (config != null) {
            try {
                processFactoryID = config.getAttribute(ATTR_PROCESS_FACTORY_ID, (String)null);
            }
            catch (CoreException coreException) {}
        }
        if (processFactoryID != null) {
            IConfigurationElement element;
            DebugPlugin plugin = DebugPlugin.getDefault();
            if (plugin.fProcessFactories == null) {
                plugin.initializeProcessFactories();
            }
            if ((element = (IConfigurationElement)plugin.fProcessFactories.get(processFactoryID)) == null) {
                return null;
            }
            IProcessFactory processFactory = null;
            try {
                processFactory = (IProcessFactory)element.createExecutableExtension("class");
            }
            catch (CoreException exception) {
                DebugPlugin.log(exception);
                return null;
            }
            return processFactory.newProcess(launch, process, label, attributes);
        }
        return new RuntimeProcess(launch, process, label, attributes);
    }

    public static ILogicalStructureType[] getLogicalStructureTypes(IValue value) {
        return LogicalStructureManager.getDefault().getLogicalStructureTypes(value);
    }

    public static ILogicalStructureType getDefaultStructureType(ILogicalStructureType[] types) {
        return LogicalStructureManager.getDefault().getSelectedStructureType(types);
    }

    public static void setDefaultStructureType(ILogicalStructureType[] types, ILogicalStructureType def) {
        LogicalStructureManager.getDefault().setEnabledType(types, def);
    }

    public static Process exec(String[] cmdLine, File workingDirectory) throws CoreException {
        return DebugPlugin.exec(cmdLine, workingDirectory, null);
    }

    public static Process exec(String[] cmdLine, File workingDirectory, String[] envp) throws CoreException {
        Process p;
        block3: {
            p = null;
            try {
                p = workingDirectory == null ? Runtime.getRuntime().exec(cmdLine, envp) : Runtime.getRuntime().exec(cmdLine, envp, workingDirectory);
            }
            catch (IOException e) {
                Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, DebugCoreMessages.DebugPlugin_Exception_occurred_executing_command_line__1, (Throwable)e);
                throw new CoreException((IStatus)status);
            }
            catch (NoSuchMethodError e) {
                Object result;
                Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 115, DebugCoreMessages.DebugPlugin_Eclipse_runtime_does_not_support_working_directory_2, (Throwable)e);
                IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                if (handler == null || !((result = handler.handleStatus((IStatus)status, null)) instanceof Boolean) || !((Boolean)result).booleanValue()) break block3;
                p = DebugPlugin.exec(cmdLine, null);
            }
        }
        return p;
    }

    private boolean isShuttingDown() {
        return this.fShuttingDown;
    }

    private void setShuttingDown(boolean value) {
        this.fShuttingDown = value;
    }

    private Object[] getEventListeners() {
        return this.fEventListeners.getListeners();
    }

    public void addDebugEventFilter(IDebugEventFilter filter) {
        if (this.fEventFilters == null) {
            this.fEventFilters = new ListenerList();
        }
        this.fEventFilters.add((Object)filter);
    }

    public void removeDebugEventFilter(IDebugEventFilter filter) {
        if (this.fEventFilters != null) {
            this.fEventFilters.remove((Object)filter);
            if (this.fEventFilters.size() == 0) {
                this.fEventFilters = null;
            }
        }
    }

    public static void logDebugMessage(String message) {
        if (DebugPlugin.getDefault().isDebugging()) {
            DebugPlugin.log((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 120, "Internal message logged from Debug Core: " + message, null));
        }
    }

    public static void logMessage(String message, Throwable throwable) {
        DebugPlugin.log((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 120, message, throwable));
    }

    public static void log(IStatus status) {
        DebugPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable t) {
        Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, "Error logged from Debug Core: ", t);
        DebugPlugin.log((IStatus)status);
    }

    private void initializeStatusHandlers() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PI_DEBUG_CORE, EXTENSION_POINT_STATUS_HANDLERS);
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        this.fStatusHandlers = new HashMap(infos.length);
        int i = 0;
        while (i < infos.length) {
            IConfigurationElement configurationElement = infos[i];
            String id = configurationElement.getAttribute("plugin");
            String code = configurationElement.getAttribute("code");
            if (id != null && code != null) {
                try {
                    StatusHandlerKey key = new StatusHandlerKey(id, Integer.parseInt(code));
                    this.fStatusHandlers.put(key, configurationElement);
                }
                catch (NumberFormatException e) {
                    this.invalidStatusHandler(e, configurationElement.getAttribute("id"));
                }
            } else {
                this.invalidStatusHandler(null, configurationElement.getAttribute("id"));
            }
            ++i;
        }
    }

    private void initializeProcessFactories() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PI_DEBUG_CORE, EXTENSION_POINT_PROCESS_FACTORIES);
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        this.fProcessFactories = new HashMap(infos.length);
        int i = 0;
        while (i < infos.length) {
            IConfigurationElement configurationElement = infos[i];
            String id = configurationElement.getAttribute("id");
            String clss = configurationElement.getAttribute("class");
            if (id != null && clss != null) {
                this.fProcessFactories.put(id, configurationElement);
            } else {
                String badDefiner = infos[i].getContributor().getName();
                DebugPlugin.log((IStatus)new Status(4, PI_DEBUG_CORE, 120, MessageFormat.format((String)DebugCoreMessages.DebugPlugin_31, (Object[])new String[]{badDefiner, id}), null));
            }
            ++i;
        }
    }

    private void invalidStatusHandler(Exception e, String id) {
        DebugPlugin.log((IStatus)new Status(4, PI_DEBUG_CORE, 120, MessageFormat.format((String)DebugCoreMessages.DebugPlugin_Invalid_status_handler_extension___0__2, (Object[])new String[]{id}), (Throwable)e));
    }

    private boolean hasEventFilters() {
        return this.fEventFilters != null && this.fEventFilters.size() > 0;
    }

    private synchronized void setDispatching(boolean dispatching) {
        this.fDispatching = dispatching ? ++this.fDispatching : --this.fDispatching;
        if (!this.isDispatching() && this.fAsynchJob != null) {
            this.fAsynchJob.schedule();
        }
    }

    private synchronized boolean isDispatching() {
        return this.fDispatching > 0;
    }

    public static Document newDocument() throws CoreException {
        try {
            return LaunchManager.getDocument();
        }
        catch (ParserConfigurationException e) {
            DebugPlugin.abort(SourceLookupMessages.SourceLookupUtils_3, e);
            return null;
        }
    }

    public static String serializeDocument(Document document) throws CoreException {
        try {
            return LaunchManager.serializeDocument(document);
        }
        catch (TransformerException e) {
            DebugPlugin.abort(SourceLookupMessages.SourceLookupUtils_4, e);
        }
        catch (IOException e) {
            DebugPlugin.abort(SourceLookupMessages.SourceLookupUtils_5, e);
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Element parseDocument(String document) throws CoreException {
        Element root = null;
        InputStream stream = null;
        try {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                stream = new ByteArrayInputStream(document.getBytes());
                root = parser.parse(stream).getDocumentElement();
            }
            catch (ParserConfigurationException e) {
                DebugPlugin.abort(SourceLookupMessages.SourceLookupUtils_6, e);
            }
            catch (FactoryConfigurationError e) {
                DebugPlugin.abort(SourceLookupMessages.SourceLookupUtils_7, e);
            }
            catch (SAXException e) {
                DebugPlugin.abort(SourceLookupMessages.SourceLookupUtils_8, e);
            }
            catch (IOException e) {
                DebugPlugin.abort(SourceLookupMessages.SourceLookupUtils_9, e);
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            try {
                if (stream == null) throw throwable;
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                DebugPlugin.abort(SourceLookupMessages.SourceLookupUtils_10, e);
            }
            throw throwable;
        }
        {
            Object var4_10 = null;
        }
        try {}
        catch (IOException e) {
            DebugPlugin.abort(SourceLookupMessages.SourceLookupUtils_10, e);
            return root;
        }
        if (stream == null) return root;
        stream.close();
        return root;
    }

    private static void abort(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, message, exception);
        throw new CoreException((IStatus)status);
    }

    public static String[] parseArguments(String args) {
        if (args == null) {
            return new String[0];
        }
        ArgumentParser parser = new ArgumentParser(args);
        String[] res = parser.parseArguments();
        return res;
    }

    private static class ArgumentParser {
        private String fArgs;
        private int fIndex = 0;
        private int ch = -1;

        public ArgumentParser(String args) {
            this.fArgs = args;
        }

        public String[] parseArguments() {
            ArrayList<String> v = new ArrayList<String>();
            this.ch = this.getNext();
            while (this.ch > 0) {
                if (Character.isWhitespace((char)this.ch)) {
                    this.ch = this.getNext();
                    continue;
                }
                if (this.ch == 34) {
                    StringBuffer buf = new StringBuffer();
                    buf.append(this.parseString());
                    if (buf.length() == 0 && Platform.getOS().equals("win32")) {
                        buf.append("\"\"");
                    }
                    v.add(buf.toString());
                    continue;
                }
                v.add(this.parseToken());
            }
            String[] result = new String[v.size()];
            v.toArray(result);
            return result;
        }

        private int getNext() {
            if (this.fIndex < this.fArgs.length()) {
                return this.fArgs.charAt(this.fIndex++);
            }
            return -1;
        }

        private String parseString() {
            this.ch = this.getNext();
            if (this.ch == 34) {
                this.ch = this.getNext();
                return "";
            }
            StringBuffer buf = new StringBuffer();
            while (this.ch > 0 && this.ch != 34) {
                if (this.ch == 92) {
                    this.ch = this.getNext();
                    if (this.ch != 34) {
                        buf.append('\\');
                    } else if (Platform.getOS().equals("win32")) {
                        buf.append('\\');
                    }
                }
                if (this.ch <= 0) continue;
                buf.append((char)this.ch);
                this.ch = this.getNext();
            }
            this.ch = this.getNext();
            return buf.toString();
        }

        private String parseToken() {
            StringBuffer buf = new StringBuffer();
            while (this.ch > 0 && !Character.isWhitespace((char)this.ch)) {
                if (this.ch == 92) {
                    this.ch = this.getNext();
                    if (Character.isWhitespace((char)this.ch)) {
                        buf.append('\\');
                        return buf.toString();
                    }
                    if (this.ch > 0) {
                        if (this.ch != 34) {
                            buf.append('\\');
                        } else if (Platform.getOS().equals("win32")) {
                            buf.append('\\');
                        }
                        buf.append((char)this.ch);
                        this.ch = this.getNext();
                        continue;
                    }
                    if (this.ch != -1) continue;
                    buf.append('\\');
                    continue;
                }
                if (this.ch == 34) {
                    buf.append(this.parseString());
                    continue;
                }
                buf.append((char)this.ch);
                this.ch = this.getNext();
            }
            return buf.toString();
        }
    }

    class AsynchJob
    extends Job {
        public AsynchJob() {
            super(DebugCoreMessages.DebugPlugin_Debug_async_queue_1);
            this.setPriority(10);
            this.setSystem(true);
        }

        public boolean shouldRun() {
            return !DebugPlugin.this.fShuttingDown && !DebugPlugin.this.fRunnables.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            Vector v = null;
            Object object = DebugPlugin.this.fRunnableLock;
            synchronized (object) {
                v = DebugPlugin.this.fRunnables;
                DebugPlugin.this.fRunnables = new Vector(5);
            }
            MultiStatus failed = null;
            monitor.beginTask(DebugCoreMessages.DebugPlugin_Debug_async_queue_1, v.size());
            Iterator iter = v.iterator();
            while (iter.hasNext() && !DebugPlugin.this.fShuttingDown && !monitor.isCanceled()) {
                Runnable r = (Runnable)iter.next();
                try {
                    r.run();
                }
                catch (Exception e) {
                    if (failed == null) {
                        failed = new MultiStatus(DebugPlugin.getUniqueIdentifier(), 120, DebugCoreMessages.DebugPlugin_0, null);
                    }
                    failed.add((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 120, DebugCoreMessages.DebugPlugin_0, (Throwable)e));
                }
                monitor.worked(1);
            }
            monitor.done();
            if (failed == null) {
                return Status.OK_STATUS;
            }
            return failed;
        }
    }

    class EventDispatchJob
    extends Job {
        EventNotifier fNotifier;

        public EventDispatchJob() {
            super(DebugCoreMessages.DebugPlugin_1);
            this.fNotifier = new EventNotifier();
            this.setPriority(10);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            while (!DebugPlugin.this.fEventQueue.isEmpty()) {
                DebugEvent[] events = null;
                List list = DebugPlugin.this.fEventQueue;
                synchronized (list) {
                    if (!DebugPlugin.this.fEventQueue.isEmpty()) {
                        events = (DebugEvent[])DebugPlugin.this.fEventQueue.remove(0);
                    }
                }
                if (events == null) continue;
                this.fNotifier.dispatch(events);
            }
            return Status.OK_STATUS;
        }

        public boolean shouldRun() {
            return this.shouldSchedule();
        }

        public boolean shouldSchedule() {
            return !DebugPlugin.this.isShuttingDown() && !DebugPlugin.this.fEventListeners.isEmpty();
        }
    }

    class EventNotifier
    implements ISafeRunnable {
        private DebugEvent[] fEvents;
        private IDebugEventSetListener fListener;
        private IDebugEventFilter fFilter;
        private int fMode;

        EventNotifier() {
        }

        public void handleException(Throwable exception) {
            switch (this.fMode) {
                case 0: {
                    Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, DebugCoreMessages.DebugPlugin_An_exception_occurred_while_filtering_debug_events__3, exception);
                    DebugPlugin.log((IStatus)status);
                    break;
                }
                case 1: {
                    Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 120, DebugCoreMessages.DebugPlugin_An_exception_occurred_while_dispatching_debug_events__2, exception);
                    DebugPlugin.log((IStatus)status);
                }
            }
        }

        public void run() throws Exception {
            switch (this.fMode) {
                case 0: {
                    this.fEvents = this.fFilter.filterDebugEvents(this.fEvents);
                    break;
                }
                case 1: {
                    this.fListener.handleDebugEvents(this.fEvents);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void dispatch(DebugEvent[] events) {
            block7: {
                block6: {
                    this.fEvents = events;
                    try {
                        int i;
                        block8: {
                            DebugPlugin.this.setDispatching(true);
                            if (!DebugPlugin.this.hasEventFilters()) break block8;
                            this.fMode = 0;
                            Object[] filters = DebugPlugin.this.fEventFilters.getListeners();
                            i = 0;
                            while (i < filters.length) {
                                block10: {
                                    block9: {
                                        this.fFilter = (IDebugEventFilter)filters[i];
                                        SafeRunner.run((ISafeRunnable)this);
                                        if (this.fEvents == null) break block9;
                                        if (this.fEvents.length != 0) break block10;
                                    }
                                    Object var4_4 = null;
                                    break block6;
                                }
                                ++i;
                            }
                        }
                        this.fMode = 1;
                        Object[] listeners = DebugPlugin.this.getEventListeners();
                        i = 0;
                        while (i < listeners.length) {
                            this.fListener = (IDebugEventSetListener)listeners[i];
                            SafeRunner.run((ISafeRunnable)this);
                            ++i;
                        }
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        DebugPlugin.this.setDispatching(false);
                        throw throwable;
                    }
                }
                DebugPlugin.this.setDispatching(false);
                return;
            }
            Object var4_6 = null;
            DebugPlugin.this.setDispatching(false);
            this.fEvents = null;
            this.fFilter = null;
            this.fListener = null;
        }
    }

    class StatusHandlerKey {
        String fPluginId;
        int fCode;

        StatusHandlerKey(String pluginId, int code) {
            this.fPluginId = pluginId;
            this.fCode = code;
        }

        public int hashCode() {
            return this.fPluginId.hashCode() + this.fCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof StatusHandlerKey) {
                StatusHandlerKey s = (StatusHandlerKey)obj;
                return this.fCode == s.fCode && this.fPluginId.equals(s.fPluginId);
            }
            return false;
        }
    }
}

