/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.internal.events.BuilderPersistentInfo;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.SavedState;
import org.eclipse.core.internal.resources.Synchronizer;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.resources.WorkspaceTreeReader;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeReader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class WorkspaceTreeReader_1
extends WorkspaceTreeReader {
    protected Workspace workspace;

    public WorkspaceTreeReader_1(Workspace workspace) {
        this.workspace = workspace;
    }

    protected int getVersion() {
        return 67305985;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void linkBuildersToTrees(List buildersToBeLinked, ElementTree[] trees, int index, IProgressMonitor monitor) {
        monitor = Policy.monitorFor(monitor);
        try {
            ArrayList<BuilderPersistentInfo> infos = null;
            String projectName = null;
            int i = 0;
            while (true) {
                block7: {
                    if (i < buildersToBeLinked.size()) break block7;
                    if (infos != null) {
                        IProject project = this.workspace.getRoot().getProject(projectName);
                        this.workspace.getBuildManager().setBuildersPersistentInfo(project, infos);
                    }
                    break;
                }
                BuilderPersistentInfo info = (BuilderPersistentInfo)buildersToBeLinked.get(i);
                if (!info.getProjectName().equals(projectName)) {
                    if (infos != null) {
                        IProject project = this.workspace.getRoot().getProject(projectName);
                        this.workspace.getBuildManager().setBuildersPersistentInfo(project, infos);
                    }
                    projectName = info.getProjectName();
                    infos = new ArrayList<BuilderPersistentInfo>(5);
                }
                info.setLastBuildTree(trees[index++]);
                infos.add(info);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void linkPluginsSavedStateToTrees(List states, ElementTree[] trees, IProgressMonitor monitor) {
        monitor = Policy.monitorFor(monitor);
        try {
            int i = 0;
            while (i < states.size()) {
                SavedState state = (SavedState)states.get(i);
                if (!this.workspace.getSaveManager().isOldPluginTree(state.pluginId)) {
                    state.oldTree = trees[i];
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        monitor.done();
    }

    protected BuilderPersistentInfo readBuilderInfo(IProject project, DataInputStream input, int index) throws IOException {
        String projectName = input.readUTF();
        if (project != null) {
            projectName = project.getName();
        }
        String builderName = input.readUTF();
        return new BuilderPersistentInfo(projectName, builderName, index);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readBuildersPersistentInfo(IProject project, DataInputStream input, List builders, IProgressMonitor monitor) throws IOException {
        monitor = Policy.monitorFor(monitor);
        try {
            int builderCount = input.readInt();
            int i = 0;
            while (i < builderCount) {
                builders.add(this.readBuilderInfo(project, input, i));
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readPluginsSavedStates(DataInputStream input, HashMap savedStates, List plugins, IProgressMonitor monitor) throws IOException, CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            int stateCount = input.readInt();
            int i = 0;
            while (i < stateCount) {
                String pluginId = input.readUTF();
                SavedState state = new SavedState(this.workspace, pluginId, null, null);
                savedStates.put(pluginId, state);
                plugins.add(state);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        monitor.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ElementTree readSnapshotTree(DataInputStream input, ElementTree complete, IProgressMonitor monitor) throws CoreException {
        ElementTree elementTree;
        block12: {
            ElementTree elementTree2;
            block11: {
                monitor = Policy.monitorFor(monitor);
                try {
                    try {
                        String message = Messages.resources_readingSnap;
                        monitor.beginTask(message, 100);
                        ElementTreeReader reader = new ElementTreeReader(this.workspace.getSaveManager());
                        while (input.available() > 0) {
                            this.readWorkspaceFields(input, Policy.subMonitorFor(monitor, 50));
                            complete = reader.readDelta(complete, input);
                            try {
                                int version = input.readInt();
                                if (version == this.getVersion()) continue;
                                elementTree2 = WorkspaceTreeReader.getReader(this.workspace, version).readSnapshotTree(input, complete, monitor);
                            }
                            catch (EOFException eOFException) {
                                break;
                            }
                            Object var7_11 = null;
                            break block11;
                        }
                        elementTree = complete;
                        break block12;
                    }
                    catch (IOException e) {
                        String message = Messages.resources_readWorkspaceSnap;
                        throw new ResourceException(567, null, message, e);
                    }
                }
                catch (Throwable throwable) {
                    Object var7_13 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return elementTree2;
        }
        Object var7_12 = null;
        monitor.done();
        return elementTree;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readTree(DataInputStream input, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            try {
                String message = Messages.resources_reading;
                monitor.beginTask(message, 100);
                this.readWorkspaceFields(input, Policy.subMonitorFor(monitor, Policy.opWork * 20 / 100));
                HashMap savedStates = new HashMap(20);
                ArrayList pluginsToBeLinked = new ArrayList(20);
                this.readPluginsSavedStates(input, savedStates, pluginsToBeLinked, Policy.subMonitorFor(monitor, Policy.opWork * 10 / 100));
                this.workspace.getSaveManager().setPluginsSavedState(savedStates);
                ArrayList buildersToBeLinked = new ArrayList(20);
                this.readBuildersPersistentInfo(null, input, buildersToBeLinked, Policy.subMonitorFor(monitor, Policy.opWork * 10 / 100));
                ElementTree[] trees = this.readTrees((IPath)Path.ROOT, input, Policy.subMonitorFor(monitor, Policy.opWork * 40 / 100));
                this.linkPluginsSavedStateToTrees(pluginsToBeLinked, trees, Policy.subMonitorFor(monitor, Policy.opWork * 10 / 100));
                this.linkBuildersToTrees(buildersToBeLinked, trees, pluginsToBeLinked.size(), Policy.subMonitorFor(monitor, Policy.opWork * 10 / 100));
            }
            catch (IOException e) {
                String message = Messages.resources_readWorkspaceTree;
                throw new ResourceException(567, null, message, e);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var8_12 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readTree(IProject project, DataInputStream input, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            try {
                block10: {
                    ElementTree[] trees;
                    String message = Messages.resources_reading;
                    monitor.beginTask(message, 10);
                    int numBuilders = input.readInt();
                    String[] builderNames = new String[numBuilders];
                    int i = 0;
                    while (true) {
                        String builderName;
                        if (i >= numBuilders) {
                            monitor.worked(1);
                            trees = this.readTrees(project.getFullPath(), input, Policy.subMonitorFor(monitor, 8));
                            if (numBuilders > 0) {
                                break;
                            }
                            break block10;
                        }
                        builderNames[i] = builderName = input.readUTF();
                        ++i;
                    }
                    ArrayList<BuilderPersistentInfo> infos = new ArrayList<BuilderPersistentInfo>(trees.length * 2 + 1);
                    int i2 = 0;
                    while (true) {
                        if (i2 >= numBuilders) {
                            this.workspace.getBuildManager().setBuildersPersistentInfo(project, infos);
                            break;
                        }
                        BuilderPersistentInfo info = new BuilderPersistentInfo(project.getName(), builderNames[i2], -1);
                        info.setLastBuildTree(trees[i2]);
                        infos.add(info);
                        ++i2;
                    }
                }
                monitor.worked(1);
            }
            catch (IOException e) {
                String message = Messages.resources_readProjectTree;
                throw new ResourceException(567, null, message, e);
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var11_16 = null;
        }
        monitor.done();
    }

    protected ElementTree[] readTrees(IPath root, DataInputStream input, IProgressMonitor monitor) throws IOException {
        ElementTree[] elementTreeArray;
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Messages.resources_reading;
            monitor.beginTask(message, 4);
            ElementTreeReader treeReader = new ElementTreeReader(this.workspace.getSaveManager());
            ElementTree[] trees = treeReader.readDeltaChain(input);
            monitor.worked(3);
            if (root.isRoot()) {
                ElementTree newTree = trees[trees.length - 1];
                newTree.setTreeData(this.workspace.tree.getTreeData());
                this.workspace.tree = newTree;
            } else {
                this.workspace.linkTrees(root, trees);
            }
            monitor.worked(1);
            elementTreeArray = trees;
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return elementTreeArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readWorkspaceFields(DataInputStream input, IProgressMonitor monitor) throws IOException, CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            this.workspace.nextNodeId = input.readLong();
            input.readLong();
            this.workspace.nextMarkerId = input.readLong();
            ((Synchronizer)this.workspace.getSynchronizer()).readPartners(input);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        monitor.done();
    }
}

