/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.infoserv.spi;

import org.eclipse.vtp.framework.infoserv.spi.Rule;

public class CategoryAndSeverityRule
extends Rule {
    private int severity = 0;
    private String category;

    public CategoryAndSeverityRule(String category, int severity, int action) {
        super(action);
        if (severity < 0 || severity > 3) {
            throw new IllegalArgumentException("Severity must be 0 (error), 1 (warning), 2 (info), or 3 (debug).  Received " + severity);
        }
        this.severity = severity;
        if (category == null) {
            throw new IllegalArgumentException("Category must not be null");
        }
        this.category = category;
    }

    public boolean matches(String[] categories, int severity) {
        if (severity > this.severity && this.isAllowed()) {
            return false;
        }
        if (severity < this.severity && !this.isAllowed()) {
            return false;
        }
        int i = 0;
        while (i < categories.length) {
            if (this.category.equals(categories[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Rule deepCopy() {
        int action = 0;
        if (this.isAllowed()) {
            ++action;
        }
        if (this.isFinite()) {
            action += 2;
        }
        return new CategoryAndSeverityRule(this.category, this.severity, action);
    }
}

