/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.infoserv.spi;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.vtp.framework.infoserv.spi.Rule;

public class RuleSet {
    private boolean defaultAction = false;
    private List finiteRules = new LinkedList();
    private List assumeRules = new LinkedList();

    public void setDefaultAction(boolean allow) {
        this.defaultAction = allow;
    }

    public void addRule(Rule rule) {
        if (rule.isFinite()) {
            this.finiteRules.add(rule);
        } else {
            this.assumeRules.add(rule);
        }
    }

    public boolean accept(String[] categories, int severity) {
        int i = 0;
        while (i < this.finiteRules.size()) {
            if (((Rule)this.finiteRules.get(i)).matches(categories, severity)) {
                return ((Rule)this.finiteRules.get(i)).isAllowed();
            }
            ++i;
        }
        boolean allowed = this.defaultAction;
        int i2 = 0;
        while (i2 < this.assumeRules.size()) {
            if (((Rule)this.assumeRules.get(i2)).matches(categories, severity)) {
                allowed = ((Rule)this.assumeRules.get(i2)).isAllowed();
            }
            ++i2;
        }
        return allowed;
    }

    public RuleSet deepCopy() {
        RuleSet rs = new RuleSet();
        rs.setDefaultAction(this.defaultAction);
        int i = 0;
        while (i < this.finiteRules.size()) {
            rs.addRule(((Rule)this.finiteRules.get(i)).deepCopy());
            ++i;
        }
        i = 0;
        while (i < this.assumeRules.size()) {
            rs.addRule(((Rule)this.assumeRules.get(i)).deepCopy());
            ++i;
        }
        return rs;
    }
}

